/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ScrolledPageContent;
import org.eclipse.wst.xsl.ui.internal.Messages;
import org.eclipse.wst.xsl.ui.internal.preferences.AbstractXSLPreferencePage;

@Deprecated
public class ValidationPreferencePage
extends AbstractXSLPreferencePage {
    private static final String[] ERRORS = new String[]{Messages.ErrorLevelText, Messages.WarningLevelText, Messages.IgnoreLevelText};
    private static final int[] ERROR_VALUES;
    private static final Map<Integer, Integer> ERROR_MAP;
    private Text maxErrorsText;
    private Map<String, Combo> combos = new HashMap<String, Combo>();

    static {
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[1] = 1;
        ERROR_VALUES = nArray;
        ERROR_MAP = new HashMap<Integer, Integer>();
        ERROR_MAP.put(2, 0);
        ERROR_MAP.put(1, 1);
        ERROR_MAP.put(0, 2);
    }

    public ValidationPreferencePage() {
        this.setTitle(Messages.XSLValidationPreferencePageTitle);
        this.setDescription(Messages.XSLValidationPreferencePageDescription);
    }

    protected Composite createCommonContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        pageContent.setLayoutData((Object)new GridData(1808));
        pageContent.setExpandHorizontal(true);
        pageContent.setExpandVertical(true);
        Composite body = pageContent.getBody();
        body.setLayout((Layout)layout);
        this.createLabel(body, Messages.XSLValidationPreferenceMaxErrorsLabel);
        this.maxErrorsText = this.createTextField(body);
        this.maxErrorsText.addModifyListener((ModifyListener)this);
        Composite twistie = this.createTwistie(body, Messages.XSLValidationPreferenceImportsIncludesLabel, 2);
        this.createCombo(twistie, Messages.XSLValidationPreferenceUnresolveImportIncludeLabel, "MISSING_INCLUDE");
        this.createCombo(twistie, Messages.XSLValidationPreferenceCircularReferencesLabel, "CIRCULAR_REF");
        twistie = this.createTwistie(body, Messages.XSLValidationPreferenceNamedTemplatesLabel, 2);
        this.createCombo(twistie, Messages.XSLValidationPreferenceTemplateConflictsLabel, "TEMPLATE_CONFLICT");
        this.createCombo(twistie, Messages.XSLValidationPreferenceDuplicateParameterLabel, "DUPLICATE_PARAMETER");
        this.createCombo(twistie, Messages.XSLValidationPreferenceMissingParameterAttributeLabel, "NAME_ATTRIBUTE_MISSING");
        this.createCombo(twistie, Messages.XSLValidationPreferenceParameterEmptyAttributeLabel, "NAME_ATTRIBUTE_EMPTY");
        twistie = this.createTwistie(body, Messages.XSLValidationPreferenceCallTemplatesLabel, 2);
        this.createCombo(twistie, Messages.XSLValidationPreferenceUnresolvedTemplatesLabel, "CHECK_CALL_TEMPLATES");
        this.createCombo(twistie, Messages.XSLValidationPreferenceMissingParamtersLabel, "MISSING_PARAM");
        this.createCombo(twistie, Messages.XSLValidationPreferenceParamtersWithoutValueLabel, "EMPTY_PARAM");
        twistie = this.createTwistie(body, Messages.XSLValidationPreferenceXPathLabel, 2);
        this.createCombo(twistie, Messages.XSLValidationPreferenceXPathSyntaxLabel, "CHECK_XPATHS");
        return parent;
    }

    protected Combo createCombo(Composite parent, String label, String prefKey) {
        Combo combo = super.createCombo(parent, label, prefKey);
        combo.setItems(ERRORS);
        this.combos.put(prefKey, combo);
        return combo;
    }

    protected void initializeValues() {
        int maxErrors = this.getModelPreferences().getInt("MAX_ERRORS");
        this.maxErrorsText.setText(String.valueOf(maxErrors));
        for (Map.Entry<String, Combo> entry : this.combos.entrySet()) {
            int val = this.getModelPreferences().getInt(entry.getKey());
            entry.getValue().select(ERROR_MAP.get(val).intValue());
        }
    }

    protected void storeValues() {
        int maxErrors = Integer.parseInt(this.maxErrorsText.getText());
        this.getModelPreferences().setValue("MAX_ERRORS", maxErrors);
        for (Map.Entry<String, Combo> entry : this.combos.entrySet()) {
            int index = entry.getValue().getSelectionIndex();
            this.getModelPreferences().setValue(entry.getKey(), ERROR_VALUES[index]);
        }
    }

    protected void validateValues() {
        String errorMessage = null;
        try {
            int maxErrors = Integer.parseInt(this.maxErrorsText.getText());
            if (maxErrors < 0) {
                errorMessage = Messages.XSLValidationPreferenceMaxErrorsMsgError;
            }
        }
        catch (NumberFormatException numberFormatException) {
            errorMessage = Messages.XSLValidationPreferenceMaxErrorsMsgError;
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
    }

    protected void performDefaults() {
        int maxErrors = this.getModelPreferences().getDefaultInt("MAX_ERRORS");
        this.maxErrorsText.setText(String.valueOf(maxErrors));
        for (Map.Entry<String, Combo> entry : this.combos.entrySet()) {
            int def = this.getModelPreferences().getDefaultInt(entry.getKey());
            entry.getValue().select(ERROR_MAP.get(def).intValue());
        }
        super.performDefaults();
    }
}

