/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentoutline;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.editor.EditorPluginImageHelper;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.views.contentoutline.XMLContentOutlineConfiguration;
import org.eclipse.wst.xsl.ui.internal.contentoutline.AttributeShowingLabelProvider;
import org.eclipse.wst.xsl.ui.internal.contentoutline.JFaceNodeContentProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class XSLContentOutlineConfiguration
extends XMLContentOutlineConfiguration {
    static final String ATTR_NAME = "name";
    static final String ATTR_ID = "id";
    private AttributeShowingLabelProvider fAttributeShowingLabelProvider;
    private IContentProvider fContentProvider = null;
    boolean fShowAttributes = false;
    private static final String OUTLINE_SHOW_ATTRIBUTE_PREF = "outline-show-attribute";

    public XSLContentOutlineConfiguration() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getDefaultString("outline-behavior.document-node").length() == 0) {
            store.setDefault("outline-behavior.document-node", "1, true");
        }
        if (store.getDefaultString("outline-behavior.instruction-node").length() == 0) {
            store.setDefault("outline-behavior.instruction-node", "2, true");
        }
        if (store.getDefaultString("outline-behavior.document-type-node").length() == 0) {
            store.setDefault("outline-behavior.document-type-node", "3, true");
        }
        if (store.getDefaultString("outline-behavior.document-fragment-node").length() == 0) {
            store.setDefault("outline-behavior.document-fragment-node", "4, true");
        }
        if (store.getDefaultString("outline-behavior.comment-node").length() == 0) {
            store.setDefault("outline-behavior.comment-node", "5, true");
        }
        if (store.getDefaultString("outline-behavior.attribute-node").length() == 0) {
            store.setDefault("outline-behavior.attribute-node", "6, false");
        }
        if (store.getDefaultString("outline-behavior.element-node").length() == 0) {
            store.setDefault("outline-behavior.element-node", "7, true");
        }
        if (store.getDefaultString("outline-behavior.entity-reference-node").length() == 0) {
            store.setDefault("outline-behavior.entity-reference-node", "8, true");
        }
        if (store.getDefaultString("outline-behavior.cdata-section-node").length() == 0) {
            store.setDefault("outline-behavior.cdata-section-node", "9, true");
        }
        if (store.getDefaultString("outline-behavior.entity-node").length() == 0) {
            store.setDefault("outline-behavior.entity-node", "10, true");
        }
        if (store.getDefaultString("outline-behavior.notation-node").length() == 0) {
            store.setDefault("outline-behavior.notation-node", "11, true");
        }
        if (store.getDefaultString("outline-behavior.text-node").length() == 0) {
            store.setDefault("outline-behavior.text-node", "12, false");
        }
    }

    protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
        PropertyChangeUpdateActionContributionItem showAttributeItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)new ToggleShowAttributeAction(this.getPreferenceStore(), OUTLINE_SHOW_ATTRIBUTE_PREF, viewer));
        IContributionItem[] items = super.createMenuContributions(viewer);
        if (items == null) {
            items = new IContributionItem[]{showAttributeItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 1];
            System.arraycopy(items, 0, combinedItems, 0, items.length);
            combinedItems[items.length] = showAttributeItem;
            items = combinedItems;
        }
        return items;
    }

    protected void enableShowAttributes(boolean showAttributes, TreeViewer treeViewer) {
        if (this.fAttributeShowingLabelProvider != null) {
            this.fAttributeShowingLabelProvider.setShowAttributes(showAttributes);
        }
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.fContentProvider == null) {
            this.fContentProvider = new JFaceNodeContentProvider();
        }
        return this.fContentProvider;
    }

    private Object getFilteredNode(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            short nodeType = node.getNodeType();
            if (nodeType == 2) {
                node = ((Attr)node).getOwnerElement();
            } else if (nodeType == 3 || nodeType == 8) {
                node = node.getParentNode();
            }
            return node;
        }
        return object;
    }

    private Object[] getFilteredNodes(Object[] filteredNodes) {
        int i = 0;
        while (i < filteredNodes.length) {
            filteredNodes[i] = this.getFilteredNode(filteredNodes[i]);
            ++i;
        }
        return filteredNodes;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fAttributeShowingLabelProvider == null) {
            this.fAttributeShowingLabelProvider = new AttributeShowingLabelProvider(this.fShowAttributes);
        }
        return this.fAttributeShowingLabelProvider;
    }

    public ISelection getSelection(TreeViewer viewer, ISelection selection) {
        ISelection filteredSelection = selection;
        if (selection instanceof IStructuredSelection) {
            Object[] filteredNodes = this.getFilteredNodes(((IStructuredSelection)selection).toArray());
            filteredSelection = new StructuredSelection(filteredNodes);
        }
        return filteredSelection;
    }

    private class ToggleShowAttributeAction
    extends PropertyChangeUpdateAction {
        private TreeViewer fTreeViewer;

        public ToggleShowAttributeAction(IPreferenceStore store, String preference, TreeViewer treeViewer) {
            super(XMLUIMessages.XMLContentOutlineConfiguration_0, store, preference, true);
            this.setToolTipText(this.getText());
            this.setImageDescriptor(EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/prop_ps.gif"));
            this.fTreeViewer = treeViewer;
            this.update();
        }

        public void update() {
            super.update();
            XSLContentOutlineConfiguration.this.fShowAttributes = this.isChecked();
            XSLContentOutlineConfiguration.this.enableShowAttributes(XSLContentOutlineConfiguration.this.fShowAttributes, this.fTreeViewer);
            this.fTreeViewer.refresh(true);
        }
    }
}

