/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.ui.widgets;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.creation.ui.CXFCreationUIMessages;
import org.eclipse.jst.ws.internal.cxf.creation.ui.CXFCreationUIPlugin;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.Java2WSWidgetFactory;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCorePlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class Java2WSClassConfigWidget
extends SimpleWidgetDataContributor {
    private IStatus JAVA_TYPE_NAME_STATUS = Status.OK_STATUS;
    private IStatus JAVA_TYPE_EXISTS_STATUS = Status.OK_STATUS;
    private IStatus SEI_SELECTION_STATUS = Status.OK_STATUS;
    private static final String NAME = "name";
    private int NUMBER_OF_PUBLIC_METHODS;
    private int NUMBER_OF_CHECKED_METHODS;
    private IMethod[] publicMethods;
    private Button useSEIButton;
    private Button selectSEIButton;
    private Button browseSEIButton;
    private Button extractSEIButton;
    private Combo selectSEICombo;
    private Text seiInterfaceNameText;
    private CheckboxTableViewer seiMembersToExtractTableViewer;
    private Table seiMembersToExtractTable;
    private Button selectAllButton;
    private Button deselectAllButton;
    private Java2WSDataModel model;
    private IType startingPointType;

    public void setJava2WSDataModel(Java2WSDataModel model) {
        this.model = model;
    }

    public void setJavaStartingPointType(IType startingPointType) {
        this.startingPointType = startingPointType;
    }

    public void internalize() {
        boolean useSEI = this.model.isUseServiceEndpointInterface();
        this.useSEIButton.setSelection(useSEI);
        this.selectSEIButton.setSelection(useSEI);
        this.selectSEIButton.setEnabled(useSEI);
        if (!useSEI) {
            this.selectSEICombo.deselectAll();
        }
        this.enableSelectSEIControls(useSEI);
        this.extractSEIButton.setSelection(false);
        this.extractSEIButton.setEnabled(useSEI);
        this.enableExtractSEIControls(useSEI);
        this.seiInterfaceNameText.setText("");
        this.seiMembersToExtractTableViewer.setAllChecked(false);
        this.NUMBER_OF_CHECKED_METHODS = 0;
        this.validateSEISelection();
    }

    public WidgetDataEvents addControls(Composite parent, final Listener statusListener) {
        final Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)gridData);
        this.useSEIButton = Java2WSWidgetFactory.createUseSEIButton((Composite)composite);
        this.useSEIButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean useSEI = Java2WSClassConfigWidget.this.useSEIButton.getSelection();
                Java2WSClassConfigWidget.this.model.setUseServiceEndpointInterface(useSEI);
                Java2WSClassConfigWidget.this.selectSEIButton.setEnabled(useSEI);
                Java2WSClassConfigWidget.this.extractSEIButton.setEnabled(useSEI);
                Java2WSClassConfigWidget.this.updateSEISelectionStatus();
                statusListener.handleEvent(null);
                if (!useSEI) {
                    Java2WSClassConfigWidget.this.model.setServiceEndpointInterfaceName("");
                    Java2WSClassConfigWidget.this.selectSEIButton.setSelection(false);
                    Java2WSClassConfigWidget.this.enableSelectSEIControls(false);
                    Java2WSClassConfigWidget.this.extractSEIButton.setSelection(false);
                    Java2WSClassConfigWidget.this.enableExtractSEIControls(false);
                }
            }
        });
        gridData = new GridData(4, 0x1000000, true, true);
        gridData.horizontalSpan = 3;
        this.useSEIButton.setLayoutData((Object)gridData);
        Label paddingLabel = Java2WSWidgetFactory.createPaddingLabel((Composite)composite);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        paddingLabel.setLayoutData((Object)gridData);
        this.selectSEIButton = Java2WSWidgetFactory.createSelectSEIButton((Composite)composite);
        this.selectSEIButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Java2WSClassConfigWidget.this.enableSelectSEIControls(Java2WSClassConfigWidget.this.selectSEIButton.getSelection());
                Java2WSClassConfigWidget.this.enableExtractSEIControls(!Java2WSClassConfigWidget.this.selectSEIButton.getSelection());
                if (Java2WSClassConfigWidget.this.selectSEIButton.getSelection() && Java2WSClassConfigWidget.this.selectSEICombo.getText().trim().length() > 0) {
                    Java2WSClassConfigWidget.this.updateSEISelectionStatus();
                    statusListener.handleEvent(null);
                }
            }
        });
        this.selectSEIButton.setSelection(false);
        this.selectSEIButton.setEnabled(false);
        gridData = new GridData(4, 4, false, false);
        this.selectSEIButton.setLayoutData((Object)gridData);
        this.selectSEICombo = Java2WSWidgetFactory.createSelectSEICombo((Composite)composite, (Java2WSDataModel)this.model, (IType)this.startingPointType);
        this.selectSEICombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Java2WSClassConfigWidget.this.updateSEISelectionStatus();
                statusListener.handleEvent(null);
            }
        });
        this.selectSEICombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Java2WSClassConfigWidget.this.updateSEISelectionStatus();
                statusListener.handleEvent(null);
            }
        });
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 1;
        this.selectSEICombo.setLayoutData((Object)gridData);
        this.browseSEIButton = Java2WSWidgetFactory.createBrowseButton((Composite)composite);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 1;
        this.browseSEIButton.setLayoutData((Object)gridData);
        this.browseSEIButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog selectionDialog = Java2WSWidgetFactory.createElementTreeSelectionDialog((Shell)composite.getShell(), (String)CXFCreationUIMessages.JAVA2WS_SELECT_SEI_DIALOG_TITLE, (String)CXFCreationUIMessages.JAVA2WS_SELECT_SEI_DIALOG_DESCRIPTION, (IJavaProject)JDTUtils.getJavaProject((String)Java2WSClassConfigWidget.this.model.getProjectName()), (int)6);
                int returnCode = selectionDialog.open();
                if (returnCode == 0) {
                    ICompilationUnit selectedCompilationUnit = (ICompilationUnit)selectionDialog.getFirstResult();
                    String selectedInterface = selectedCompilationUnit.findPrimaryType().getFullyQualifiedName();
                    List<String> seis = Arrays.asList(Java2WSClassConfigWidget.this.selectSEICombo.getItems());
                    if (!seis.contains(selectedInterface)) {
                        Java2WSClassConfigWidget.this.selectSEICombo.add(selectedInterface);
                    }
                    Java2WSClassConfigWidget.this.selectSEICombo.setText(selectedInterface);
                }
            }
        });
        paddingLabel = Java2WSWidgetFactory.createPaddingLabel((Composite)composite);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        paddingLabel.setLayoutData((Object)gridData);
        this.extractSEIButton = Java2WSWidgetFactory.createExtractSEIButton((Composite)composite);
        this.extractSEIButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean extract = Java2WSClassConfigWidget.this.extractSEIButton.getSelection();
                Java2WSClassConfigWidget.this.model.setExtractInterface(extract);
                Java2WSClassConfigWidget.this.enableExtractSEIControls(extract);
                Java2WSClassConfigWidget.this.enableSelectSEIControls(!extract);
                Java2WSClassConfigWidget.this.updateSEISelectionStatus();
                statusListener.handleEvent(null);
            }
        });
        this.extractSEIButton.setSelection(this.model.isExtractInterface());
        this.extractSEIButton.setEnabled(false);
        gridData = new GridData(4, 4, false, false);
        this.extractSEIButton.setLayoutData((Object)gridData);
        this.seiInterfaceNameText = Java2WSWidgetFactory.createSEIInterfaceNameText((Composite)composite);
        this.seiInterfaceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (Java2WSClassConfigWidget.this.extractSEIButton.getSelection()) {
                    String interfaceName;
                    String seiName = interfaceName = Java2WSClassConfigWidget.this.seiInterfaceNameText.getText();
                    String packageName = Java2WSClassConfigWidget.this.startingPointType.getPackageFragment().getElementName();
                    if (packageName.length() > 0) {
                        seiName = String.valueOf(packageName) + "." + interfaceName;
                    }
                    Java2WSClassConfigWidget.this.model.setServiceEndpointInterfaceName(seiName);
                    String compilationUnitName = String.valueOf(interfaceName) + ".java";
                    Java2WSClassConfigWidget.this.JAVA_TYPE_NAME_STATUS = JDTUtils.validateJavaTypeName((String)Java2WSClassConfigWidget.this.model.getProjectName(), (String)interfaceName);
                    Java2WSClassConfigWidget.this.JAVA_TYPE_EXISTS_STATUS = Java2WSClassConfigWidget.this.checkTypeExists(Java2WSClassConfigWidget.this.startingPointType, compilationUnitName);
                    Java2WSClassConfigWidget.this.updateSEISelectionStatus();
                    statusListener.handleEvent(null);
                }
            }
        });
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 1;
        this.seiInterfaceNameText.setLayoutData((Object)gridData);
        Java2WSWidgetFactory.createPaddingLabel((Composite)composite);
        Java2WSWidgetFactory.createPaddingLabel((Composite)composite);
        Java2WSWidgetFactory.createMemebersToExtractLabel((Composite)composite);
        Java2WSWidgetFactory.createPaddingLabel((Composite)composite);
        Java2WSWidgetFactory.createPaddingLabel((Composite)composite);
        this.seiMembersToExtractTableViewer = Java2WSWidgetFactory.createSEIMembersToExtractTableViewer((Composite)composite);
        this.seiMembersToExtractTable = this.seiMembersToExtractTableViewer.getTable();
        this.seiMembersToExtractTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object[] checkedMethods = Java2WSClassConfigWidget.this.seiMembersToExtractTableViewer.getCheckedElements();
                HashMap<IMethod, Map> methodMap = new HashMap<IMethod, Map>();
                int i = 0;
                while (i < checkedMethods.length) {
                    methodMap.put((IMethod)checkedMethods[i], Java2WSClassConfigWidget.this.model.getAnnotationMap());
                    ++i;
                }
                Java2WSClassConfigWidget.this.model.setMethodMap(methodMap);
                Java2WSClassConfigWidget.this.NUMBER_OF_CHECKED_METHODS = checkedMethods.length;
                if (Java2WSClassConfigWidget.this.NUMBER_OF_CHECKED_METHODS < Java2WSClassConfigWidget.this.NUMBER_OF_PUBLIC_METHODS) {
                    Java2WSClassConfigWidget.this.selectAllButton.setEnabled(true);
                } else if (Java2WSClassConfigWidget.this.NUMBER_OF_CHECKED_METHODS == Java2WSClassConfigWidget.this.NUMBER_OF_PUBLIC_METHODS) {
                    Java2WSClassConfigWidget.this.selectAllButton.setEnabled(false);
                }
                if (Java2WSClassConfigWidget.this.NUMBER_OF_CHECKED_METHODS > 0) {
                    Java2WSClassConfigWidget.this.deselectAllButton.setEnabled(true);
                } else {
                    Java2WSClassConfigWidget.this.deselectAllButton.setEnabled(false);
                }
                Java2WSClassConfigWidget.this.updateSEISelectionStatus();
                statusListener.handleEvent(null);
            }
        });
        gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 3;
        gridData.heightHint = 100;
        this.seiMembersToExtractTable.setLayoutData((Object)gridData);
        this.selectAllButton = Java2WSWidgetFactory.createSelectAllButton((Composite)composite);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Java2WSClassConfigWidget.this.seiMembersToExtractTableViewer.setAllChecked(true);
                Java2WSClassConfigWidget.this.selectAllButton.setEnabled(false);
                Java2WSClassConfigWidget.this.deselectAllButton.setEnabled(true);
                TableItem[] checkedMethods = Java2WSClassConfigWidget.this.seiMembersToExtractTableViewer.getTable().getItems();
                int i = 0;
                while (i < checkedMethods.length) {
                    TableItem tableItem = checkedMethods[i];
                    SelectionEvent selectionEvent = event;
                    selectionEvent.detail = 32;
                    selectionEvent.item = tableItem;
                    Java2WSClassConfigWidget.this.seiMembersToExtractTableViewer.handleSelect(selectionEvent);
                    ++i;
                }
                Java2WSClassConfigWidget.this.updateSEISelectionStatus();
                statusListener.handleEvent(null);
            }
        });
        gridData = new GridData(4, 4, false, false);
        this.selectAllButton.setLayoutData((Object)gridData);
        Java2WSWidgetFactory.createPaddingLabel((Composite)composite);
        this.deselectAllButton = Java2WSWidgetFactory.createDeselectAllButton((Composite)composite);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Java2WSClassConfigWidget.this.seiMembersToExtractTableViewer.setAllChecked(false);
                Java2WSClassConfigWidget.this.selectAllButton.setEnabled(true);
                Java2WSClassConfigWidget.this.deselectAllButton.setEnabled(false);
                TableItem[] checkedMethods = Java2WSClassConfigWidget.this.seiMembersToExtractTableViewer.getTable().getItems();
                int i = 0;
                while (i < checkedMethods.length) {
                    TableItem tableItem = checkedMethods[i];
                    SelectionEvent selectionEvent = event;
                    selectionEvent.detail = 32;
                    selectionEvent.item = tableItem;
                    Java2WSClassConfigWidget.this.seiMembersToExtractTableViewer.handleSelect(selectionEvent);
                    ++i;
                }
                Java2WSClassConfigWidget.this.updateSEISelectionStatus();
                statusListener.handleEvent(null);
            }
        });
        gridData = new GridData(4, 4, false, false);
        this.deselectAllButton.setLayoutData((Object)gridData);
        this.publicMethods = JDTUtils.getPublicMethods((IType)this.startingPointType);
        this.NUMBER_OF_PUBLIC_METHODS = this.publicMethods.length;
        this.seiMembersToExtractTableViewer.setInput((Object)this.publicMethods);
        this.enableSelectSEIControls(false);
        this.enableExtractSEIControls(false);
        this.selectAllButton.setEnabled(false);
        this.deselectAllButton.setEnabled(false);
        if (this.model.isUseServiceEndpointInterface()) {
            if (this.selectSEICombo.indexOf(this.model.getServiceEndpointInterfaceName()) == -1) {
                this.selectSEICombo.add(this.model.getServiceEndpointInterfaceName());
            }
            this.selectSEICombo.setText(this.model.getServiceEndpointInterfaceName());
            this.model.setFullyQualifiedJavaInterfaceName(this.model.getServiceEndpointInterfaceName());
        }
        return this;
    }

    private void validateSEISelection() {
        if (!this.useSEIButton.getSelection()) {
            this.SEI_SELECTION_STATUS = Status.OK_STATUS;
            return;
        }
        IType seiType = JDTUtils.findType((String)this.model.getProjectName(), (String)this.selectSEICombo.getText());
        if (seiType != null) {
            try {
                IMethod[] seiMethods;
                IMethod[] iMethodArray = seiMethods = seiType.getMethods();
                int n = seiMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod seiMethod = iMethodArray[n2];
                    IMethod[] implMethods = this.startingPointType.findMethods(seiMethod);
                    if (implMethods == null) {
                        this.SEI_SELECTION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.creation.ui", CXFCreationUIMessages.bind((String)CXFCreationUIMessages.WEBSERVICE_ENPOINTINTERFACE_MUST_IMPLEMENT, (Object)this.getImplementsMessage(seiType, seiMethod)));
                        break;
                    }
                    this.SEI_SELECTION_STATUS = this.validateSEIAddition();
                    ++n2;
                }
                this.model.setServiceEndpointInterfaceName(this.selectSEICombo.getText());
                this.model.setFullyQualifiedJavaInterfaceName(this.selectSEICombo.getText());
            }
            catch (JavaModelException jme) {
                CXFCreationUIPlugin.log(jme.getStatus());
            }
        } else {
            this.SEI_SELECTION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.creation.ui", CXFCreationUIMessages.bind((String)CXFCreationUIMessages.WEBSERVICE_ENPOINTINTERFACE_NOT_FOUND, (Object)this.selectSEICombo.getText()));
        }
    }

    private String getImplementsMessage(IType seiType, IMethod seiMethod) {
        StringBuilder message = new StringBuilder(seiType.getElementName());
        message.append(".");
        message.append(seiMethod.getElementName());
        message.append("(");
        String[] parameterTypes = seiMethod.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            String parameterType = Signature.toString((String)parameterTypes[i]);
            message.append(parameterType);
            if (i < parameterTypes.length - 1) {
                message.append(", ");
            }
            ++i;
        }
        message.append(")");
        return message.toString();
    }

    private IStatus validateSEIAddition() {
        IStatus status = Status.OK_STATUS;
        try {
            Object name;
            IAnnotation webService = AnnotationUtils.getAnnotation(WebService.class, (IAnnotatable)this.startingPointType);
            if (webService != null && (name = AnnotationUtils.getAnnotationValue((IAnnotation)webService, (String)NAME)) != null) {
                status = new Status(4, "org.eclipse.jst.ws.cxf.creation.ui", CXFCreationUIMessages.JAVA2WS_SELECT_SEI_WEBSERVICE_NAME_ATTRIBUTE_PRESENT);
            }
        }
        catch (JavaModelException jme) {
            CXFCreationUIPlugin.log(jme.getStatus());
        }
        return status;
    }

    public void enableSelectSEIControls(boolean enable) {
        this.selectSEICombo.setEnabled(enable);
        this.browseSEIButton.setEnabled(enable);
    }

    public void enableExtractSEIControls(boolean enable) {
        this.seiInterfaceNameText.setEnabled(enable);
        this.seiMembersToExtractTable.setEnabled(enable);
        if (enable && this.NUMBER_OF_CHECKED_METHODS < this.NUMBER_OF_PUBLIC_METHODS) {
            this.selectAllButton.setEnabled(true);
        }
        if (enable && this.NUMBER_OF_CHECKED_METHODS > 0) {
            this.deselectAllButton.setEnabled(true);
        }
        if (!enable) {
            this.selectAllButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
        }
    }

    public IStatus getStatus() {
        return this.findMostSevere();
    }

    private void updateSEISelectionStatus() {
        if (this.useSEIButton.getSelection()) {
            if (!this.selectSEIButton.getSelection() && !this.extractSEIButton.getSelection()) {
                this.SEI_SELECTION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.creation.ui", CXFCreationUIMessages.JAVA2WS_SELECT_SEI_OPTION);
            }
            if (this.selectSEIButton.getSelection() && this.selectSEICombo.getText().length() == 0) {
                this.SEI_SELECTION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.creation.ui", CXFCreationUIMessages.JAVA2WS_SELECT_SEI_MESSAGE);
            } else if (this.selectSEIButton.getSelection() && this.selectSEICombo.getText().length() > 0) {
                this.validateSEISelection();
            }
            if (this.extractSEIButton.getSelection() && this.seiInterfaceNameText.getText().trim().length() == 0) {
                this.SEI_SELECTION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.creation.ui", CXFCreationUIMessages.JAVA2WS_ENTER_SEI_NAME);
            } else if (this.extractSEIButton.getSelection() && this.NUMBER_OF_PUBLIC_METHODS > 0 && this.NUMBER_OF_CHECKED_METHODS == 0) {
                this.SEI_SELECTION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.creation.ui", CXFCreationUIMessages.bind((String)CXFCreationUIMessages.JAVA2WS_SELECT_SEI_EXTRACTED_METHODS, (Object)this.startingPointType.getElementName()));
            } else if (this.extractSEIButton.getSelection() && this.seiInterfaceNameText.getText().trim().length() > 0 && this.NUMBER_OF_PUBLIC_METHODS > 0 && this.NUMBER_OF_CHECKED_METHODS > 0) {
                this.SEI_SELECTION_STATUS = Status.OK_STATUS;
            }
        } else {
            this.SEI_SELECTION_STATUS = Status.OK_STATUS;
            this.JAVA_TYPE_NAME_STATUS = Status.OK_STATUS;
            this.JAVA_TYPE_EXISTS_STATUS = Status.OK_STATUS;
        }
    }

    private IStatus findMostSevere() {
        if (this.JAVA_TYPE_NAME_STATUS.matches(4)) {
            return this.JAVA_TYPE_NAME_STATUS;
        }
        if (this.JAVA_TYPE_EXISTS_STATUS.matches(4)) {
            return this.JAVA_TYPE_EXISTS_STATUS;
        }
        if (this.SEI_SELECTION_STATUS.matches(4)) {
            return this.SEI_SELECTION_STATUS;
        }
        if (this.SEI_SELECTION_STATUS.getSeverity() >= this.JAVA_TYPE_NAME_STATUS.getSeverity()) {
            return this.SEI_SELECTION_STATUS;
        }
        if (this.JAVA_TYPE_EXISTS_STATUS.getSeverity() >= this.JAVA_TYPE_NAME_STATUS.getSeverity()) {
            return this.JAVA_TYPE_EXISTS_STATUS;
        }
        return this.JAVA_TYPE_NAME_STATUS;
    }

    public IStatus checkTypeExists(IType type, String compilationUnitName) {
        compilationUnitName = compilationUnitName.trim();
        IPackageFragment packageFragment = type.getPackageFragment();
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit(compilationUnitName);
        IResource resource = compilationUnit.getResource();
        if (resource.exists()) {
            return new Status(4, "org.eclipse.jst.ws.jaxws.core", JAXWSCoreMessages.bind((String)JAXWSCoreMessages.TYPE_WITH_NAME_ALREADY_EXISTS, (Object[])new Object[]{compilationUnitName, packageFragment.getElementName()}));
        }
        URI location = resource.getLocationURI();
        if (location != null) {
            try {
                IFileStore fileStore = EFS.getStore((URI)location);
                if (fileStore.fetchInfo().exists()) {
                    return new Status(4, "org.eclipse.jst.ws.jaxws.core", JAXWSCoreMessages.TYPE_NAME_DIFFERENT_CASE_EXISTS);
                }
            }
            catch (CoreException ce) {
                JAXWSCorePlugin.log((IStatus)ce.getStatus());
            }
        }
        return Status.OK_STATUS;
    }
}

