/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.text.SimpleJavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.jst.ws.internal.cxf.creation.ui.CXFCreationUIMessages;
import org.eclipse.jst.ws.internal.cxf.creation.ui.CXFCreationUIPlugin;
import org.eclipse.jst.ws.internal.cxf.creation.ui.viewers.AnnotationColumnLabelProvider;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class JAXWSAnnotateJavaWidget
extends SimpleWidgetDataContributor {
    IStatus status = Status.OK_STATUS;
    private IType type;
    private Java2WSDataModel model;
    private TreeViewer javaTreeViewer;
    private SourceViewer annotationPreviewViewer;
    private TreeViewerColumn webMethodViewerColumn;
    private TreeViewerColumn webParamViewerColumn;
    private TreeViewerColumn requestWrapperViewerColumn;
    private TreeViewerColumn responceWrapperViewerColumn;

    public void setJava2WSDataModel(Java2WSDataModel model) {
        this.model = model;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        SashForm sashForm = new SashForm(parent, 66048);
        GridLayout gridLayout = new GridLayout(1, true);
        sashForm.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gridData);
        Composite javaTreecomposite = new Composite((Composite)sashForm, 0);
        gridLayout = new GridLayout(1, true);
        javaTreecomposite.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, true);
        javaTreecomposite.setLayoutData((Object)gridData);
        Label outlineLabel = new Label(javaTreecomposite, 0);
        outlineLabel.setText(CXFCreationUIMessages.JAXWS_ANNOTATE_JJAVA_WIDGET_SELECT_METHOD_TO_ANNOTATE);
        Tree javaTree = new Tree(javaTreecomposite, 68352);
        this.javaTreeViewer = new TreeViewer(javaTree);
        javaTree.setHeaderVisible(true);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 10;
        gridData.widthHint = 200;
        javaTree.setLayoutData((Object)gridData);
        TreeViewerColumn classViewerColumn = new TreeViewerColumn(this.javaTreeViewer, 0);
        TreeColumn classColumn = classViewerColumn.getColumn();
        classColumn.setWidth(200);
        classColumn.setMoveable(false);
        final JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider();
        classViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return javaElementLabelProvider.getImage(element);
            }

            public String getText(Object element) {
                return javaElementLabelProvider.getText(element);
            }
        });
        this.javaTreeViewer.setContentProvider((IContentProvider)new StandardJavaElementContentProvider(true){

            public Object[] getChildren(Object element) {
                int n;
                if (element instanceof ICompilationUnit) {
                    try {
                        IType[] types;
                        ICompilationUnit compilationUnit = (ICompilationUnit)element;
                        IType[] iTypeArray = types = compilationUnit.getTypes();
                        n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType type = iTypeArray[n2];
                            if (type instanceof IType) {
                                return new Object[]{type};
                            }
                            ++n2;
                        }
                    }
                    catch (JavaModelException jme) {
                        CXFCreationUIPlugin.log(jme.getStatus());
                    }
                }
                if (element instanceof IType) {
                    try {
                        IType sourceType = (IType)element;
                        ArrayList<Object> publicMethods = new ArrayList<Object>();
                        Object[] methods = sourceType.getMethods();
                        if (sourceType.isInterface()) {
                            return methods;
                        }
                        if (sourceType.isClass()) {
                            Object[] objectArray = methods;
                            int n3 = methods.length;
                            n = 0;
                            while (n < n3) {
                                Object method = objectArray[n];
                                if (JDTUtils.isPublicMethod((IMethod)method)) {
                                    publicMethods.add(method);
                                }
                                ++n;
                            }
                        }
                        return publicMethods.toArray(new Object[publicMethods.size()]);
                    }
                    catch (JavaModelException jme) {
                        CXFCreationUIPlugin.log(jme.getStatus());
                    }
                }
                return NO_CHILDREN;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }
        });
        this.javaTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof ITreeSelection) {
                    TreeSelection treeSelection = (TreeSelection)event.getSelection();
                    Object firstElement = treeSelection.getFirstElement();
                    IDocument document = JAXWSAnnotateJavaWidget.this.annotationPreviewViewer.getDocument();
                    FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(document);
                    try {
                        if (firstElement instanceof IType) {
                            IType sourceType = (IType)firstElement;
                            String elementName = sourceType.getElementName();
                            StringBuilder regex = new StringBuilder("\\bpublic\\W+(?:\\w+\\W+){1,3}?");
                            regex.append(elementName);
                            regex.append("\\b");
                            IRegion region = findReplaceDocumentAdapter.find(0, regex.toString(), true, true, false, true);
                            JAXWSAnnotateJavaWidget.this.annotationPreviewViewer.setSelectedRange(region.getOffset(), region.getLength());
                            JAXWSAnnotateJavaWidget.this.annotationPreviewViewer.revealRange(region.getOffset(), region.getLength());
                        } else if (firstElement instanceof IMethod) {
                            IRegion elementNameRegion;
                            IMethod sourceMethod = (IMethod)firstElement;
                            IType sourceType = (IType)sourceMethod.getParent();
                            String elementName = sourceMethod.getElementName();
                            StringBuilder regex = new StringBuilder();
                            if (sourceType.isClass()) {
                                regex.append("\\bpublic");
                            }
                            regex.append("\\W+(?:\\w+\\W+){1,3}?");
                            regex.append(elementName);
                            regex.append("\\s*?\\(\\s*?.*?");
                            String[] parameterTypes = sourceMethod.getParameterTypes();
                            String[] paramterNames = sourceMethod.getParameterNames();
                            int i = 0;
                            while (i < parameterTypes.length) {
                                regex.append("\\s*?");
                                String typeName = Signature.toString((String)parameterTypes[i]);
                                regex.append(typeName);
                                regex.append("\\s*?");
                                regex.append(paramterNames[i]);
                                if (i < parameterTypes.length - 1) {
                                    regex.append("\\s*?,\\s*?.*?");
                                }
                                ++i;
                            }
                            regex.append("\\s*?\\)");
                            IRegion region = findReplaceDocumentAdapter.find(0, regex.toString(), true, true, false, true);
                            if (region != null && (elementNameRegion = findReplaceDocumentAdapter.find(region.getOffset(), elementName, true, true, true, false)) != null) {
                                JAXWSAnnotateJavaWidget.this.annotationPreviewViewer.setSelectedRange(elementNameRegion.getOffset(), elementNameRegion.getLength());
                                JAXWSAnnotateJavaWidget.this.annotationPreviewViewer.revealRange(elementNameRegion.getOffset(), elementNameRegion.getLength());
                            }
                        }
                    }
                    catch (BadLocationException ble) {
                        CXFCreationUIPlugin.log(ble);
                    }
                    catch (JavaModelException jme) {
                        CXFCreationUIPlugin.log(jme);
                    }
                }
            }
        });
        this.createWebMethodViewerColumn(this.javaTreeViewer);
        this.createWebParamViewerColumn(this.javaTreeViewer);
        this.createRequestWrapperViewerColumn(this.javaTreeViewer);
        this.createResponseWrapperViewerColumn(this.javaTreeViewer);
        this.javaTreeViewer.setAutoExpandLevel(-1);
        this.javaTreeViewer.expandAll();
        Composite previewComposite = new Composite((Composite)sashForm, 0);
        gridLayout = new GridLayout(1, true);
        previewComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, true);
        javaTreecomposite.setLayoutData((Object)gridData);
        Label previewLabel = new Label(previewComposite, 0);
        previewLabel.setText(CXFCreationUIMessages.JAXWS_ANNOTATE_JJAVA_WIDGET_PREVIEW);
        this.annotationPreviewViewer = this.createAnnotationPreviewer(previewComposite, 2824);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 10;
        gridData.widthHint = 200;
        this.annotationPreviewViewer.getControl().setLayoutData((Object)gridData);
        sashForm.setWeights(new int[]{50, 50});
        return this;
    }

    public void internalize() {
        this.type = null;
        this.updateLabelProviders();
        this.javaTreeViewer.setInput((Object)this.getType().getTypeRoot());
        this.javaTreeViewer.refresh();
        this.handleAnnotation(this.getType());
    }

    private IType getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.model.getFullyQualifiedJavaInterfaceName() != null) {
            this.type = JDTUtils.findType((IJavaProject)JDTUtils.getJavaProject((String)this.model.getProjectName()), (String)this.model.getFullyQualifiedJavaInterfaceName());
        } else if (this.model.getFullyQualifiedJavaClassName() != null) {
            this.type = JDTUtils.findType((IJavaProject)JDTUtils.getJavaProject((String)this.model.getProjectName()), (String)this.model.getFullyQualifiedJavaClassName());
        }
        if (this.type == null) {
            this.type = JDTUtils.findType((IJavaProject)JDTUtils.getJavaProject((String)this.model.getProjectName()), (String)this.model.getJavaStartingPoint());
        }
        this.model.setMethodMap(CXFModelUtils.getMethodMap((IType)this.type, (Java2WSDataModel)this.model));
        return this.type;
    }

    private TreeViewerColumn createWebMethodViewerColumn(TreeViewer treeViewer) {
        this.webMethodViewerColumn = new TreeViewerColumn(treeViewer, 0x1000000);
        TreeColumn webMethodColumn = this.webMethodViewerColumn.getColumn();
        webMethodColumn.setText("@WebMethod");
        webMethodColumn.setWidth(100);
        webMethodColumn.setAlignment(0x1000000);
        webMethodColumn.setMoveable(false);
        this.webMethodViewerColumn.setLabelProvider((CellLabelProvider)new AnnotationColumnLabelProvider(this.model, "WebMethod", this.getType()));
        this.webMethodViewerColumn.setEditingSupport((EditingSupport)new AnnotationEditingSupport(treeViewer, "WebMethod"));
        return this.webMethodViewerColumn;
    }

    private TreeViewerColumn createWebParamViewerColumn(TreeViewer treeViewer) {
        this.webParamViewerColumn = new TreeViewerColumn(treeViewer, 0x1000000);
        TreeColumn webParamColumn = this.webParamViewerColumn.getColumn();
        webParamColumn.setText("@WebParam");
        webParamColumn.setWidth(100);
        webParamColumn.setAlignment(0x1000000);
        webParamColumn.setMoveable(false);
        this.webParamViewerColumn.setLabelProvider((CellLabelProvider)new AnnotationColumnLabelProvider(this.model, "WebParam", this.getType()));
        this.webParamViewerColumn.setEditingSupport((EditingSupport)new AnnotationEditingSupport(treeViewer, "WebParam"));
        return this.webParamViewerColumn;
    }

    private TreeViewerColumn createRequestWrapperViewerColumn(TreeViewer treeViewer) {
        this.requestWrapperViewerColumn = new TreeViewerColumn(treeViewer, 0x1000000);
        TreeColumn createRequestWrapperColumn = this.requestWrapperViewerColumn.getColumn();
        createRequestWrapperColumn.setText("@RequestWrapper");
        createRequestWrapperColumn.setWidth(100);
        createRequestWrapperColumn.setMoveable(false);
        this.requestWrapperViewerColumn.setLabelProvider((CellLabelProvider)new AnnotationColumnLabelProvider(this.model, "RequestWrapper", this.getType()));
        this.requestWrapperViewerColumn.setEditingSupport((EditingSupport)new AnnotationEditingSupport(treeViewer, "RequestWrapper"));
        return this.requestWrapperViewerColumn;
    }

    private TreeViewerColumn createResponseWrapperViewerColumn(TreeViewer treeViewer) {
        this.responceWrapperViewerColumn = new TreeViewerColumn(treeViewer, 0x1000000);
        TreeColumn responceWrapperColumn = this.responceWrapperViewerColumn.getColumn();
        responceWrapperColumn.setText("@ResponseWrapper");
        responceWrapperColumn.setWidth(100);
        responceWrapperColumn.setMoveable(false);
        this.responceWrapperViewerColumn.setLabelProvider((CellLabelProvider)new AnnotationColumnLabelProvider(this.model, "ResponseWrapper", this.getType()));
        this.responceWrapperViewerColumn.setEditingSupport((EditingSupport)new AnnotationEditingSupport(treeViewer, "ResponseWrapper"));
        return this.responceWrapperViewerColumn;
    }

    private void updateLabelProviders() {
        this.webMethodViewerColumn.setLabelProvider((CellLabelProvider)new AnnotationColumnLabelProvider(this.model, "WebMethod", this.getType()));
        this.webParamViewerColumn.setLabelProvider((CellLabelProvider)new AnnotationColumnLabelProvider(this.model, "WebParam", this.getType()));
        this.requestWrapperViewerColumn.setLabelProvider((CellLabelProvider)new AnnotationColumnLabelProvider(this.model, "RequestWrapper", this.getType()));
        this.responceWrapperViewerColumn.setLabelProvider((CellLabelProvider)new AnnotationColumnLabelProvider(this.model, "ResponseWrapper", this.getType()));
    }

    private void handleAnnotation(IType type) {
        try {
            this.annotationPreviewViewer.setRedraw(false);
            ICompilationUnit compilationUnit = type.getCompilationUnit();
            NullProgressMonitor monitor = new NullProgressMonitor();
            TextFileChange textFileChange = new TextFileChange("Annotation Changes", (IFile)compilationUnit.getResource());
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textFileChange.setEdit((TextEdit)multiTextEdit);
            textFileChange.setKeepPreviewEdits(true);
            CXFModelUtils.getImportsChange((ICompilationUnit)compilationUnit, (Java2WSDataModel)this.model, (TextFileChange)textFileChange, (boolean)false);
            CXFModelUtils.getWebServiceAnnotationChange((IType)type, (Java2WSDataModel)this.model, (TextFileChange)textFileChange);
            IMethod[] typeMethods = JDTUtils.getPublicMethods((IType)type);
            int i = 0;
            while (i < typeMethods.length) {
                IMethod method = typeMethods[i];
                Map methodAnnotationMap = (Map)this.model.getMethodMap().get(method);
                if (((Boolean)methodAnnotationMap.get("WebMethod")).booleanValue()) {
                    CXFModelUtils.getWebMethodAnnotationChange((IType)type, (IMethod)method, (TextFileChange)textFileChange);
                }
                if (((Boolean)methodAnnotationMap.get("RequestWrapper")).booleanValue()) {
                    CXFModelUtils.getRequestWrapperAnnotationChange((IType)type, (IMethod)method, (TextFileChange)textFileChange);
                }
                if (((Boolean)methodAnnotationMap.get("ResponseWrapper")).booleanValue()) {
                    CXFModelUtils.getResponseWrapperAnnotationChange((IType)type, (IMethod)method, (TextFileChange)textFileChange);
                }
                if (((Boolean)methodAnnotationMap.get("WebParam")).booleanValue()) {
                    List parameters = AnnotationUtils.getSingleVariableDeclarations((IMethod)method);
                    for (SingleVariableDeclaration parameter : parameters) {
                        CXFModelUtils.getWebParamAnnotationChange((IType)type, (IMethod)method, (ILocalVariable)((ILocalVariable)parameter.resolveBinding().getJavaElement()), (TextFileChange)textFileChange);
                    }
                }
                ++i;
            }
            this.annotationPreviewViewer.getDocument().set(textFileChange.getPreviewContent((IProgressMonitor)monitor));
            this.annotationPreviewViewer.setRedraw(true);
        }
        catch (CoreException ce) {
            CXFCreationUIPlugin.log(ce.getStatus());
        }
        catch (MalformedTreeException mte) {
            CXFCreationUIPlugin.log(mte);
        }
    }

    private SourceViewer createAnnotationPreviewer(Composite parent, int styles) {
        JavaPlugin javaPlugin = JavaPlugin.getDefault();
        IPreferenceStore store = javaPlugin.getCombinedPreferenceStore();
        JavaTextTools javaTextTools = javaPlugin.getJavaTextTools();
        this.annotationPreviewViewer = new JavaSourceViewer(parent, null, null, true, styles, store);
        IColorManager colorManager = javaTextTools.getColorManager();
        SimpleJavaSourceViewerConfiguration configuration = new SimpleJavaSourceViewerConfiguration(colorManager, store, null, "___java_partitioning", true);
        this.annotationPreviewViewer.configure((SourceViewerConfiguration)configuration);
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        this.annotationPreviewViewer.getTextWidget().setFont(font);
        this.annotationPreviewViewer.setEditable(false);
        String source = this.getSourceFromType(this.getType());
        Document document = new Document(source);
        JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.annotationPreviewViewer.setDocument((IDocument)document);
        return this.annotationPreviewViewer;
    }

    public String getSourceFromType(IType type) {
        try {
            return type.getCompilationUnit().getBuffer().getContents();
        }
        catch (JavaModelException jme) {
            CXFCreationUIPlugin.log(jme.getStatus());
            return "";
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    private class AnnotationEditingSupport
    extends EditingSupport {
        private CheckboxCellEditor checkboxCellEditor;
        private String annotationKey;

        public AnnotationEditingSupport(TreeViewer viewer, String annotationKey) {
            super((ColumnViewer)viewer);
            this.annotationKey = annotationKey;
            this.checkboxCellEditor = new CheckboxCellEditor((Composite)viewer.getTree());
        }

        protected boolean canEdit(Object element) {
            if (element instanceof IMethod) {
                IMethod method = (IMethod)element;
                return !AnnotationUtils.isAnnotationPresent((IJavaElement)JAXWSAnnotateJavaWidget.this.type.findMethods(method)[0], (String)this.annotationKey);
            }
            return false;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.checkboxCellEditor;
        }

        protected Object getValue(Object element) {
            Boolean annotate = (Boolean)((Map)JAXWSAnnotateJavaWidget.this.model.getMethodMap().get(element)).get(this.annotationKey);
            return annotate;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof IMethod) {
                IMethod method = (IMethod)element;
                Boolean annotate = (Boolean)value;
                Map annotationMap = (Map)JAXWSAnnotateJavaWidget.this.model.getMethodMap().get(element);
                annotationMap.put(this.annotationKey, annotate);
                JAXWSAnnotateJavaWidget.this.handleAnnotation(method.getDeclaringType());
                this.getViewer().refresh(true);
            }
        }
    }
}

