/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.terminals.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.terminals.ITerminalService;
import org.eclipse.rse.subsystems.terminals.core.ITerminalServiceSubSystem;
import org.eclipse.rse.subsystems.terminals.core.ITerminalServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.terminals.core.elements.TerminalElement;
import org.eclipse.swt.widgets.Display;

public class TerminalServiceSubSystem
extends SubSystem
implements ITerminalServiceSubSystem,
ICommunicationsListener {
    private ITerminalService _hostService = null;
    private ArrayList children = new ArrayList();
    static /* synthetic */ Class class$0;

    public TerminalServiceSubSystem(IHost host, IConnectorService connectorService, ITerminalService hostService) {
        super(host, connectorService);
        this._hostService = hostService;
    }

    private void fireAsyncRefresh(final Object target) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(target, 82, target));
            }
        });
    }

    public ITerminalService getTerminalService() {
        return this._hostService;
    }

    public Class getServiceType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.terminals.ITerminalService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(TerminalElement element) {
        if (element != null) {
            ArrayList arrayList = this.children;
            synchronized (arrayList) {
                this.children.add(element);
            }
            this.fireAsyncRefresh(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(TerminalElement element) {
        if (element != null) {
            ArrayList arrayList = this.children;
            synchronized (arrayList) {
                this.children.remove((Object)element);
            }
            this.fireAsyncRefresh(this);
        }
    }

    public void removeChild(String terminalTitle) {
        this.removeChild(this.getChild(terminalTitle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalElement getChild(String terminalTitle) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                TerminalElement element = (TerminalElement)((Object)it.next());
                if (!element.getName().equals(terminalTitle)) continue;
                return element;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren() {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            return this.children.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren() {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            return !this.children.isEmpty();
        }
    }

    public void setTerminalService(ITerminalService service) {
        this._hostService = service;
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        switch (e.getState()) {
            case 4: {
                this.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
                break;
            }
            case 3: 
            case 5: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        TerminalServiceSubSystem.this.cancelAllTerminals();
                    }
                });
                break;
            }
        }
    }

    public boolean isPassiveCommunicationsListener() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllTerminals() {
        Object[] terminals;
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            terminals = this.getChildren();
            this.children.clear();
        }
        if (terminals.length > 0) {
            int i = terminals.length - 1;
            while (i >= 0) {
                TerminalElement element = (TerminalElement)((Object)terminals[i]);
                try {
                    this.removeTerminalElement(element);
                }
                catch (Exception e) {
                    RSECorePlugin.getDefault().getLogger().logError("Error removing terminal", (Throwable)e);
                }
                --i;
            }
            this.fireAsyncRefresh(this);
        }
    }

    private void removeTerminalElement(TerminalElement element) {
        element.getTerminalShell().exit();
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)element, 141, null));
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
        this.getConnectorService().addCommunicationsListener((ICommunicationsListener)this);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        this.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
        super.uninitializeSubSystem(monitor);
    }

    public boolean canSwitchTo(ISubSystemConfiguration configuration) {
        return configuration instanceof ITerminalServiceSubSystemConfiguration;
    }

    public ITerminalServiceSubSystemConfiguration getParentRemoteTerminalSubSystemConfiguration() {
        return (ITerminalServiceSubSystemConfiguration)super.getSubSystemConfiguration();
    }
}

