/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataContext;

public abstract class AbstractMetaDataEnabledFeature
implements IMetaDataEnabledFeature {
    private MetaDataContext mdContext;
    private IStructuredDocumentContext sdContext;
    private IProject _project;
    private IFile _file;

    public void setMetaDataContext(MetaDataContext context) {
        this.mdContext = context;
    }

    public MetaDataContext getMetaDataContext() {
        return this.mdContext;
    }

    public void setStructuredDocumentContext(IStructuredDocumentContext context) {
        this.sdContext = context;
    }

    public IStructuredDocumentContext getStructuredDocumentContext() {
        return this.sdContext;
    }

    private IProject getProject() {
        if (this._project == null) {
            this._project = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this.sdContext).getProject();
        }
        return this._project;
    }

    private IFile getFile() {
        IResource res;
        if (this._file == null && (res = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this.sdContext).getResource()) instanceof IFile) {
            this._file = (IFile)res;
        }
        return this._file;
    }

    protected String getTraitValueAsString(String traitName) {
        Trait t = this.getTraitForEntityUsingContext(traitName);
        if (t != null) {
            return TraitValueHelper.getValueAsString((Trait)t);
        }
        return null;
    }

    protected List getTraitValueAsListOfStrings(String traitName) {
        Trait t = this.getTraitForEntityUsingContext(traitName);
        if (t != null) {
            return TraitValueHelper.getValueAsListOfStrings((Trait)t);
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean getTraitValueAsBoolean(String traitName) {
        Trait t = this.getTraitForEntityUsingContext(traitName);
        if (t != null) {
            return TraitValueHelper.getValueAsBoolean((Trait)t);
        }
        return false;
    }

    private Trait getTraitForEntityUsingContext(String traitName) {
        Entity entity = this.getMetaDataContext().getEntity();
        IMetaDataDomainContext modelContext = this.getMetaDataDomainContext();
        IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(modelContext);
        return query.getQueryHelper().getTrait(entity, traitName);
    }

    private IMetaDataDomainContext getMetaDataDomainContext() {
        IFile file = this.getFile();
        if (file != null) {
            return MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file);
        }
        return MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this.getProject());
    }

    protected String getSmallIcon() {
        return this.getTraitValueAsString("small-icon");
    }

    protected ImageDescriptor getImage() {
        String smallIcon = this.getSmallIcon();
        if (smallIcon == null) {
            return null;
        }
        try {
            Trait t = this.getMetaDataContext().getTrait();
            IMetaDataSourceModelProvider provider = t.getSourceModelProvider();
            IImageDescriptorProvider ip = (IImageDescriptorProvider)provider.getAdapter(IImageDescriptorProvider.class);
            if (ip != null) {
                return ip.getImageDescriptor(smallIcon);
            }
        }
        catch (RuntimeException runtimeException) {}
        return null;
    }
}

