/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.symbols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.designtime.el.AbstractDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.el.DefaultDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.el.IDecorativeResolver;
import org.eclipse.jst.jsf.designtime.el.IInstancePerProjectResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigBasedDTPropertyResolver
extends DefaultDTPropertyResolver
implements IInstancePerProjectResolver {
    private IProject _project;

    @Override
    public ISymbol[] getAllProperties(ISymbol base) {
        ISymbol[] superSymbols;
        HashMap<String, ISymbol> allSymbols = new HashMap<String, ISymbol>();
        ISymbol[] iSymbolArray = superSymbols = super.getAllProperties(base);
        int n = superSymbols.length;
        int n2 = 0;
        while (n2 < n) {
            ISymbol superSymbol = iSymbolArray[n2];
            allSymbols.put(superSymbol.getName(), superSymbol);
            ++n2;
        }
        if (JSFCorePlugin.hasDecorativePropertyResolvers()) {
            List<AbstractDTPropertyResolver> resolvers = this.retrieveDecorativePropertyResolvers(this._project);
            for (AbstractDTPropertyResolver resolver : resolvers) {
                ISymbol[] otherSymbols;
                ISymbol[] iSymbolArray2 = otherSymbols = resolver.getAllProperties(base);
                int n3 = otherSymbols.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISymbol otherSymbol = iSymbolArray2[n4];
                    allSymbols.put(otherSymbol.getName(), otherSymbol);
                    ++n4;
                }
            }
        }
        return allSymbols.values().toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
    }

    @Override
    public ISymbol getProperty(ISymbol base, int offset) {
        if (JSFCorePlugin.hasDecorativePropertyResolvers()) {
            List<AbstractDTPropertyResolver> resolvers = this.retrieveDecorativePropertyResolvers(this._project);
            int i = resolvers.size() - 1;
            while (i >= 0) {
                ISymbol symbol = resolvers.get(i).getProperty(base, offset);
                if (symbol != null) {
                    return symbol;
                }
                --i;
            }
        }
        return super.getProperty(base, offset);
    }

    @Override
    public ISymbol getProperty(ISymbol base, Object propertyId) {
        if (JSFCorePlugin.hasDecorativePropertyResolvers()) {
            List<AbstractDTPropertyResolver> resolvers = this.retrieveDecorativePropertyResolvers(this._project);
            int i = resolvers.size() - 1;
            while (i >= 0) {
                ISymbol symbol = resolvers.get(i).getProperty(base, propertyId);
                if (symbol != null) {
                    return symbol;
                }
                --i;
            }
        }
        return super.getProperty(base, propertyId);
    }

    private List<AbstractDTPropertyResolver> retrieveDecorativePropertyResolvers(IProject project) {
        IJSFAppConfigManager manager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance(project);
        List<String> propertyResolvers = manager.getPropertyResolvers();
        List<String> elResolvers = manager.getELResolvers();
        propertyResolvers.addAll(elResolvers);
        ArrayList<AbstractDTPropertyResolver> resolvers = new ArrayList<AbstractDTPropertyResolver>();
        for (String propertyResolver : propertyResolvers) {
            List<String> ids = JSFCorePlugin.getPropertyResolversForName(propertyResolver);
            for (String id : ids) {
                AbstractDTPropertyResolver resolver = JSFCorePlugin.getPropertyResolver(id).getInstance(this._project);
                if (resolver instanceof IDecorativeResolver) {
                    resolvers.add(resolver);
                    continue;
                }
                JSFCorePlugin.log(new Exception(), String.format("resolver %s must implement the IDecorativeResolver interface to be used", id));
            }
        }
        return resolvers;
    }

    @Override
    public void setProject(IProject project) {
        this._project = project;
    }
}

