/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.details;

import java.util.HashSet;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.ui.internal.widgets.ValidatingDialog;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkConversionValueStateObject;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkUiDetailsMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkConversionValueDialog
extends ValidatingDialog<EclipseLinkConversionValueStateObject> {
    private final EclipseLinkConversionValue conversionValue;
    private EclipseLinkObjectTypeConverter objectTypeConverter;

    public EclipseLinkConversionValueDialog(Shell parent, EclipseLinkObjectTypeConverter objectTypeConverter) {
        this(parent, objectTypeConverter, null);
    }

    public EclipseLinkConversionValueDialog(Shell parent, EclipseLinkObjectTypeConverter objectTypeConverter, EclipseLinkConversionValue conversionValue) {
        super(parent);
        this.objectTypeConverter = objectTypeConverter;
        this.conversionValue = conversionValue;
    }

    protected EclipseLinkConversionValueStateObject buildStateObject() {
        String dataValue = null;
        String objectValue = null;
        HashSet dataValues = CollectionTools.set((Iterable)this.objectTypeConverter.getDataValues(), (int)this.objectTypeConverter.getDataValuesSize());
        if (this.isEditDialog()) {
            dataValue = this.conversionValue.getDataValue();
            objectValue = this.conversionValue.getObjectValue();
            dataValues.remove(dataValue);
        }
        return new EclipseLinkConversionValueStateObject(dataValue, objectValue, dataValues);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    protected String getTitle() {
        return this.isAddDialog() ? EclipseLinkUiDetailsMessages.EclipseLinkConversionValueDialog_addConversionValue : EclipseLinkUiDetailsMessages.EclipseLinkConversionValueDialog_editConversionValue;
    }

    protected String getDescriptionTitle() {
        return this.isAddDialog() ? EclipseLinkUiDetailsMessages.EclipseLinkConversionValueDialog_addConversionValueDescriptionTitle : EclipseLinkUiDetailsMessages.EclipseLinkConversionValueDialog_editConversionValueDescriptionTitle;
    }

    protected String getDescription() {
        return this.isAddDialog() ? EclipseLinkUiDetailsMessages.EclipseLinkConversionValueDialog_addConversionValueDescription : EclipseLinkUiDetailsMessages.EclipseLinkConversionValueDialog_editConversionValueDescription;
    }

    protected DialogPane<EclipseLinkConversionValueStateObject> buildLayout(Composite container) {
        return new ConversionValueDialogPane(container);
    }

    public void create() {
        super.create();
        ConversionValueDialogPane pane = (ConversionValueDialogPane)this.getPane();
        pane.selectAll();
        this.getButton(0).setEnabled(false);
    }

    protected boolean isAddDialog() {
        return this.conversionValue == null;
    }

    protected boolean isEditDialog() {
        return !this.isAddDialog();
    }

    public String getDataValue() {
        return ((EclipseLinkConversionValueStateObject)this.getSubject()).getDataValue();
    }

    public String getObjectValue() {
        return ((EclipseLinkConversionValueStateObject)this.getSubject()).getObjectValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConversionValueDialogPane
    extends DialogPane<EclipseLinkConversionValueStateObject> {
        private Text dataValueText;
        private Text objectValueText;

        ConversionValueDialogPane(Composite parent) {
            super(EclipseLinkConversionValueDialog.this.getSubjectHolder(), parent);
        }

        protected void initializeLayout(Composite container) {
            this.dataValueText = this.addLabeledText(container, EclipseLinkUiDetailsMessages.EclipseLinkConversionValueDialog_dataValue, this.buildDataValueHolder());
            this.objectValueText = this.addLabeledText(container, EclipseLinkUiDetailsMessages.EclipseLinkConversionValueDialog_objectValue, this.buildObjectValueHolder());
        }

        private WritablePropertyValueModel<String> buildDataValueHolder() {
            return new PropertyAspectAdapter<EclipseLinkConversionValueStateObject, String>(this.getSubjectHolder(), new String[]{"dataValue"}){

                protected String buildValue_() {
                    return ((EclipseLinkConversionValueStateObject)((Object)this.subject)).getDataValue();
                }

                protected void setValue_(String value) {
                    ((EclipseLinkConversionValueStateObject)((Object)this.subject)).setDataValue(value);
                }
            };
        }

        private WritablePropertyValueModel<String> buildObjectValueHolder() {
            return new PropertyAspectAdapter<EclipseLinkConversionValueStateObject, String>(this.getSubjectHolder(), new String[]{"objectValue"}){

                protected String buildValue_() {
                    return ((EclipseLinkConversionValueStateObject)((Object)this.subject)).getObjectValue();
                }

                protected void setValue_(String value) {
                    ((EclipseLinkConversionValueStateObject)((Object)this.subject)).setObjectValue(value);
                }
            };
        }

        void selectAll() {
            this.dataValueText.selectAll();
            this.objectValueText.selectAll();
        }
    }
}

