/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionGeometry;

public class PrecisionDimension
extends Dimension {
    private static final long serialVersionUID = 1L;
    public double preciseHeight;
    public double preciseWidth;

    public PrecisionDimension() {
    }

    public PrecisionDimension(Dimension d) {
        this(d.preciseWidth(), d.preciseHeight());
    }

    public PrecisionDimension(double w, double h) {
        this.setPreciseSize(w, h);
    }

    public boolean contains(Dimension d) {
        return this.preciseWidth() >= d.preciseWidth() && this.preciseHeight() >= d.preciseHeight();
    }

    public boolean containsProper(Dimension d) {
        return this.preciseWidth() > d.preciseWidth() && this.preciseHeight() > d.preciseHeight();
    }

    public boolean equals(Object o) {
        if (o instanceof PrecisionDimension) {
            PrecisionDimension d = (PrecisionDimension)o;
            return d.preciseWidth() == this.preciseWidth() && d.preciseHeight() == this.preciseHeight();
        }
        return super.equals(o);
    }

    public Dimension expand(Dimension d) {
        return this.expandPrecise(d.preciseWidth(), d.preciseHeight());
    }

    public Dimension expand(int w, int h) {
        return this.expandPrecise(w, h);
    }

    private PrecisionDimension expandPrecise(double w, double h) {
        this.setPreciseWidth(this.preciseWidth() + w);
        this.setPreciseHeight(this.preciseHeight() + h);
        return this;
    }

    public Dimension getCopy() {
        return this.getPreciseCopy();
    }

    public PrecisionDimension getPreciseCopy() {
        PrecisionDimension result = new PrecisionDimension();
        result.setPreciseWidth(this.preciseWidth());
        result.setPreciseHeight(this.preciseHeight());
        return result;
    }

    public Dimension intersect(Dimension d) {
        this.setPreciseWidth(Math.min(d.preciseWidth(), this.preciseWidth()));
        this.setPreciseHeight(Math.min(d.preciseHeight(), this.preciseHeight()));
        return this;
    }

    public void performScale(double factor) {
        this.setPreciseWidth(this.preciseWidth() * factor);
        this.setPreciseHeight(this.preciseHeight() * factor);
    }

    public double preciseHeight() {
        this.updatePreciseHeightDouble();
        return this.preciseHeight;
    }

    public double preciseWidth() {
        this.updatePreciseWidthDouble();
        return this.preciseWidth;
    }

    public Dimension scale(double widthFactor, double heightFactor) {
        this.setPreciseWidth(this.preciseWidth() * widthFactor);
        this.setPreciseHeight(this.preciseHeight() * heightFactor);
        return this;
    }

    public Dimension setHeight(int h) {
        return this.setPreciseHeight(h);
    }

    public PrecisionDimension setPreciseHeight(double h) {
        this.preciseHeight = h;
        this.updateHeightInt();
        return this;
    }

    public PrecisionDimension setPreciseSize(double w, double h) {
        this.setPreciseWidth(w);
        this.setPreciseHeight(h);
        return this;
    }

    public PrecisionDimension setPreciseSize(PrecisionDimension d) {
        return this.setPreciseSize(d.preciseWidth(), d.preciseHeight());
    }

    public PrecisionDimension setPreciseWidth(double w) {
        this.preciseWidth = w;
        this.updateWidthInt();
        return this;
    }

    public void setSize(Dimension d) {
        this.setPreciseSize(d.preciseWidth(), d.preciseHeight());
    }

    public Dimension setSize(int w, int h) {
        return this.setPreciseSize(w, h);
    }

    public Dimension setWidth(int width) {
        return this.setPreciseWidth(width);
    }

    public Dimension shrink(Dimension d) {
        return this.shrinkPrecise(d.preciseWidth(), d.preciseHeight());
    }

    public Dimension shrink(int w, int h) {
        return this.shrinkPrecise(w, h);
    }

    private PrecisionDimension shrinkPrecise(double w, double h) {
        this.setPreciseWidth(this.preciseWidth() - w);
        this.setPreciseHeight(this.preciseHeight() - h);
        return this;
    }

    public Dimension transpose() {
        double temp = this.preciseWidth();
        this.setPreciseWidth(this.preciseHeight());
        this.setPreciseHeight(temp);
        return this;
    }

    public Dimension union(Dimension d) {
        this.setPreciseWidth(Math.max(this.preciseWidth(), d.preciseWidth()));
        this.setPreciseHeight(Math.max(this.preciseHeight(), d.preciseHeight()));
        return this;
    }

    private final void updateHeightInt() {
        this.height = PrecisionGeometry.doubleToInteger(this.preciseHeight);
    }

    public final void updateInts() {
        this.updateWidthInt();
        this.updateHeightInt();
    }

    private final void updateWidthInt() {
        this.width = PrecisionGeometry.doubleToInteger(this.preciseWidth);
    }

    private final void updatePreciseWidthDouble() {
        if (this.width != PrecisionGeometry.doubleToInteger(this.preciseWidth)) {
            this.preciseWidth = this.width;
        }
    }

    private final void updatePreciseHeightDouble() {
        if (this.height != PrecisionGeometry.doubleToInteger(this.preciseHeight)) {
            this.preciseHeight = this.height;
        }
    }
}

