/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.util;

import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.ws.internal.explorer.platform.util.URLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.util.XMLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDSimpleAtomicFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDSimpleListFragment;
import org.w3c.dom.Element;

public class HTTPUtil {
    private HTTPUtil() {
    }

    public static String genURLEncodedParameters(IXSDFragment fragment) {
        if (fragment instanceof IXSDSimpleListFragment) {
            return HTTPUtil.genURLEncodedParamsFromListFragment((IXSDSimpleListFragment)fragment);
        }
        if (fragment instanceof IXSDSimpleAtomicFragment) {
            return HTTPUtil.genURLEncodedParamsFromAtomicFragment((IXSDSimpleAtomicFragment)fragment);
        }
        return HTTPUtil.genURLEncodedXMLParameters(fragment);
    }

    private static String genURLEncodedParamsFromAtomicFragment(IXSDSimpleAtomicFragment fragment) {
        StringBuffer urlEncodedParam = new StringBuffer();
        String[] params = fragment.getParameterValues(fragment.getID());
        int i = 0;
        while (i < params.length) {
            urlEncodedParam.append(URLUtils.encode(fragment.getName()));
            urlEncodedParam.append("=");
            urlEncodedParam.append(URLUtils.encode(params[i]));
            if (i < params.length - 1) {
                urlEncodedParam.append("&");
            }
            ++i;
        }
        return urlEncodedParam.toString();
    }

    private static String genURLEncodedParamsFromListFragment(IXSDSimpleListFragment fragment) {
        StringBuffer urlEncodedParam = new StringBuffer();
        IXSDFragment[] childFrags = fragment.getAllFragments();
        int i = 0;
        while (i < childFrags.length) {
            urlEncodedParam.append(URLUtils.encode(fragment.getName()));
            urlEncodedParam.append("=");
            String[] params = childFrags[i].getParameterValues(childFrags[i].getID());
            StringBuffer paramBuffer = new StringBuffer();
            int j = 0;
            while (j < params.length) {
                paramBuffer.append(params[j]);
                if (j < params.length - 1) {
                    paramBuffer.append(" ");
                }
                ++j;
            }
            urlEncodedParam.append(URLUtils.encode(paramBuffer.toString()));
            if (i < childFrags.length - 1) {
                urlEncodedParam.append("&");
            }
            ++i;
        }
        return urlEncodedParam.toString();
    }

    private static String genURLEncodedXMLParameters(IXSDFragment fragment) {
        StringBuffer urlEncodedParam = new StringBuffer();
        Hashtable<String, String> soapEnvelopeNamespaceTable = new Hashtable<String, String>();
        soapEnvelopeNamespaceTable.put("http://schemas.xmlsoap.org/soap/envelope/", "soapenv");
        soapEnvelopeNamespaceTable.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        soapEnvelopeNamespaceTable.put("http://www.w3.org/2001/XMLSchema", "xsd");
        Element[] instanceDocuments = new Element[]{};
        try {
            instanceDocuments = fragment.genInstanceDocumentsFromParameterValues(true, soapEnvelopeNamespaceTable, XMLUtils.createNewDocument(null));
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        int i = 0;
        while (i < instanceDocuments.length) {
            urlEncodedParam.append(URLUtils.encode(fragment.getName()));
            urlEncodedParam.append("=");
            urlEncodedParam.append(URLUtils.encode(XMLUtils.serialize(instanceDocuments[i], true)));
            if (i < instanceDocuments.length - 1) {
                urlEncodedParam.append("&");
            }
            ++i;
        }
        return urlEncodedParam.toString();
    }
}

