/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.navigator.JaxbNavigatorContentAndLabelProvider;
import org.eclipse.jpt.jaxb.ui.internal.navigator.JaxbNavigatorLabelProvider;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUi;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class JaxbNavigatorContentProvider
implements ICommonContentProvider {
    private JaxbNavigatorContentAndLabelProvider delegate;
    private final CollectionChangeListener jaxbProjectListener = this.buildJaxbProjectListener();
    private StructuredViewer viewer;

    public JaxbNavigatorContentProvider() {
        JptJaxbCorePlugin.getProjectManager().addCollectionChangeListener("jaxbProjects", this.jaxbProjectListener);
    }

    protected CollectionChangeListener buildJaxbProjectListener() {
        return new JaxbProjectListener();
    }

    public JaxbNavigatorContentAndLabelProvider getDelegate() {
        return this.delegate;
    }

    public void dispose() {
        JptJaxbCorePlugin.getProjectManager().removeCollectionChangeListener("jaxbProjects", this.jaxbProjectListener);
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.delegate != null) {
            this.delegate.inputChanged(viewer, oldInput, newInput);
        }
        this.viewer = (StructuredViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (this.delegate != null) {
            return this.delegate.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        JaxbProject jaxbProject;
        IProject project;
        if (element instanceof IAdaptable && (project = (IProject)((IAdaptable)element).getAdapter(IProject.class)) != null && (jaxbProject = JptJaxbCorePlugin.getJaxbProject((IProject)project)) != null) {
            JaxbPlatformDescription desc = jaxbProject.getPlatform().getDescription();
            JaxbPlatformUi platformUi = JptJaxbUiPlugin.getJaxbPlatformUiManager().getJaxbPlatformUi(desc);
            return platformUi != null;
        }
        if (this.delegate != null) {
            return this.delegate.hasChildren(element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        JaxbProject jaxbProject;
        IProject project;
        if (parentElement instanceof IAdaptable && (project = (IProject)((IAdaptable)parentElement).getAdapter(IProject.class)) != null && (jaxbProject = JptJaxbCorePlugin.getJaxbProject((IProject)project)) != null) {
            JaxbPlatformDescription desc = jaxbProject.getPlatform().getDescription();
            JaxbPlatformUi platformUi = JptJaxbUiPlugin.getJaxbPlatformUiManager().getJaxbPlatformUi(desc);
            if (platformUi != null) {
                return new Object[]{jaxbProject.getContextRoot()};
            }
        }
        if (this.delegate != null) {
            return this.delegate.getChildren(parentElement);
        }
        return new Object[0];
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public void init(ICommonContentExtensionSite config) {
        if (this.delegate == null) {
            JaxbNavigatorLabelProvider labelProvider = (JaxbNavigatorLabelProvider)config.getExtension().getLabelProvider();
            this.delegate = labelProvider != null && labelProvider.getDelegate() != null ? labelProvider.getDelegate() : new JaxbNavigatorContentAndLabelProvider();
        }
    }

    private class JaxbProjectListener
    implements CollectionChangeListener {
        private JaxbProjectListener() {
        }

        public void collectionChanged(CollectionChangeEvent event) {
            this.refreshViewer(null);
        }

        public void collectionCleared(CollectionClearEvent event) {
            this.refreshViewer(null);
        }

        public void itemsAdded(CollectionAddEvent event) {
            for (Object item : event.getItems()) {
                this.refreshViewer(((JaxbProject)item).getProject());
            }
        }

        public void itemsRemoved(CollectionRemoveEvent event) {
            for (Object item : event.getItems()) {
                this.refreshViewer(((JaxbProject)item).getProject());
            }
        }

        private void refreshViewer(final IProject project) {
            if (JaxbNavigatorContentProvider.this.viewer != null && JaxbNavigatorContentProvider.this.viewer.getControl() != null && !JaxbNavigatorContentProvider.this.viewer.getControl().isDisposed()) {
                Job refreshJob = new Job("Refresh viewer"){

                    protected IStatus run(IProgressMonitor monitor) {
                        JaxbNavigatorContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (project != null) {
                                    JaxbNavigatorContentProvider.this.viewer.refresh((Object)project);
                                } else {
                                    JaxbNavigatorContentProvider.this.viewer.refresh();
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                if (project != null) {
                    refreshJob.setRule((ISchedulingRule)project);
                }
                refreshJob.schedule();
            }
        }
    }
}

