/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkConvertAnnotation
extends SourceAnnotation<Attribute>
implements EclipseLinkConvertAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Convert");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = SourceEclipseLinkConvertAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;

    public SourceEclipseLinkConvertAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super((JavaResourceNode)parent, (AnnotatedElement)attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)attribute, VALUE_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Convert";
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncValue(this.buildValue(astRoot));
    }

    public boolean isUnset() {
        return super.isUnset() && this.value == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    @Override
    public boolean valueTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(VALUE_ADAPTER, pos, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", StringExpressionConverter.instance());
    }
}

