/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.Association;
import org.eclipse.jpt.common.utility.internal.SimpleAssociation;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaConverter;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.AbstractJavaConverter;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkConvert
extends AbstractJavaConverter
implements EclipseLinkConvert {
    private final EclipseLinkConvertAnnotation convertAnnotation;
    private String specifiedConverterName;
    private String defaultConverterName;
    private JavaEclipseLinkConverter<?> converter;
    protected static final JavaEclipseLinkConverter.Adapter[] CONVERTER_ADAPTER_ARRAY = new JavaEclipseLinkConverter.Adapter[]{JavaEclipseLinkCustomConverter.Adapter.instance(), JavaEclipseLinkTypeConverter.Adapter.instance(), JavaEclipseLinkObjectTypeConverter.Adapter.instance(), JavaEclipseLinkStructConverter.Adapter.instance()};
    protected static final Iterable<JavaEclipseLinkConverter.Adapter> CONVERTER_ADAPTERS = new ArrayIterable((Object[])CONVERTER_ADAPTER_ARRAY);

    public JavaEclipseLinkConvert(JavaAttributeMapping parent, EclipseLinkConvertAnnotation convertAnnotation) {
        super(parent);
        this.convertAnnotation = convertAnnotation;
        this.specifiedConverterName = convertAnnotation.getValue();
        this.converter = this.buildConverter();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedConverterName_(this.convertAnnotation.getValue());
        this.syncConverter();
    }

    public void update() {
        super.update();
        this.setDefaultConverterName(this.buildDefaultConverterName());
        if (this.converter != null) {
            this.converter.update();
        }
    }

    @Override
    public String getConverterName() {
        return this.specifiedConverterName != null ? this.specifiedConverterName : this.defaultConverterName;
    }

    @Override
    public String getSpecifiedConverterName() {
        return this.specifiedConverterName;
    }

    @Override
    public void setSpecifiedConverterName(String name) {
        this.convertAnnotation.setValue(name);
        this.setSpecifiedConverterName_(name);
    }

    protected void setSpecifiedConverterName_(String name) {
        String old = this.specifiedConverterName;
        this.specifiedConverterName = name;
        this.firePropertyChanged("specifiedConverterName", old, name);
    }

    @Override
    public String getDefaultConverterName() {
        return this.defaultConverterName;
    }

    protected void setDefaultConverterName(String name) {
        String old = this.defaultConverterName;
        this.defaultConverterName = name;
        this.firePropertyChanged("defaultConverterName", old, name);
    }

    protected String buildDefaultConverterName() {
        return "none";
    }

    @Override
    public JavaEclipseLinkConverter<?> getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(Class<? extends EclipseLinkConverter> converterType) {
        if (converterType == null) {
            if (this.converter != null) {
                this.setConverter_(null);
                this.retainConverterAnnotation(null);
            }
        } else if (this.converter == null || this.converter.getType() != converterType) {
            JavaEclipseLinkConverter.Adapter adapter = this.getConverterAdapter(converterType);
            this.retainConverterAnnotation(adapter);
            this.setConverter_(this.buildConverter(adapter));
        }
    }

    protected void setConverter_(JavaEclipseLinkConverter<?> converter) {
        JavaEclipseLinkConverter<?> old = this.converter;
        this.converter = converter;
        this.firePropertyChanged("converter", old, converter);
    }

    protected JavaEclipseLinkConverter<?> buildConverter() {
        if (this.getAttributeMapping().getPersistentAttribute().isVirtual()) {
            return null;
        }
        JavaResourcePersistentAttribute resourceAttribute = this.getResourcePersistentAttribute();
        for (JavaEclipseLinkConverter.Adapter adapter : this.getConverterAdapters()) {
            JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> javaConverter = adapter.buildConverter((JavaResourcePersistentMember)resourceAttribute, (JavaJpaContextNode)this);
            if (javaConverter == null) continue;
            return javaConverter;
        }
        return null;
    }

    protected JavaEclipseLinkConverter<?> buildConverter(JavaEclipseLinkConverter.Adapter adapter) {
        if (this.getAttributeMapping().getPersistentAttribute().isVirtual()) {
            return null;
        }
        return adapter.buildNewConverter((JavaResourcePersistentMember)this.getResourcePersistentAttribute(), (JavaJpaContextNode)this);
    }

    protected JavaEclipseLinkConverter<?> buildConverter(JavaEclipseLinkConverter.Adapter adapter, EclipseLinkNamedConverterAnnotation annotation) {
        if (this.getAttributeMapping().getPersistentAttribute().isVirtual()) {
            return null;
        }
        return adapter.buildConverter(annotation, (JavaJpaContextNode)this);
    }

    protected void retainConverterAnnotation(JavaEclipseLinkConverter.Adapter converterAdapter) {
        JavaResourcePersistentAttribute resourceAttribute = this.getResourcePersistentAttribute();
        for (JavaEclipseLinkConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter == converterAdapter) continue;
            adapter.removeConverterAnnotation((JavaResourcePersistentMember)resourceAttribute);
        }
    }

    protected void syncConverter() {
        Association<JavaEclipseLinkConverter.Adapter, EclipseLinkNamedConverterAnnotation> assoc = this.getEclipseLinkConverterAnnotation();
        if (assoc == null) {
            if (this.converter != null) {
                this.setConverter_(null);
            }
        } else {
            JavaEclipseLinkConverter.Adapter adapter = (JavaEclipseLinkConverter.Adapter)assoc.getKey();
            EclipseLinkNamedConverterAnnotation annotation = (EclipseLinkNamedConverterAnnotation)assoc.getValue();
            if (this.converter != null && this.converter.getType() == adapter.getConverterType() && this.converter.getConverterAnnotation() == annotation) {
                this.converter.synchronizeWithResourceModel();
            } else {
                this.setConverter_(this.buildConverter(adapter, annotation));
            }
        }
    }

    protected Association<JavaEclipseLinkConverter.Adapter, EclipseLinkNamedConverterAnnotation> getEclipseLinkConverterAnnotation() {
        JavaResourcePersistentAttribute resourceAttribute = this.getResourcePersistentAttribute();
        for (JavaEclipseLinkConverter.Adapter adapter : this.getConverterAdapters()) {
            EclipseLinkNamedConverterAnnotation annotation = adapter.getConverterAnnotation((JavaResourcePersistentMember)resourceAttribute);
            if (annotation == null) continue;
            return new SimpleAssociation((Object)adapter, (Object)annotation);
        }
        return null;
    }

    protected JavaEclipseLinkConverter.Adapter getConverterAdapter(Class<? extends EclipseLinkConverter> converterType) {
        for (JavaEclipseLinkConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter.getConverterType() != converterType) continue;
            return adapter;
        }
        throw new IllegalArgumentException("unknown converter type: " + converterType.getName());
    }

    protected Iterable<JavaEclipseLinkConverter.Adapter> getConverterAdapters() {
        return CONVERTER_ADAPTERS;
    }

    public Class<? extends Converter> getType() {
        return EclipseLinkConvert.class;
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Convert";
    }

    public void dispose() {
        super.dispose();
        this.setConverter(null);
    }

    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.convertValueTouches(pos, astRoot) && (result = this.javaCandidateConverterNames(filter)) != null) {
            return result;
        }
        return null;
    }

    protected boolean convertValueTouches(int pos, CompilationUnit astRoot) {
        return this.convertAnnotation.valueTouches(pos, astRoot);
    }

    protected Iterator<String> javaCandidateConverterNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateConverterNames(filter));
    }

    protected Iterator<String> candidateConverterNames(Filter<String> filter) {
        return new FilteringIterator(this.converterNames(), filter);
    }

    protected Iterator<String> converterNames() {
        return this.getEclipseLinkPersistenceUnit().getUniqueConverterNames().iterator();
    }

    protected EclipseLinkPersistenceUnit getEclipseLinkPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)this.getPersistenceUnit();
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.converter != null) {
            this.converter.validate(messages, reporter, astRoot);
        }
        this.validateConvertValue(messages, astRoot);
    }

    private void validateConvertValue(List<IMessage> messages, CompilationUnit astRoot) {
        String converterName = this.getConverterName();
        if (converterName == null) {
            return;
        }
        ListIterator<EclipseLinkConverter> converters = this.getEclipseLinkPersistenceUnit().allConverters();
        while (converters.hasNext()) {
            if (!converterName.equals(((EclipseLinkConverter)converters.next()).getName())) continue;
            return;
        }
        if (ArrayTools.contains((Object[])RESERVED_CONVERTER_NAMES, (Object)converterName)) {
            return;
        }
        messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "ID_MAPPING_UNRESOLVED_CONVERTER_NAME", new String[]{converterName, this.getParent().getName()}, this.getParent(), this.getValidationTextRange(astRoot)));
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        return this.convertAnnotation.getTextRange(astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends JavaConverter.AbstractAdapter {
        private static final Adapter INSTANCE = new Adapter();

        public static Adapter instance() {
            return INSTANCE;
        }

        private Adapter() {
        }

        public Class<? extends Converter> getConverterType() {
            return EclipseLinkConvert.class;
        }

        protected String getAnnotationName() {
            return "org.eclipse.persistence.annotations.Convert";
        }

        public JavaConverter buildConverter(Annotation converterAnnotation, JavaAttributeMapping parent, JpaFactory factory) {
            return new JavaEclipseLinkConvert(parent, (EclipseLinkConvertAnnotation)converterAnnotation);
        }
    }
}

