/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.common.internal.emf.plugin.EcoreUtilitiesPlugin;
import org.eclipse.wst.common.internal.emf.utilities.Assert;
import org.eclipse.wst.common.internal.emf.utilities.DOMLoadOptions;
import org.eclipse.wst.common.internal.emf.utilities.Revisit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMUtilities {
    public static final String INDENT_STRING = "\t";
    public static final String NEWLINE_STRING = System.getProperty("line.separator");
    private static final String DUMMY_ENTITY_STRING = "dummy";
    private static final String DUMMY_ENTITY_NODE_STRING = "<dummy/>";
    private static DocumentBuilder defaultDocumentBuilder;
    private static EntityResolver defaultEntityResolver;

    public static Iterator createPathIterator(String path) {
        String tPath;
        String string = tPath = path.startsWith("/") ? path.substring(1) : path;
        if (tPath.length() == 0) {
            tPath = null;
        }
        String aPath = tPath;
        return new Iterator(aPath){
            int prevIndex = 0;
            int curIndex = 0;
            String pathString;
            {
                this.pathString = string;
            }

            public boolean hasNext() {
                return this.pathString != null && this.prevIndex != -1;
            }

            public Object next() {
                this.curIndex = this.pathString.indexOf(47, this.prevIndex);
                String nodeString = null;
                nodeString = this.curIndex != -1 ? this.pathString.substring(this.prevIndex, this.curIndex++) : this.pathString.substring(this.prevIndex);
                this.prevIndex = this.curIndex;
                return nodeString;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String getChildText(Node node) {
        Text textNode = DOMUtilities.getChildTextNode(node);
        if (textNode != null) {
            return textNode.getData();
        }
        return null;
    }

    public static Text getChildTextNode(Node node) {
        Node textNode = node.getFirstChild();
        while (textNode != null && DOMUtilities.isTextNode(textNode)) {
            if (!DOMUtilities.isWhitespace(textNode)) {
                return (Text)textNode;
            }
            textNode = textNode.getNextSibling();
        }
        return null;
    }

    public static String getIndentString(Node node) {
        Revisit.toDo();
        return "";
    }

    public static Node getLastNodeChild(Node node) {
        if (node == null) {
            return null;
        }
        Node child = node.getLastChild();
        while (child != null && child.getNodeType() == 3) {
            child = child.getPreviousSibling();
        }
        return child;
    }

    public static Node getNextNodeSibling(Node node) {
        Node sibling = node.getNextSibling();
        while (sibling != null && sibling.getNodeType() != 1) {
            sibling = sibling.getNextSibling();
        }
        return sibling;
    }

    public static Node getNodeChild(Node node, String nodeName) {
        Node child = null;
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equals(nodeName)) {
                child = n;
                break;
            }
            ++i;
        }
        return child;
    }

    public static Node getNodeChildForPath(Node parent, String pathName) {
        Node curNode = parent;
        Iterator i = DOMUtilities.createPathIterator(pathName);
        while (i.hasNext()) {
            String child = (String)i.next();
            if ((curNode = DOMUtilities.getNodeChild(curNode, child)) != null) continue;
            return null;
        }
        return curNode;
    }

    public static List getNodeChildren(Node node, String[] nodeNames) {
        NodeList childNodes = node.getChildNodes();
        ArrayList<Node> results = new ArrayList<Node>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeType() == 1) {
                boolean found = false;
                int j = 0;
                while (j < nodeNames.length) {
                    if (nodeNames[j].equals(n.getNodeName())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    results.add(n);
                }
            }
            ++i;
        }
        return results;
    }

    public static List getNodeChildren(Node node, String nodeName) {
        NodeList childNodes = node.getChildNodes();
        ArrayList<Node> results = new ArrayList<Node>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equals(nodeName)) {
                results.add(n);
            }
            ++i;
        }
        return results;
    }

    public static Node getPreviousNodeSibling(Node node) {
        if (node == null) {
            return null;
        }
        Node sibling = node.getPreviousSibling();
        while (sibling != null && DOMUtilities.isTextNode(sibling)) {
            sibling = sibling.getPreviousSibling();
        }
        return sibling;
    }

    public static Text getPreviousText(Node node) {
        Text sibling = DOMUtilities.getPreviousTextSibling(node);
        if (sibling == null && node.getParentNode() != null) {
            sibling = DOMUtilities.getPreviousText(node.getParentNode());
        }
        return sibling;
    }

    public static Text getPreviousTextSibling(Node node) {
        Assert.isNotNull(node);
        Node sibling = node.getPreviousSibling();
        Node lastText = null;
        while (sibling != null && sibling.getNodeType() == 3) {
            lastText = sibling;
            sibling = sibling.getPreviousSibling();
        }
        return (Text)lastText;
    }

    public static String getTrailingWhitespace(Text node) {
        Assert.isNotNull(node);
        String text = node.getData();
        if (text.length() == 0) {
            return "";
        }
        int i = text.length() - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(text.charAt(i))) break;
            --i;
        }
        return text.substring(++i);
    }

    public static void insertAfterNode(Node parent, Node newNode, Node refNode) {
        Node insertBeforeNode = null;
        if (refNode != null) {
            insertBeforeNode = refNode.getNextSibling();
        }
        if (refNode == null) {
            DOMUtilities.insertBeforeNode(parent, newNode, parent.getFirstChild());
        } else {
            DOMUtilities.insertBeforeNode(parent, newNode, insertBeforeNode);
        }
    }

    public static void insertBeforeNode(Node parent, Node newNode, Node refNode) {
        if (newNode.getNodeType() == 3) {
            Node insertAfterNode;
            Text textNewNode = (Text)newNode;
            if (refNode != null && refNode.getNodeType() == 3) {
                Text textRefNode = (Text)refNode;
                textRefNode.setData(String.valueOf(textNewNode.getData()) + textRefNode.getData());
                return;
            }
            Node node = insertAfterNode = refNode == null ? parent.getLastChild() : refNode.getPreviousSibling();
            if (insertAfterNode != null && insertAfterNode.getNodeType() == 3) {
                Text textInsertAfterNode = (Text)insertAfterNode;
                textInsertAfterNode.setData(String.valueOf(textInsertAfterNode.getData()) + textNewNode.getData());
                return;
            }
        }
        parent.insertBefore(newNode, refNode);
    }

    public static void insertBeforeNodeAndWhitespace(Node parent, Node newNode, Node refNode) {
        Node curNode = refNode == null ? parent.getLastChild() : refNode.getPreviousSibling();
        Node lastNode = refNode;
        while (curNode != null && (DOMUtilities.isWhitespace(curNode) || DOMUtilities.isComment(curNode))) {
            lastNode = curNode;
            curNode = curNode.getPreviousSibling();
        }
        DOMUtilities.insertBeforeNode(parent, newNode, lastNode);
    }

    public static boolean isTextNode(Node node) {
        Assert.isNotNull(node);
        return node.getNodeType() == 3 || node.getNodeType() == 4;
    }

    public static boolean isComment(Node node) {
        Assert.isNotNull(node);
        return node.getNodeType() == 8;
    }

    public static boolean isWhitespace(Node node) {
        Assert.isNotNull(node);
        if (node.getNodeType() != 3) {
            return false;
        }
        Text textNode = (Text)node;
        String text = textNode.getData();
        if (text == null) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void removeAllChildren(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            node.removeChild(list.item(i));
            ++i;
        }
    }

    public static ArrayList getAllNodes(Node node, String nodeName) {
        ArrayList nodeList = new ArrayList();
        String[] nodeNames = new String[]{nodeName};
        DOMUtilities.findAllNodes(node, nodeNames, nodeList);
        return nodeList;
    }

    public static ArrayList getAllNodes(Node node, String[] nodeNamesArray) {
        ArrayList nodeList = new ArrayList();
        DOMUtilities.findAllNodes(node, nodeNamesArray, nodeList);
        return nodeList;
    }

    private static void findAllNodes(Node node, String[] nodeNames, ArrayList results) {
        NodeList nodes = node.getChildNodes();
        if (nodes != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                int j = 0;
                while (j < nodeNames.length) {
                    if (nodes.item(i).getNodeName().equals(nodeNames[j])) {
                        results.add(nodes.item(i));
                    }
                    ++j;
                }
                DOMUtilities.findAllNodes(nodes.item(i), nodeNames, results);
                ++i;
            }
        }
    }

    public static DocumentBuilder newDefaultDocumentBuilder(DOMLoadOptions options) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(options.isValidate());
        dbf.setNamespaceAware(options.isValidate());
        try {
            dbf.setAttribute("http://apache.org/xml/features/allow-java-encodings", new Boolean(options.isAllowJavaEncodings()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EcoreUtilitiesPlugin.logWarning("Warning: Parser does not support \"http://apache.org/xml/features/allow-java-encodings\".");
        }
        try {
            dbf.setAttribute("http://apache.org/xml/features/validation/schema", new Boolean(options.isValidate()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            dbf.setValidating(false);
            EcoreUtilitiesPlugin.logWarning("Warning: Parser does not support \"http://apache.org/xml/features/validation/schema\". Validation will be disabled.");
        }
        try {
            dbf.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EcoreUtilitiesPlugin.logWarning("Warning: Parser does not support \"http://apache.org/xml/features/dom/defer-node-expansion\".");
        }
        dbf.setExpandEntityReferences(options.isExpandEntityRefererences());
        DocumentBuilder result = dbf.newDocumentBuilder();
        result.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException arg0) throws SAXException {
                throw arg0;
            }

            public void fatalError(SAXParseException arg0) throws SAXException {
                throw arg0;
            }

            public void warning(SAXParseException arg0) throws SAXException {
                EcoreUtilitiesPlugin.logWarning(arg0);
            }
        });
        return result;
    }

    public static Document createNewDocument(String doctype, String publicId, String systemId) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DOMUtilities.getDefaultDocumentBuilder();
        InputStream in = DOMUtilities.createHeaderInputStream(doctype, publicId, systemId, true);
        Document result = builder.parse(in);
        DOMUtilities.removeDummyEntity(result);
        DOMUtilities.removeExtraneousComments(result);
        return result;
    }

    public static Document loadDocument(InputStream in, DOMLoadOptions options, EntityResolver resolver) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DOMUtilities.newDefaultDocumentBuilder(options);
        builder.setEntityResolver(resolver);
        Document result = builder.parse(in);
        DOMUtilities.removeExtraneousComments(result);
        return result;
    }

    public static InputStream createHeaderInputStream(String doctype, String publicId, String systemId) {
        return DOMUtilities.createHeaderInputStream(doctype, publicId, systemId, false);
    }

    private static InputStream createHeaderInputStream(String doctype, String publicId, String systemId, boolean includeDummy) {
        PrintWriter writer;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            writer = new PrintWriter(outputWriter);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            writer = new PrintWriter(outputStream);
        }
        DOMUtilities.writeHeader(writer, doctype, publicId, systemId);
        if (includeDummy) {
            DOMUtilities.addDummyEntity(writer);
        }
        writer.flush();
        writer.close();
        byte[] bytes = outputStream.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    private static void writeHeader(PrintWriter writer, String doctype, String publicId, String systemId) {
        writer.write("<?xml version=\"");
        writer.write("1.0");
        writer.write("\" encoding=\"");
        writer.write("UTF-8");
        writer.write("\"?>");
        writer.println();
        if (doctype != null) {
            writer.write("<!DOCTYPE ");
            writer.write(doctype);
            writer.write(" PUBLIC \"");
            writer.write(publicId);
            writer.write("\" \"");
            writer.write(systemId);
            writer.write("\">");
            writer.println();
        }
    }

    private static void addDummyEntity(PrintWriter writer) {
        Revisit.revisit();
        writer.println(DUMMY_ENTITY_NODE_STRING);
    }

    private static void removeDummyEntity(Document doc) {
        doc.removeChild(DOMUtilities.getNodeChild(doc, DUMMY_ENTITY_STRING));
    }

    private static void removeExtraneousComments(Document doc) {
        Node aNode = doc.getFirstChild();
        while (aNode != null) {
            Node nextNode = aNode.getNextSibling();
            if (aNode.getNodeType() == 8) {
                doc.removeChild(aNode);
            }
            aNode = nextNode;
        }
    }

    public static DocumentBuilder getDefaultDocumentBuilder() throws ParserConfigurationException {
        if (defaultDocumentBuilder == null) {
            DOMLoadOptions opts = new DOMLoadOptions();
            opts.setAllowJavaEncodings(true);
            opts.setExpandEntityRefererences(true);
            opts.setValidate(false);
            defaultDocumentBuilder = DOMUtilities.newDefaultDocumentBuilder(opts);
            defaultDocumentBuilder.setEntityResolver(defaultEntityResolver);
            defaultDocumentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                }

                public void warning(SAXParseException exception) throws SAXException {
                }
            });
        }
        return defaultDocumentBuilder;
    }

    public static EntityResolver getDefaultEntityResolver() {
        return defaultEntityResolver;
    }

    public static void setDefaultEntityResolver(EntityResolver resolver) {
        defaultEntityResolver = resolver;
    }
}

