/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.tasks.bugs.Messages;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProduct;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ErrorLogStatus;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ProductStatus;
import org.eclipse.mylyn.tasks.bugs.AbstractSupportHandler;
import org.eclipse.mylyn.tasks.bugs.ISupportRequest;
import org.eclipse.mylyn.tasks.bugs.ISupportResponse;
import org.eclipse.mylyn.tasks.bugs.ITaskContribution;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSupportHandler
extends AbstractSupportHandler {
    @Override
    public void preProcess(ISupportRequest request) {
        ITaskContribution contribution = request.getDefaultContribution();
        String description = this.getDescription(contribution.getStatus());
        if (description != null) {
            contribution.appendToDescription(description);
        }
    }

    @Override
    public void process(ITaskContribution contribution, IProgressMonitor monitor) {
        String description;
        if (contribution.getAttribute("description") == null && (description = this.getDescription(contribution.getStatus())) != null) {
            contribution.appendToDescription(description);
        }
    }

    @Override
    public void postProcess(ISupportResponse response, IProgressMonitor monitor) {
        String version;
        TaskAttribute attribute;
        IBundleGroup bundleGroup;
        IStatus contribution = response.getStatus();
        TaskData taskData = response.getTaskData();
        if (contribution instanceof ProductStatus) {
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)taskData.getConnectorKind());
            ITaskMapping mapping = connector.getTaskMapping(taskData);
            mapping.merge((ITaskMapping)new TaskMapping(){

                public String getSeverity() {
                    return "enhancement";
                }
            });
        }
        if (response.getProduct() != null && (bundleGroup = ((SupportProduct)response.getProduct()).getBundleGroup()) != null && (attribute = taskData.getRoot().getMappedAttribute("task.common.version")) != null && (version = this.getBestMatch(bundleGroup.getVersion(), attribute.getOptions())).length() > 0) {
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)taskData.getConnectorKind());
            ITaskMapping mapping = connector.getTaskMapping(taskData);
            mapping.merge((ITaskMapping)new TaskMapping(){

                public String getVersion() {
                    return version;
                }
            });
        }
    }

    private String getBestMatch(String version, Map<String, String> options) {
        String match = "";
        for (String option : options.values()) {
            if (!version.startsWith(option) || option.length() <= match.length()) continue;
            match = option;
        }
        return match;
    }

    public void appendErrorDetails(StringBuilder sb, IStatus status, Date date) {
        sb.append("\n\n");
        sb.append(Messages.DefaultTaskContributor_Error_Details);
        if (date != null) {
            sb.append("\n");
            sb.append(NLS.bind((String)Messages.DefaultSupportHandler_Date_X, (Object)date));
        }
        sb.append("\n");
        sb.append(NLS.bind((String)Messages.DefaultSupportHandler_Message_X, (Object)status.getMessage()));
        sb.append("\n");
        sb.append(NLS.bind((String)Messages.DefaultSupportHandler_Severity_X, (Object)this.getSeverityText(status.getSeverity())));
        this.appendProductInformation(sb);
        sb.append("\n");
        sb.append(NLS.bind((String)Messages.DefaultSupportHandler_Plugin_X, (Object)status.getPlugin()));
    }

    private void appendProductInformation(StringBuilder sb) {
        IProduct product = Platform.getProduct();
        if (product != null) {
            Object version;
            sb.append("\n");
            if (product.getName() != null) {
                sb.append(NLS.bind((String)Messages.DefaultSupportHandler_Product_X, (Object)product.getName()));
            } else {
                sb.append(NLS.bind((String)Messages.DefaultSupportHandler_Product_X, (Object)product.getId()));
            }
            Bundle definingBundle = product.getDefiningBundle();
            if (definingBundle != null && (version = definingBundle.getHeaders().get("Bundle-Version")) != null) {
                sb.append(" ");
                sb.append(version);
            }
            if (product.getName() != null) {
                sb.append(NLS.bind((String)" ({0})", (Object)product.getId()));
            }
        }
    }

    public String getDescription(IStatus status) {
        if (status instanceof ProductStatus) {
            SupportProduct product = (SupportProduct)((ProductStatus)status).getProduct();
            if (product.getBundleGroup() != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("\n\n\n");
                sb.append(Messages.DefaultSupportHandler_Configuration_Details);
                this.appendProductInformation(sb);
                sb.append("\n");
                sb.append(Messages.DefaultSupportHandler_Installed_Features);
                sb.append("\n");
                IBundleGroup[] iBundleGroupArray = new IBundleGroup[]{product.getBundleGroup()};
                int n = iBundleGroupArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBundleGroup bundleGroup = iBundleGroupArray[n2];
                    sb.append(" ");
                    sb.append(bundleGroup.getIdentifier());
                    sb.append(" ");
                    sb.append(bundleGroup.getVersion());
                    sb.append("\n");
                    ++n2;
                }
                return sb.toString();
            }
        } else {
            if (status instanceof ErrorLogStatus) {
                ErrorLogStatus errorLogStatus = (ErrorLogStatus)status;
                StringBuilder sb = new StringBuilder();
                sb.append("\n\n");
                sb.append(Messages.DefaultSupportHandler_What_steps_message);
                sb.append("\n");
                sb.append(Messages.DefaultSupportHandler_Step_1);
                sb.append(Messages.DefaultSupportHandler_Step_2);
                sb.append(Messages.DefaultSupportHandler_Step_3);
                this.appendStatus((IStatus)errorLogStatus, sb, true);
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder();
            this.appendErrorDetails(sb, status, new Date());
            if (status.getException() != null) {
                sb.append(Messages.DefaultTaskContributor_EXCEPTION_STACK_TRACE);
                StringWriter writer = new StringWriter();
                status.getException().printStackTrace(new PrintWriter(writer));
                sb.append(writer.getBuffer());
            }
            return sb.toString();
        }
        return null;
    }

    private void appendStatus(IStatus status, StringBuilder sb, boolean includeSessionData) {
        IStatus[] children;
        Date date = status instanceof ErrorLogStatus ? ((ErrorLogStatus)status).getDate() : null;
        this.appendErrorDetails(sb, status, date);
        if (status instanceof ErrorLogStatus) {
            ErrorLogStatus errorStatus = (ErrorLogStatus)status;
            if (includeSessionData && errorStatus.getLogSessionData() != null) {
                sb.append(Messages.DefaultTaskContributor_SESSION_DATA);
                sb.append(errorStatus.getLogSessionData());
            }
            if (errorStatus.getStack() != null) {
                sb.append(Messages.DefaultTaskContributor_EXCEPTION_STACK_TRACE);
                sb.append(errorStatus.getStack());
            }
        }
        if ((children = status.getChildren()) != null) {
            IStatus[] iStatusArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.appendStatus(child, sb, false);
                ++n2;
            }
        }
    }

    private String getSeverityText(int severity) {
        switch (severity) {
            case 4: {
                return Messages.DefaultTaskContributor_Error;
            }
            case 2: {
                return Messages.DefaultTaskContributor_Warning;
            }
            case 1: {
                return Messages.DefaultTaskContributor_Info;
            }
            case 0: {
                return Messages.DefaultTaskContributor_OK;
            }
        }
        return "?";
    }
}

