/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class TableBlock
extends Block {
    static final Pattern startPattern = Pattern.compile("(\\|(.*)?(\\|\\s*$))");
    static final Pattern TABLE_ROW_PATTERN = Pattern.compile("\\|(\\|)?((?:(?:[^\\|\\[]*)(?:\\[[^\\]]*\\])?)*)(\\|\\|?\\s*$)?");
    private int blockLineCount = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        int start;
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, attributes);
        } else if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        ++this.blockLineCount;
        if (offset == line.length()) {
            return -1;
        }
        String textileLine = offset == 0 ? line : line.substring(offset);
        Matcher rowMatcher = TABLE_ROW_PATTERN.matcher(textileLine);
        if (!rowMatcher.find()) {
            this.setClosed(true);
            return 0;
        }
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, new Attributes());
        while ((start = rowMatcher.start()) != textileLine.length() - 1) {
            String headerIndicator = rowMatcher.group(1);
            String text = rowMatcher.group(2);
            int lineOffset = offset + rowMatcher.start(2);
            boolean header = headerIndicator != null && "|".equals(headerIndicator);
            Attributes attributes = new Attributes();
            this.builder.beginBlock(header ? DocumentBuilder.BlockType.TABLE_CELL_HEADER : DocumentBuilder.BlockType.TABLE_CELL_NORMAL, attributes);
            this.markupLanguage.emitMarkupLine(this.getParser(), this.state, lineOffset, text, 0);
            this.builder.endBlock();
            if (rowMatcher.find()) continue;
        }
        this.builder.endBlock();
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

