/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualOverride;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.OverrideTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaOverrideTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.java.OverrideAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaOverride<C extends JavaOverrideContainer, A extends OverrideAnnotation>
extends AbstractJavaJpaContextNode
implements JavaOverride {
    protected final A overrideAnnotation;
    protected String name;

    protected AbstractJavaOverride(C parent, A overrideAnnotation) {
        super((JpaContextNode)parent);
        this.overrideAnnotation = overrideAnnotation;
        this.name = this.buildName();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.buildName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.overrideAnnotation.setName(name);
        this.setName_(this.stripPrefix(name));
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    protected String buildName() {
        return this.stripPrefix(this.overrideAnnotation.getName());
    }

    protected String stripPrefix(String rawName) {
        if (rawName == null) {
            return null;
        }
        String prefix = this.getPossiblePrefix();
        if (prefix == null) {
            return rawName;
        }
        int prefixLength = prefix.length();
        if (rawName.length() > prefixLength && rawName.charAt(prefixLength) == '.' && rawName.startsWith(prefix)) {
            return rawName.substring(prefixLength + 1);
        }
        return rawName;
    }

    protected String getPossiblePrefix() {
        return this.getContainer().getPossiblePrefix();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public JavaVirtualOverride convertToVirtual() {
        return this.getContainer().convertOverrideToVirtual(this);
    }

    public C getParent() {
        return (C)((JavaOverrideContainer)super.getParent());
    }

    public C getContainer() {
        return (C)this.getParent();
    }

    public A getOverrideAnnotation() {
        return this.overrideAnnotation;
    }

    protected void initializeFrom(ReadOnlyOverride oldOverride) {
        this.setName(this.prefix(oldOverride.getName()));
    }

    protected void initializeFromVirtual(ReadOnlyOverride virtualOverride) {
        this.setName(this.prefix(virtualOverride.getName()));
    }

    protected String prefix(String oldName) {
        if (oldName == null) {
            return null;
        }
        String prefix = this.getWritePrefix();
        return prefix == null ? oldName : String.valueOf(prefix) + '.' + oldName;
    }

    protected String getWritePrefix() {
        return this.getContainer().getWritePrefix();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.javaCandidateNames(filter);
        }
        return null;
    }

    protected boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.overrideAnnotation.nameTouches(pos, astRoot);
    }

    protected Iterator<String> javaCandidateNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateNames(filter));
    }

    private Iterator<String> candidateNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateNames(), filter);
    }

    protected abstract Iterator<String> candidateNames();

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.buildValidator(astRoot).validate(messages, reporter);
    }

    protected JptValidator buildValidator(CompilationUnit astRoot) {
        return this.getContainer().buildValidator(this, this.buildTextRangeResolver(astRoot));
    }

    protected OverrideTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaOverrideTextRangeResolver(this, astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.overrideAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getContainer().getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.overrideAnnotation.getNameTextRange(astRoot), astRoot);
    }
}

