/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.libprov.JpaLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformGroupDescription;

public class JpaPlatformTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!property.equals("jpaPlatform") && !property.equals("jpaPlatformGroup") || !(expectedValue instanceof String)) {
            return false;
        }
        JpaPlatformDescription platform = null;
        if (receiver instanceof IResource) {
            platform = this.platform(((IResource)receiver).getProject());
        } else if (receiver instanceof IJavaElement) {
            platform = this.platform(((IJavaElement)receiver).getResource().getProject());
        } else if (receiver instanceof JpaPlatformDescription) {
            platform = (JpaPlatformDescription)receiver;
        } else if (receiver instanceof JpaLibraryProviderInstallOperationConfig) {
            platform = ((JpaLibraryProviderInstallOperationConfig)receiver).getJpaPlatform();
        }
        if (property.equals("jpaPlatform")) {
            JpaPlatformDescription otherPlatform = JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform((String)expectedValue);
            return platform == null ? false : platform.equals(otherPlatform);
        }
        if (property.equals("jpaPlatformGroup")) {
            JpaPlatformGroupDescription group = platform == null ? null : platform.getGroup();
            JpaPlatformGroupDescription otherGroup = JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatformGroup((String)expectedValue);
            return group == null ? false : group.equals(otherGroup);
        }
        return false;
    }

    private JpaPlatformDescription platform(IProject project) {
        return project == null ? null : JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform(JptJpaCorePlugin.getJpaPlatformId(project));
    }
}

