/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.libval;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.common.core.internal.utility.XPointTools;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jst.common.project.facet.core.internal.FacetedProjectFrameworkJavaPlugin;

public class LibraryValidatorConfig {
    public static final String CONFIG_EXPR_VAR = "config";
    public static final String LIBRARY_PROVIDER_EXPR_VAR = "libraryProvider";
    private String id;
    private String pluginId;
    private String className;
    private Expression enablementCondition;

    LibraryValidatorConfig() {
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getClassName() {
        return this.className;
    }

    void setClassName(String className) {
        this.className = className;
    }

    public Expression getEnablementCondition() {
        return this.enablementCondition;
    }

    void setEnablementCondition(Expression enablementCondition) {
        this.enablementCondition = enablementCondition;
    }

    public LibraryValidator getLibraryValidator() {
        return XPointTools.instantiate(this.pluginId, "org.eclipse.jpt.common.core.libraryValidators", this.className, LibraryValidator.class);
    }

    public boolean isEnabledFor(JptLibraryProviderInstallOperationConfig config) {
        EvaluationContext evalContext = new EvaluationContext(null, (Object)config);
        evalContext.setAllowPluginActivation(true);
        evalContext.addVariable(CONFIG_EXPR_VAR, (Object)config);
        evalContext.addVariable(LIBRARY_PROVIDER_EXPR_VAR, (Object)config.getLibraryProvider());
        if (this.enablementCondition != null) {
            try {
                EvaluationResult evalResult = this.enablementCondition.evaluate((IEvaluationContext)evalContext);
                if (evalResult == EvaluationResult.FALSE) {
                    return false;
                }
            }
            catch (CoreException e) {
                FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
            }
        }
        return true;
    }
}

