/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WebBrowserDialog
extends MessageDialog {
    private String data = null;
    private static Boolean browserAvailable;

    public WebBrowserDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String data) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.data = data;
        this.setShellStyle(1264);
    }

    public static int openAcceptAgreement(Shell parent, String title, String message, String data) {
        if (WebBrowserDialog.isInternalBrowserAvailable((Composite)parent)) {
            WebBrowserDialog dialog = new WebBrowserDialog(parent, title, null, message, 0, new String[]{IDialogConstants.OK_LABEL}, 0, data);
            return dialog.open();
        }
        File file = null;
        try {
            file = File.createTempFile("mylyn-error", ".html");
            file.deleteOnExit();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            try {
                writer.write(message);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            if (file != null) {
                file.delete();
            }
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unexpected error while displaying error", (Throwable)e));
            return 1;
        }
        WorkbenchUtil.openUrl((String)file.toURI().toString(), (int)128);
        return 0;
    }

    public Control createCustomArea(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        layout.numColumns = 1;
        Browser b = new Browser(parent, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.verticalSpan = 50;
        b.setLayoutData((Object)gd);
        b.setText(this.data);
        return parent;
    }

    private static synchronized boolean isInternalBrowserAvailable(Composite composite) {
        if (browserAvailable == null) {
            try {
                Browser browser = new Browser(composite, 0);
                browser.dispose();
                browserAvailable = true;
            }
            catch (SWTError sWTError) {
                browserAvailable = false;
            }
        }
        return browserAvailable;
    }
}

