/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.oxm.record.DOMInputSource;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.namespaces.StackUnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;

public class DOMReader
extends XMLReaderAdapter {
    private Node currentNode;
    private DocumentPreservationPolicy docPresPolicy;

    public DOMReader() {
    }

    public DOMReader(XMLUnmarshaller xmlUnmarshaller) {
        super(xmlUnmarshaller);
    }

    public void parse(InputSource input) throws SAXException {
        if (input instanceof DOMInputSource) {
            Node node = ((DOMInputSource)input).getNode();
            if (this.contentHandler != null && this.contentHandler.getClass() == SAXUnmarshallerHandler.class) {
                ((SAXUnmarshallerHandler)this.contentHandler).setUnmarshalNamespaceResolver(new StackUnmarshalNamespaceResolver());
            }
            this.parse(node);
        }
    }

    public void parse(Node node) throws SAXException {
        if (null == this.contentHandler) {
            return;
        }
        Element rootNode = null;
        rootNode = node.getNodeType() == 9 ? ((Document)node).getDocumentElement() : (Element)node;
        this.processParentNamespaces(rootNode);
        this.startDocument();
        this.setupLocator(rootNode.getOwnerDocument());
        this.reportElementEvents(rootNode);
        this.endDocument();
    }

    protected void processParentNamespaces(Element element) throws SAXException {
        Node parent = element.getParentNode();
        if (parent != null && parent.getNodeType() == 9) {
            return;
        }
        ArrayList<Node> parentElements = new ArrayList<Node>();
        while (parent != null && parent.getNodeType() != 9) {
            parentElements.add(parent);
            parent = parent.getParentNode();
        }
        Iterator stackIt = parentElements.iterator();
        while (stackIt.hasNext()) {
            NamedNodeMap attrs = ((Node)parentElements.remove(parentElements.size() - 1)).getAttributes();
            if (attrs == null) continue;
            int length = attrs.getLength();
            for (int i = 0; i < length; ++i) {
                Attr next = (Attr)attrs.item(i);
                String attrPrefix = next.getPrefix();
                if (attrPrefix == null || !attrPrefix.equals("xmlns")) continue;
                this.contentHandler.startPrefixMapping(next.getLocalName(), next.getValue());
            }
        }
    }

    protected void reportElementEvents(Element elem) throws SAXException {
        String qname;
        this.currentNode = elem;
        IndexedAttributeList attributes = this.buildAttributeList(elem);
        String lname = elem.getLocalName();
        if (lname == null) {
            qname = lname = elem.getNodeName();
            this.handlePrefixedAttribute(elem);
        } else {
            qname = this.getQName(elem);
        }
        this.contentHandler.startElement(elem.getNamespaceURI(), lname, qname, attributes);
        this.handleChildNodes(elem.getChildNodes());
        this.contentHandler.endElement(elem.getNamespaceURI(), lname, qname);
        this.endPrefixMappings(elem);
    }

    protected IndexedAttributeList buildAttributeList(Element elem) throws SAXException {
        IndexedAttributeList attributes = new IndexedAttributeList();
        NamedNodeMap attrs = elem.getAttributes();
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            Attr next = (Attr)attrs.item(i);
            String attrPrefix = next.getPrefix();
            if (attrPrefix != null && attrPrefix.equals("xmlns")) {
                this.contentHandler.startPrefixMapping(next.getLocalName(), next.getValue());
                this.handleXMLNSPrefixedAttribute(elem, next);
            } else if (attrPrefix == null) {
                String name = next.getLocalName();
                if (name == null) {
                    name = next.getNodeName();
                }
                if (name != null && name.equals("xmlns")) {
                    this.contentHandler.startPrefixMapping("", next.getValue());
                }
            }
            if (next.getNamespaceURI() != null && next.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance") && next.getLocalName().equals("type")) {
                this.handleXsiTypeAttribute(next);
            }
            attributes.addAttribute(next);
        }
        return attributes;
    }

    protected void endPrefixMappings(Element elem) throws SAXException {
        NamedNodeMap attrs = elem.getAttributes();
        int numOfAtts = attrs.getLength();
        for (int i = 0; i < numOfAtts; ++i) {
            Attr next = (Attr)attrs.item(i);
            String attrPrefix = next.getPrefix();
            if (attrPrefix != null && attrPrefix.equals("xmlns")) {
                this.contentHandler.endPrefixMapping(next.getLocalName());
                continue;
            }
            if (attrPrefix != null) continue;
            String name = next.getLocalName();
            if (name == null) {
                name = next.getNodeName();
            }
            if (!"xmlns".equals(name)) continue;
            this.contentHandler.endPrefixMapping("");
        }
    }

    protected String getQName(Element elem) throws SAXException {
        this.handlePrefixedAttribute(elem);
        String prefix = elem.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            String qname = prefix + ':' + elem.getLocalName();
            return qname;
        }
        return elem.getLocalName();
    }

    protected void handleXMLNSPrefixedAttribute(Element elem, Attr attr) {
    }

    protected void handleXsiTypeAttribute(Attr attr) throws SAXException {
    }

    protected void handlePrefixedAttribute(Element elem) throws SAXException {
    }

    protected void handleChildNodes(NodeList children) throws SAXException {
        Node nextChild = null;
        if (children.getLength() > 0) {
            nextChild = children.item(0);
        }
        while (nextChild != null) {
            char[] value;
            if (nextChild.getNodeType() == 3) {
                value = ((Text)nextChild).getNodeValue().toCharArray();
                this.contentHandler.characters(value, 0, value.length);
            } else if (nextChild.getNodeType() == 8) {
                value = ((Comment)nextChild).getNodeValue().toCharArray();
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.comment(value, 0, value.length);
                }
            } else if (nextChild.getNodeType() == 1) {
                Element childElement = (Element)nextChild;
                this.reportElementEvents(childElement);
            } else if (nextChild.getNodeType() == 4) {
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.startCDATA();
                }
                value = ((CDATASection)nextChild).getData().toCharArray();
                this.contentHandler.characters(value, 0, value.length);
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.endCDATA();
                }
            }
            nextChild = nextChild.getNextSibling();
        }
    }

    protected void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    protected void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void newObjectEvent(Object object, Object parent, XMLMapping selfRecordMapping) {
        this.docPresPolicy.addObjectToCache(object, this.currentNode, selfRecordMapping);
    }

    public Object getCurrentObject(AbstractSession session, XMLMapping selfRecordMapping) {
        if (session == null && this.docPresPolicy == null) {
            return null;
        }
        if (this.docPresPolicy == null) {
            XMLLogin login = (XMLLogin)session.getDatasourceLogin();
            this.docPresPolicy = login.getDocumentPreservationPolicy();
        }
        return this.docPresPolicy.getObjectForNode(this.currentNode, selfRecordMapping);
    }

    public DocumentPreservationPolicy getDocPresPolicy() {
        return this.docPresPolicy;
    }

    public void setDocPresPolicy(DocumentPreservationPolicy policy) {
        this.docPresPolicy = policy;
    }

    protected void setupLocator(Document doc) {
        LocatorImpl locator = new LocatorImpl();
        try {
            Method getEncoding = PrivilegedAccessHelper.getMethod(doc.getClass(), "getXmlEncoding", new Class[0], true);
            Method getVersion = PrivilegedAccessHelper.getMethod(doc.getClass(), "getXmlVersion", new Class[0], true);
            String encoding = (String)PrivilegedAccessHelper.invokeMethod(getEncoding, doc, new Object[0]);
            String version = (String)PrivilegedAccessHelper.invokeMethod(getVersion, doc, new Object[0]);
            locator.setEncoding(encoding);
            locator.setXMLVersion(version);
        }
        catch (Exception ex) {
            return;
        }
        this.contentHandler.setDocumentLocator(locator);
    }

    protected class IndexedAttributeList
    implements Attributes {
        private List<Attr> attrs = new ArrayList<Attr>();

        public void addAttribute(Attr attribute) {
            this.attrs.add(attribute);
        }

        public String getQName(int index) {
            try {
                Attr item = this.attrs.get(index);
                if (item.getName() != null) {
                    return item.getName();
                }
                return "";
            }
            catch (IndexOutOfBoundsException iobe) {
                return null;
            }
        }

        public String getType(String namespaceUri, String localName) {
            return "CDATA";
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getType(String qname) {
            return "CDATA";
        }

        public int getIndex(String qname) {
            int size = this.attrs.size();
            for (int i = 0; i < size; ++i) {
                if (!this.attrs.get(i).getName().equals(qname)) continue;
                return i;
            }
            return -1;
        }

        public int getIndex(String uri, String localName) {
            int size = this.attrs.size();
            for (int i = 0; i < size; ++i) {
                Attr item = this.attrs.get(i);
                try {
                    if (!item.getNamespaceURI().equals(uri) || !item.getLocalName().equals(localName)) continue;
                    return i;
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            return -1;
        }

        public int getLength() {
            return this.attrs.size();
        }

        public String getLocalName(int index) {
            try {
                Attr item = this.attrs.get(index);
                if (item.getLocalName() != null) {
                    return item.getLocalName();
                }
                return item.getName();
            }
            catch (IndexOutOfBoundsException iobe) {
                return null;
            }
        }

        public String getURI(int index) {
            return this.attrs.get(index).getNamespaceURI();
        }

        public String getValue(int index) {
            return this.attrs.get(index).getValue();
        }

        public String getValue(String qname) {
            int size = this.attrs.size();
            for (int i = 0; i < size; ++i) {
                Attr item = this.attrs.get(i);
                if (!item.getName().equals(qname)) continue;
                return item.getValue();
            }
            return null;
        }

        public String getValue(String uri, String localName) {
            int size = this.attrs.size();
            for (int i = 0; i < size; ++i) {
                Attr item = this.attrs.get(i);
                if (item == null) continue;
                String itemNS = item.getNamespaceURI();
                if (item.getNamespaceURI() == null) {
                    itemNS = "";
                }
                if (!itemNS.equals(uri) || item.getLocalName() == null || !item.getLocalName().equals(localName)) continue;
                return item.getValue();
            }
            return null;
        }
    }

    protected class LocatorImpl
    implements Locator2 {
        private String encoding = "UTF-8";
        private String version = "1.0";

        public String getEncoding() {
            return this.encoding;
        }

        public int getColumnNumber() {
            return 0;
        }

        public String getSystemId() {
            return "";
        }

        public String getPublicId() {
            return "";
        }

        public String getXMLVersion() {
            return this.version;
        }

        public int getLineNumber() {
            return 0;
        }

        protected void setEncoding(String enc) {
            this.encoding = enc;
        }

        protected void setXMLVersion(String xmlVersion) {
            this.version = xmlVersion;
        }
    }
}

