/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.cm.attributevalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.features.PossibleValue;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.WebPathType;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class TemplateWebPathType
extends WebPathType
implements IPossibleValues {
    public List getPossibleValues() {
        Node node;
        IStructuredDocumentContext context = this.getStructuredDocumentContext();
        IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        if (resolver != null && (node = resolver.getNode()) instanceof Attr) {
            return this.createPossibleValues((Attr)node);
        }
        return Collections.EMPTY_LIST;
    }

    private List createPossibleValues(Attr node) {
        IResource[] allResources;
        IVirtualContainer webRoot;
        Path currentPath;
        IVirtualResource deepestElement;
        String currentPathString = node.getNodeValue();
        ArrayList<PossibleValue> possibleValues = new ArrayList<PossibleValue>();
        if (currentPathString == null || "".equals(currentPathString.trim())) {
            currentPathString = "/";
        }
        if ((deepestElement = this.findDeepestCommonElement((IPath)(currentPath = new Path(currentPathString)), webRoot = this.getWebRoot())) == null) {
            return possibleValues;
        }
        IResource[] iResourceArray = allResources = deepestElement.getUnderlyingResources();
        int n = allResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IContainer) {
                try {
                    IResource[] iResourceArray2 = ((IContainer)res).members();
                    int n3 = iResourceArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource child = iResourceArray2[n4];
                        if (child.exists()) {
                            IPath childPath = child.getProjectRelativePath();
                            int numLeadingSegments = webRoot.getProjectRelativePath().matchingFirstSegments(childPath);
                            childPath = childPath.removeFirstSegments(numLeadingSegments);
                            String pathName = null;
                            pathName = currentPath.isAbsolute() ? childPath.makeAbsolute().toString() : childPath.makeRelative().toString();
                            PossibleValue pv = new PossibleValue(pathName, pathName);
                            possibleValues.add(pv);
                        }
                        ++n4;
                    }
                }
                catch (CoreException ce) {
                    FaceletCorePlugin.log("While trying possible values", ce);
                }
            }
            ++n2;
        }
        return possibleValues;
    }

    private IVirtualResource findDeepestCommonElement(IPath currentPath, IVirtualContainer webRoot) {
        String[] segments = currentPath.segments();
        IVirtualResource deepestElement = null;
        if (segments != null) {
            Path longestSubPath = new Path("");
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                deepestElement = webRoot.findMember((IPath)(longestSubPath = longestSubPath.append(segment)));
                if (deepestElement == null) {
                    longestSubPath = longestSubPath.removeLastSegments(1);
                    break;
                }
                ++n2;
            }
            deepestElement = webRoot.findMember((IPath)longestSubPath);
            if (deepestElement == null) {
                deepestElement = webRoot;
            } else {
                int avoidInfiniteLoopCount = 0;
                while (avoidInfiniteLoopCount < 1000 && deepestElement != null && !(deepestElement.getUnderlyingResource() instanceof IContainer)) {
                    deepestElement = deepestElement.getParent();
                }
                if (avoidInfiniteLoopCount == 1000) {
                    throw new IllegalStateException();
                }
            }
        }
        return deepestElement;
    }

    private IVirtualContainer getWebRoot() {
        IVirtualFolder webRoot = ComponentCore.createComponent((IProject)this.getProject()).getRootFolder();
        return webRoot;
    }
}

