/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.gathering.settings;

import org.eclipse.epp.usagedata.internal.gathering.UsageDataCaptureActivator;
import org.eclipse.jface.preference.IPreferenceStore;

public class UsageDataCaptureSettings {
    public static final String CAPTURE_ENABLED_KEY = "org.eclipse.epp.usagedata.gathering.enabled";
    public static final String USER_ACCEPTED_TERMS_OF_USE_KEY = "org.eclipse.epp.usagedata.gathering.terms_accepted";

    public boolean isEnabled() {
        if (System.getProperties().containsKey(CAPTURE_ENABLED_KEY)) {
            return "true".equals(System.getProperty(CAPTURE_ENABLED_KEY));
        }
        if (this.getPreferencesStore().contains(CAPTURE_ENABLED_KEY)) {
            return this.getPreferencesStore().getBoolean(CAPTURE_ENABLED_KEY);
        }
        return true;
    }

    public void setEnabled(boolean value) {
        if (this.getPreferencesStore().getBoolean(CAPTURE_ENABLED_KEY) == value) {
            return;
        }
        this.getPreferencesStore().setValue(CAPTURE_ENABLED_KEY, value);
    }

    private IPreferenceStore getPreferencesStore() {
        return UsageDataCaptureActivator.getDefault().getPreferenceStore();
    }

    public boolean hasUserAcceptedTermsOfUse() {
        return this.getPreferencesStore().getBoolean(USER_ACCEPTED_TERMS_OF_USE_KEY);
    }

    public void setUserAcceptedTermsOfUse(boolean value) {
        this.getPreferencesStore().setValue(USER_ACCEPTED_TERMS_OF_USE_KEY, value);
    }
}

