/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.team;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.core.events.ISystemModelChangeEvent;
import org.eclipse.rse.core.events.ISystemModelChangeListener;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.actions.SystemCollapseAllAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonDeleteAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonRenameAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonSelectAllAction;
import org.eclipse.rse.internal.ui.actions.SystemNewProfileAction;
import org.eclipse.rse.internal.ui.actions.SystemSubMenuManager;
import org.eclipse.rse.internal.ui.actions.SystemTeamReloadAction;
import org.eclipse.rse.internal.ui.view.SystemViewMenuListener;
import org.eclipse.rse.internal.ui.view.SystemViewPart;
import org.eclipse.rse.internal.ui.view.team.SystemTeamView;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewCategoryNode;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewContentProvider;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewInputProvider;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewLabelProvider;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewProfileAdapter;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewRefreshAllAction;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewSubSystemConfigurationNode;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.ISystemDeleteTarget;
import org.eclipse.rse.ui.ISystemRenameTarget;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class SystemTeamViewPart
extends ViewPart
implements ISetSelectionTarget,
ISelectionProvider,
ISystemModelChangeListener,
ISystemMessageLine,
ISelectionChangedListener,
ISystemDeleteTarget,
ISystemRenameTarget,
IRSEViewPart {
    private boolean menuListenerAdded;
    public static final String ID = "org.eclipse.rse.ui.view.teamView";
    private SystemTeamViewInputProvider input = null;
    private SystemTeamView treeViewer = null;
    private IStatusLineManager statusLine = null;
    private String message;
    private String errorMessage;
    private SystemMessage sysErrorMessage;
    private ListenerList selectionChangedListeners = new ListenerList(1);
    protected SystemTeamReloadAction reloadRSEAction;
    protected SystemNewProfileAction newProfileAction;
    protected SystemCommonDeleteAction deleteAction;
    protected PropertyDialogAction propertyDialogAction;
    protected SystemTeamViewRefreshAllAction toolBarRefreshAllAction;
    protected SystemTeamViewRefreshAllAction menuRefreshAllAction;
    protected SystemCollapseAllAction collapseAllAction;
    private IMemento fMemento;
    static final String TAG_RELEASE = "release";
    static final String TAG_SELECTION = "selection";
    static final String TAG_EXPANDED_TO = "expandedTo";
    static final String TAG_EXPANDED = "expanded";
    static final String TAG_ELEMENT = "element";
    static final String TAG_PATH = "path";
    static final String TAG_INPUT = "svInput";
    static final String TAG_VERTICAL_POSITION = "verticalPosition";
    static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    static final String MEMENTO_DELIM = "///";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    public IStructuredSelection getStructuredSelection() {
        return (IStructuredSelection)this.treeViewer.getSelection();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public Viewer getRSEViewer() {
        return this.treeViewer;
    }

    public void setFocus() {
        if (this.treeViewer == null) {
            return;
        }
        Tree tree = this.treeViewer.getTree();
        if (tree != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new SystemTeamView(parent, 770, this);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)new SystemTeamViewContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SystemTeamViewLabelProvider((Viewer)this.treeViewer));
        this.treeViewer.setInput(this.getInput());
        this.addTreeViewerListeners();
        this.updateTitle();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SystemTeamViewPart.this.fillContextMenu(manager);
                SystemTeamViewPart.this.addMenuListener(manager);
            }
        });
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SystemTeamViewPart.this.scrubOtherContributions(manager);
            }
        });
        this.fillActionBars(this.getViewSite().getActionBars());
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.statusLine = this.getViewSite().getActionBars().getStatusLineManager();
        RSECorePlugin.getTheSystemRegistry().addSystemModelChangeListener((ISystemModelChangeListener)this);
        this.treeViewer.setAutoExpandLevel(2);
        if (this.fMemento != null) {
            this.restoreState(this.fMemento);
        }
        this.fMemento = null;
    }

    private void addMenuListener(IMenuManager menu) {
        Menu m;
        if (!this.menuListenerAdded && menu instanceof MenuManager && (m = ((MenuManager)menu).getMenu()) != null) {
            this.menuListenerAdded = true;
            SystemViewMenuListener ml = new SystemViewMenuListener();
            ml.setShowToolTipText(true, this);
            m.addMenuListener((MenuListener)ml);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
    }

    protected void addTreeViewerListeners() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SystemTeamViewPart.this.handleDoubleClick(event);
            }
        });
        this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SystemTeamViewPart.this.handleKeyReleased(e);
            }
        });
        this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SystemTeamViewPart.this.handleKeyPressed(e);
            }
        });
        this.treeViewer.addSelectionChangedListener(this);
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SystemTeamViewPart.this.handleOpen(event);
            }
        });
    }

    public Shell getShell() {
        return this.getViewSite().getShell();
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ITreeSelection s = (ITreeSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element != null) {
            ISystemViewElementAdapter adapter;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                if (adapter.hasChildren((IAdaptable)element)) {
                    TreePath[] paths = s.getPathsFor(element);
                    if (paths != null && paths.length > 0 && paths[0] != null) {
                        TreePath elementPath = paths[0];
                        if (this.treeViewer.getExpandedState(elementPath)) {
                            this.treeViewer.collapseSelected();
                        } else {
                            this.treeViewer.expandSelected();
                        }
                    }
                } else {
                    adapter.handleDoubleClick(element);
                }
            }
        }
    }

    protected void handleOpen(OpenEvent event) {
    }

    private void handleKeyReleased(KeyEvent event) {
        if (event.keyCode == 0x100000E) {
            this.getRefreshAllToolbarAction(this.getStructuredSelection()).run();
        }
    }

    private void handleKeyPressed(KeyEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (event.character == '-' && event.stateMask == 262144) {
            SystemCollapseAllAction collapseAllAction = this.getCollapseAllAction();
            collapseAllAction.setShell(this.getShell());
            collapseAllAction.run();
        } else if (event.character == '-' && selection.size() > 0) {
            this.treeViewer.collapseSelected();
        } else if (event.character == '+' && selection.size() > 0) {
            this.treeViewer.expandSelected();
        }
    }

    public void selectReveal(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection ssel = (StructuredSelection)selection;
        if (!ssel.isEmpty()) {
            this.treeViewer.setSelection((ISelection)ssel, true);
        }
    }

    private void fillContextMenu(IMenuManager menu) {
        SystemMenuManager ourMenu = new SystemMenuManager(menu);
        IStructuredSelection selection = this.getStructuredSelection();
        Object firstSelection = selection.getFirstElement();
        this.createStandardGroups(menu);
        if (firstSelection instanceof IProject) {
            if (selection.size() == 1) {
                this.fillProjectContextMenu(ourMenu, selection);
            }
        } else {
            ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter(firstSelection, (Viewer)this.treeViewer);
            if (adapter != null) {
                if (firstSelection instanceof SystemTeamViewSubSystemConfigurationNode || firstSelection instanceof ISystemProfile) {
                    this.addActions(ourMenu, selection);
                } else {
                    boolean cfr_ignored_0 = firstSelection instanceof ISystemFilterPool;
                }
            }
        }
        IContributionItem[] items = menu.getItems();
        int idx = 0;
        while (idx < items.length) {
            Object item;
            if (items[idx] instanceof ActionContributionItem && ((ActionContributionItem)items[idx]).getAction() instanceof ISystemAction) {
                item = (ISystemAction)((ActionContributionItem)items[idx]).getAction();
                try {
                    item.setInputs(this.getShell(), (Viewer)this.getViewer(), (ISelection)selection);
                }
                catch (Exception e) {
                    SystemBasePlugin.logError("Error configuring action " + item.getClass().getName(), e);
                    System.err.println("Error configuring action " + item.getClass().getName());
                }
            } else if (items[idx] instanceof SystemSubMenuManager) {
                item = (SystemSubMenuManager)items[idx];
                ((SystemSubMenuManager)((Object)item)).setInputs(this.getShell(), (Viewer)this.getViewer(), (ISelection)selection);
            }
            ++idx;
        }
        PropertyDialogAction pdAction = this.getPropertyDialogAction(selection);
        if (pdAction.isApplicableForSelection()) {
            menu.appendToGroup("group.properties", (IAction)pdAction);
        }
    }

    protected void addActions(SystemMenuManager ourMenu, IStructuredSelection selection) {
        Iterator elements = selection.iterator();
        Hashtable adapters = new Hashtable();
        while (elements.hasNext()) {
            Object element = elements.next();
            ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter(element, (Viewer)this.treeViewer);
            if (adapter == null) continue;
            adapters.put(adapter, element);
        }
        Enumeration uniqueAdapters = adapters.keys();
        Shell shell = this.getShell();
        while (uniqueAdapters.hasMoreElements()) {
            ISystemViewElementAdapter nextAdapter = (ISystemViewElementAdapter)uniqueAdapters.nextElement();
            nextAdapter.addActions(ourMenu, selection, shell, "group.adapters");
        }
        IContributionItem[] items = ourMenu.getMenuManager().getItems();
        int idx = 0;
        while (idx < items.length) {
            Object item;
            if (items[idx] instanceof ActionContributionItem && ((ActionContributionItem)items[idx]).getAction() instanceof ISystemAction) {
                item = (ISystemAction)((ActionContributionItem)items[idx]).getAction();
                try {
                    item.setInputs(this.getShell(), (Viewer)this.treeViewer, (ISelection)selection);
                }
                catch (Exception e) {
                    SystemBasePlugin.logError("Error configuring action " + item.getClass().getName(), e);
                    System.out.println("Error configuring action " + item.getClass().getName());
                }
            } else if (items[idx] instanceof SystemSubMenuManager) {
                item = (SystemSubMenuManager)items[idx];
                ((SystemSubMenuManager)((Object)item)).setInputs(this.getShell(), (Viewer)this.treeViewer, (ISelection)selection);
            }
            ++idx;
        }
    }

    public void createStandardGroups(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new Separator("group.new.noncascade"));
        menu.add((IContributionItem)new Separator("group.workwith"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("group.change"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    private void fillProjectContextMenu(SystemMenuManager menu, IStructuredSelection selection) {
        menu.add("group.build", this.getRefreshAllMenuAction(selection));
        menu.add("group.build", this.getReloadRSEAction(selection));
        menu.add("group.new", this.getNewProfileAction(selection));
    }

    private PropertyDialogAction getPropertyDialogAction(IStructuredSelection selection) {
        if (this.propertyDialogAction == null) {
            this.propertyDialogAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), (ISelectionProvider)this.treeViewer);
        }
        this.propertyDialogAction.selectionChanged(selection);
        return this.propertyDialogAction;
    }

    private SystemTeamReloadAction getReloadRSEAction(IStructuredSelection selection) {
        boolean privateProfileStillExists;
        boolean bl = privateProfileStillExists = RSECorePlugin.getTheSystemProfileManager().getDefaultPrivateSystemProfile() != null;
        if (this.reloadRSEAction == null) {
            this.reloadRSEAction = new SystemTeamReloadAction(this.getShell());
        }
        this.reloadRSEAction.setSelection((ISelection)selection);
        if (privateProfileStillExists) {
            this.reloadRSEAction.setEnabled(false);
        }
        return this.reloadRSEAction;
    }

    private SystemTeamViewRefreshAllAction getRefreshAllMenuAction(IStructuredSelection selection) {
        if (this.menuRefreshAllAction == null) {
            this.menuRefreshAllAction = new SystemTeamViewRefreshAllAction(this.getShell(), this);
        }
        this.menuRefreshAllAction.setSelection((ISelection)selection);
        return this.menuRefreshAllAction;
    }

    private SystemTeamViewRefreshAllAction getRefreshAllToolbarAction(IStructuredSelection selection) {
        if (this.toolBarRefreshAllAction == null) {
            this.toolBarRefreshAllAction = new SystemTeamViewRefreshAllAction(this.getShell(), this);
        }
        this.toolBarRefreshAllAction.setSelection((ISelection)selection);
        return this.toolBarRefreshAllAction;
    }

    private SystemTeamViewProfileAdapter getProfileAdapter(ISystemProfile profile) {
        RSEUIPlugin plugin = RSEUIPlugin.getDefault();
        IAdapterFactory factory = plugin.getSystemViewAdapterFactory();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.internal.ui.view.team.SystemTeamViewProfileAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SystemTeamViewProfileAdapter adapter = (SystemTeamViewProfileAdapter)factory.getAdapter((Object)profile, (Class)clazz);
        return adapter;
    }

    private SystemNewProfileAction getNewProfileAction(IStructuredSelection selection) {
        if (this.newProfileAction == null) {
            this.newProfileAction = new SystemNewProfileAction(this.getShell(), false);
            this.newProfileAction.setViewer((Viewer)this.getViewer());
        }
        this.newProfileAction.setSelection((ISelection)selection);
        return this.newProfileAction;
    }

    protected IAction getDeleteAction(IStructuredSelection selection) {
        if (this.deleteAction == null) {
            this.deleteAction = new SystemCommonDeleteAction(this.getShell(), this);
            this.deleteAction.setViewer((Viewer)this.getViewer());
            this.deleteAction.setHelp("org.eclipse.rse.ui.actndlpr");
            this.deleteAction.setDialogHelp("org.eclipse.rse.ui.ddltprfl");
            this.deleteAction.setPromptLabel(SystemResources.RESID_DELETE_PROFILES_PROMPT);
        }
        this.deleteAction.setSelection((ISelection)selection);
        return this.deleteAction;
    }

    private void scrubOtherContributions(IMenuManager menuMgr) {
        IStructuredSelection selection = this.getStructuredSelection();
        Object firstSelection = selection.getFirstElement();
        if (firstSelection instanceof IProject) {
            boolean privateProfileStillExists = RSECorePlugin.getTheSystemProfileManager().getDefaultPrivateSystemProfile() != null;
            IContributionItem[] items = menuMgr.getItems();
            if (items != null) {
                int idx = 0;
                while (idx < items.length) {
                    IContributionItem item = items[idx];
                    if (item.getId() != null && (!item.getId().equals("team.main") || privateProfileStillExists)) {
                        menuMgr.remove(item);
                    }
                    ++idx;
                }
            }
        }
    }

    public void dispose() {
        RSECorePlugin.getTheSystemRegistry().removeSystemModelChangeListener((ISystemModelChangeListener)this);
        super.dispose();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void updateTitle() {
        this.setPartName(this.getTitle());
        this.setTitleToolTip("");
    }

    protected IAdaptable getInput() {
        if (this.input == null) {
            this.input = new SystemTeamViewInputProvider();
        }
        return this.input;
    }

    public void fillActionBars(IActionBars actionBars) {
        IStructuredSelection selection = this.getStructuredSelection();
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.getPropertyDialogAction(selection));
        SystemTeamViewRefreshAllAction refreshAllAction = this.getRefreshAllToolbarAction(selection);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)refreshAllAction);
        actionBars.getToolBarManager().add((IAction)this.getNewProfileAction(selection));
        actionBars.getToolBarManager().add((IAction)refreshAllAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getDeleteAction(selection));
        SystemCommonRenameAction renameAction = new SystemCommonRenameAction(this.getShell(), this);
        renameAction.setViewer((Viewer)this.getViewer());
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)renameAction);
        SystemCommonSelectAllAction selAllAction = new SystemCommonSelectAllAction(this.getShell(), (ISelectionProvider)this.treeViewer, this.treeViewer);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)selAllAction);
        actionBars.getToolBarManager().add((IContributionItem)new Separator());
        actionBars.getToolBarManager().add((IAction)this.getCollapseAllAction());
        this.statusLine = actionBars.getStatusLineManager();
    }

    protected SystemCollapseAllAction getCollapseAllAction() {
        if (this.collapseAllAction == null) {
            this.collapseAllAction = new SystemCollapseAllAction(this.getShell());
            this.collapseAllAction.setSelectionProvider((ISelectionProvider)this.treeViewer);
            this.collapseAllAction.setViewer((Viewer)this.treeViewer);
            this.collapseAllAction.setImageDescriptor(this.getNavigatorImageDescriptor("elcl16/collapseall.gif"));
            this.collapseAllAction.setHoverImageDescriptor(this.getNavigatorImageDescriptor("elcl16/collapseall.gif"));
        }
        return this.collapseAllAction;
    }

    public void updateActionBars(IStructuredSelection selection) {
        this.getPropertyDialogAction(selection);
        this.getRefreshAllToolbarAction(selection);
        this.getDeleteAction(selection);
    }

    public void systemModelResourceChanged(ISystemModelChangeEvent event) {
        int resourceType = event.getResourceType();
        boolean testMode = false;
        if (event.getEventType() == 128 || resourceType == 1) {
            this.getTreeViewer().refresh();
            this.treeViewer.updatePropertySheet();
            if (testMode && resourceType == 1) {
                System.out.println("Profile change event of type: " + event.getEventType());
            }
        } else if (resourceType == 32) {
            ISystemFilter filter;
            ISystemFilterPool pool;
            if (testMode) {
                System.out.println("Filter change event of type: " + event.getEventType());
            }
            if ((pool = (filter = (ISystemFilter)event.getResource()).getParentFilterPool()) == null) {
                return;
            }
            if (this.isModelObjectExpanded(pool)) {
                this.treeViewer.refresh(pool);
            }
        } else if (resourceType == 8) {
            ISystemFilterPool pool;
            ISystemProfile profile;
            TreeItem filterCategoryItem;
            if (testMode) {
                System.out.println("Filter Pool change event of type: " + event.getEventType());
            }
            if ((filterCategoryItem = this.getCategoryNodeTreeItem(profile = ((ISubSystemConfiguration)(pool = (ISystemFilterPool)event.getResource()).getProvider()).getSystemProfile(pool), "pools")) != null && filterCategoryItem.getExpanded()) {
                this.treeViewer.refresh(filterCategoryItem.getData());
            }
        } else if (resourceType == 2) {
            IHost conn;
            ISystemProfile profile;
            TreeItem connCategoryItem;
            if (testMode) {
                System.out.println("Connection change event of type: " + event.getEventType());
            }
            if ((connCategoryItem = this.getCategoryNodeTreeItem(profile = (conn = (IHost)event.getResource()).getSystemProfile(), "conns")) != null && connCategoryItem.getExpanded()) {
                this.treeViewer.refresh(connCategoryItem.getData());
            }
        } else if (resourceType == 4 && testMode) {
            System.out.println("SubSystem change event of type: " + event.getEventType());
        }
    }

    private boolean isModelObjectExpanded(Object object) {
        TreeItem item = this.treeViewer.findTreeItem(object);
        return item != null && item.getExpanded();
    }

    private TreeItem getCategoryNodeTreeItem(ISystemProfile profile, String mementoKey) {
        TreeItem item = this.treeViewer.findTreeItem(profile);
        if (item == null || !item.getExpanded()) {
            return null;
        }
        TreeItem[] childItems = item.getItems();
        item = null;
        if (childItems != null) {
            boolean found = false;
            int idx = 0;
            while (!found && idx < childItems.length) {
                SystemTeamViewCategoryNode node;
                if (childItems[idx].getData() instanceof SystemTeamViewCategoryNode && (node = (SystemTeamViewCategoryNode)childItems[idx].getData()) != null && node.getMementoHandle().equals(mementoKey)) {
                    found = true;
                    item = childItems[idx];
                }
                ++idx;
            }
        }
        return item;
    }

    public boolean showDelete() {
        return true;
    }

    public boolean canDelete() {
        boolean ok = false;
        IStructuredSelection selection = this.getStructuredSelection();
        if (!selection.isEmpty()) {
            ok = true;
            ISystemProfileManager manager = RSECorePlugin.getTheSystemRegistry().getSystemProfileManager();
            ISystemProfile defaultProfile = manager.getDefaultPrivateSystemProfile();
            Iterator z = selection.iterator();
            while (z.hasNext() && ok) {
                Object object = z.next();
                if (object instanceof ISystemProfile) {
                    ISystemProfile profile = (ISystemProfile)object;
                    if (profile != defaultProfile) continue;
                    ok = false;
                    continue;
                }
                ok = false;
            }
        }
        return ok;
    }

    public boolean doDelete(IProgressMonitor monitor) {
        boolean ok = true;
        IStructuredSelection selection = this.getStructuredSelection();
        Iterator elements = selection.iterator();
        while (ok && elements.hasNext()) {
            ISystemProfile profile = (ISystemProfile)elements.next();
            try {
                SystemTeamViewProfileAdapter profileAdapter = this.getProfileAdapter(profile);
                ok = profileAdapter.doDelete(this.getShell(), profile, monitor);
            }
            catch (Exception exc) {
                String msg = "Exception deleting profile " + profile.getName();
                SystemBasePlugin.logError(msg, exc);
                SystemMessageDialog.displayExceptionMessage(this.getShell(), exc);
                ok = false;
            }
        }
        return ok;
    }

    public boolean showRename() {
        return true;
    }

    public boolean canRename() {
        boolean ok = true;
        IStructuredSelection selection = this.getStructuredSelection();
        Iterator elements = selection.iterator();
        while (ok && elements.hasNext()) {
            Object currObj = elements.next();
            if (currObj instanceof ISystemProfile) continue;
            ok = false;
        }
        return ok;
    }

    public boolean doRename(String[] newNames) {
        boolean ok = true;
        IStructuredSelection selection = this.getStructuredSelection();
        Iterator elements = selection.iterator();
        int idx = 0;
        while (ok && elements.hasNext()) {
            ISystemProfile profile = (ISystemProfile)elements.next();
            try {
                SystemTeamViewProfileAdapter profileAdapter = this.getProfileAdapter(profile);
                profileAdapter.doRename(this.getShell(), profile, newNames[idx++], null);
            }
            catch (SystemMessageException exc) {
                SystemMessageDialog.displayMessage(this.getShell(), exc);
                ok = false;
            }
            catch (Exception exc) {
                String msg = "Exception renaming profile ";
                SystemBasePlugin.logError(msg, exc);
                SystemMessageDialog.displayExceptionMessage(this.getShell(), exc);
                ok = false;
            }
        }
        return ok;
    }

    protected ImageDescriptor getNavigatorImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            URL installURL = bundle.getEntry("");
            URL url = new URL(installURL, String.valueOf(iconPath) + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void saveState(IMemento memento) {
        ScrollBar bar;
        Object[] elements;
        if (this.treeViewer == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        memento.putString(TAG_RELEASE, "2.0.0");
        Tree tree = this.treeViewer.getTree();
        Object[] expandedElements = this.treeViewer.getVisibleExpandedElements();
        if (expandedElements != null && expandedElements.length > 0) {
            IMemento expandedMem = memento.createChild(TAG_EXPANDED);
            int i = 0;
            while (i < expandedElements.length) {
                Object o = expandedElements[i];
                String mementoHandle = this.getMementoHandle(o);
                if (mementoHandle != null) {
                    IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                    elementMem.putString(TAG_PATH, this.getMementoHandle(o));
                }
                ++i;
            }
        }
        if ((elements = ((IStructuredSelection)this.treeViewer.getSelection()).toArray()) != null && elements.length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            int i = 0;
            while (i < elements.length) {
                Object o = elements[i];
                String mementoHandle = this.getMementoHandle(o);
                if (mementoHandle != null) {
                    IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                    elementMem.putString(TAG_PATH, this.getMementoHandle(o));
                }
                ++i;
            }
        }
        int position = (bar = tree.getVerticalBar()) != null ? bar.getSelection() : 0;
        memento.putString(TAG_VERTICAL_POSITION, String.valueOf(position));
        bar = tree.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(position));
    }

    protected String getMementoHandle(Object o) {
        String mementoKey = this.internalGetMementoHandleKey(o);
        if (mementoKey == null) {
            return null;
        }
        StringBuffer idBuffer = new StringBuffer(mementoKey);
        Object[] elementNodes = this.treeViewer.getElementNodes(o);
        if (elementNodes != null) {
            int idx = elementNodes.length - 1;
            while (idx >= 0) {
                o = elementNodes[idx];
                idBuffer.append(MEMENTO_DELIM + this.internalGetMementoHandle(o));
                --idx;
            }
        }
        return idBuffer.toString();
    }

    protected String internalGetMementoHandleKey(Object o) {
        ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter(o, (Viewer)this.treeViewer);
        String handle = null;
        if (adapter != null) {
            handle = adapter.getMementoHandleKey(o);
        } else if (o instanceof IResource) {
            handle = o instanceof IProject ? "Project" : (o instanceof IFolder ? "Folder" : "File");
        } else if (o instanceof ISystemProfile) {
            handle = "Profile";
        } else {
            boolean cfr_ignored_0 = o instanceof SystemTeamViewCategoryNode;
        }
        return handle;
    }

    protected String internalGetMementoHandle(Object o) {
        ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter(o, (Viewer)this.treeViewer);
        String handle = null;
        if (adapter != null) {
            handle = adapter.getMementoHandle(o);
        } else if (o instanceof IResource) {
            handle = ((IResource)o).getName();
        } else if (o instanceof ISystemProfile) {
            handle = ((ISystemProfile)o).getName();
        } else if (o instanceof SystemTeamViewCategoryNode) {
            handle = ((SystemTeamViewCategoryNode)o).getMementoHandle();
        }
        return handle;
    }

    void restoreState(IMemento memento) {
        RestoreStateRunnable restoreAction = new RestoreStateRunnable(memento);
        Display.getDefault().syncExec((Runnable)restoreAction);
    }

    protected Object getObjectFromMemento(String memento) {
        if (memento == null) {
            return null;
        }
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISystemProfile profile = null;
        IProject project = null;
        SystemTeamViewCategoryNode category = null;
        String elementType = "";
        Vector v = SystemViewPart.tokenize(memento, MEMENTO_DELIM);
        int idx = 0;
        while (idx < v.size()) {
            String token = (String)v.elementAt(idx);
            switch (idx) {
                case 0: {
                    elementType = token;
                    break;
                }
                case 1: {
                    project = SystemResourceManager.getRemoteSystemsProject((boolean)false);
                    break;
                }
                case 2: {
                    profile = sr.getSystemProfile(token);
                    break;
                }
                case 3: {
                    if (profile == null) break;
                    IAdaptable iAdaptable = (IAdaptable)profile;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    SystemTeamViewProfileAdapter profileAdapter = (SystemTeamViewProfileAdapter)iAdaptable.getAdapter((Class)clazz);
                    category = profileAdapter.restoreCategory(profile, token);
                }
            }
            ++idx;
        }
        if (elementType.equals("Project")) {
            return project;
        }
        if (elementType.equals("Profile")) {
            return profile;
        }
        if (elementType.equals("Category")) {
            return category;
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateActionBars(sel);
        Object firstSelection = sel.getFirstElement();
        if (firstSelection == null) {
            return;
        }
        ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter(firstSelection);
        if (adapter != null) {
            this.setMessage(adapter.getStatusLineText(firstSelection));
        } else {
            this.setMessage(this.internalGetMementoHandle(firstSelection));
        }
        if (this.newProfileAction != null) {
            this.newProfileAction.refreshEnablement();
        }
    }

    public void clearErrorMessage() {
        this.errorMessage = null;
        this.sysErrorMessage = null;
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(this.errorMessage);
        }
    }

    public void clearMessage() {
        this.message = null;
        if (this.statusLine != null) {
            this.statusLine.setMessage(this.message);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(message);
        }
    }

    public SystemMessage getSystemErrorMessage() {
        return this.sysErrorMessage;
    }

    public void setErrorMessage(SystemMessage message) {
        this.sysErrorMessage = message;
        this.setErrorMessage(message.getLevelOneText());
    }

    public void setErrorMessage(Throwable exc) {
        this.setErrorMessage(exc.getMessage());
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.statusLine != null) {
            this.statusLine.setMessage(message);
        }
    }

    public void setMessage(SystemMessage message) {
        this.setMessage(message.getLevelOneText());
    }

    public class RestoreStateRunnable
    implements Runnable {
        private IMemento _memento;

        public RestoreStateRunnable(IMemento memento) {
            this._memento = memento;
        }

        public void run() {
            Tree tree;
            ScrollBar bar;
            Object element;
            int i;
            IMemento[] elementMem;
            IMemento memento = this._memento;
            IMemento childMem = null;
            childMem = memento.getChild(SystemTeamViewPart.TAG_EXPANDED);
            if (childMem != null) {
                ArrayList<Object> elements = new ArrayList<Object>();
                elementMem = childMem.getChildren(SystemTeamViewPart.TAG_ELEMENT);
                i = 0;
                while (i < elementMem.length) {
                    element = SystemTeamViewPart.this.getObjectFromMemento(elementMem[i].getString(SystemTeamViewPart.TAG_PATH));
                    if (element != null) {
                        elements.add(element);
                    }
                    ++i;
                }
                SystemTeamViewPart.this.treeViewer.setExpandedElements(elements.toArray());
            }
            if ((childMem = memento.getChild(SystemTeamViewPart.TAG_SELECTION)) != null) {
                ArrayList<Object> list = new ArrayList<Object>();
                elementMem = childMem.getChildren(SystemTeamViewPart.TAG_ELEMENT);
                i = 0;
                while (i < elementMem.length) {
                    element = SystemTeamViewPart.this.getObjectFromMemento(elementMem[i].getString(SystemTeamViewPart.TAG_PATH));
                    if (element != null) {
                        list.add(element);
                    }
                    ++i;
                }
                SystemTeamViewPart.this.treeViewer.setSelection((ISelection)new StructuredSelection(list));
            }
            if ((bar = (tree = SystemTeamViewPart.this.treeViewer.getTree()).getVerticalBar()) != null) {
                try {
                    String posStr = memento.getString(SystemTeamViewPart.TAG_VERTICAL_POSITION);
                    if (posStr != null) {
                        int position = new Integer(posStr);
                        bar.setSelection(position);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((bar = tree.getHorizontalBar()) != null) {
                try {
                    String posStr = memento.getString(SystemTeamViewPart.TAG_HORIZONTAL_POSITION);
                    if (posStr != null) {
                        int position = new Integer(posStr);
                        bar.setSelection(position);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }
}

