/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstructorExpression
extends AbstractExpression {
    private String className;
    private AbstractExpression constructorItems;
    private boolean hasLeftParenthesis;
    private boolean hasRightParenthesis;
    private boolean hasSpaceAfterConstructorName;
    private boolean hasSpaceAfterNew;

    ConstructorExpression(AbstractExpression parent) {
        super(parent, "NEW");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getConstructorItems().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getConstructorItems());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression("NEW"));
        if (this.hasSpaceAfterNew) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.className.length() > 0) {
            children.add(this.buildStringExpression(this.className));
        }
        if (this.hasLeftParenthesis) {
            children.add(this.buildStringExpression('('));
        } else if (this.hasSpaceAfterConstructorName) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasConstructorItems()) {
            children.add(this.constructorItems);
        }
        if (this.hasRightParenthesis) {
            children.add(this.buildStringExpression(')'));
        }
    }

    public CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getConstructorItems());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    public String getClassName() {
        return this.className;
    }

    public Expression getConstructorItems() {
        if (this.constructorItems == null) {
            this.constructorItems = this.buildNullExpression();
        }
        return this.constructorItems;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return ConstructorExpression.queryBNF("constructor_expression");
    }

    public boolean hasConstructorItems() {
        return this.constructorItems != null && !this.constructorItems.isNull();
    }

    public boolean hasLeftParenthesis() {
        return this.hasLeftParenthesis;
    }

    public boolean hasRightParenthesis() {
        return this.hasRightParenthesis;
    }

    public boolean hasSpaceAfterNew() {
        return this.hasSpaceAfterNew;
    }

    @Override
    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return wordParser.character() == ')' || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward("NEW");
        this.hasSpaceAfterNew = wordParser.skipLeadingWhitespace() > 0;
        String className = wordParser.word();
        if (tolerant && ConstructorExpression.isIdentifier(className)) {
            this.className = "";
            this.constructorItems = this.buildNullExpression();
            return;
        }
        this.className = className;
        wordParser.moveForward(className);
        int count = wordParser.skipLeadingWhitespace();
        this.hasLeftParenthesis = wordParser.startsWith('(');
        if (this.hasLeftParenthesis) {
            wordParser.moveForward(1);
            count = wordParser.skipLeadingWhitespace();
        } else {
            this.hasSpaceAfterConstructorName = count > 0;
        }
        this.constructorItems = this.parse(wordParser, (JPQLQueryBNF)ConstructorExpression.queryBNF("constructor_item"), tolerant);
        if (this.hasConstructorItems()) {
            count = wordParser.skipLeadingWhitespace();
        }
        boolean bl = this.hasRightParenthesis = wordParser.character() == ')';
        if (this.hasRightParenthesis) {
            wordParser.moveForward(1);
        } else {
            wordParser.moveBackward(count);
        }
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append(this.getText());
        if (this.hasSpaceAfterNew) {
            writer.append(' ');
        }
        writer.append(this.className);
        if (this.hasLeftParenthesis) {
            writer.append('(');
        } else if (this.hasSpaceAfterConstructorName) {
            writer.append(' ');
        }
        if (this.constructorItems != null) {
            this.constructorItems.toParsedText(writer, includeVirtual);
        }
        if (this.hasRightParenthesis) {
            writer.append(')');
        }
    }
}

