/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.DefaultStringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpression
extends StringExpression
implements Expression {
    private String actualText;
    private List<Expression> children;
    private List<StringExpression> orderedChildren;
    private AbstractExpression parent;
    private String parsedText;
    private String text;
    public static final char COMMA = ',';
    public static final char DOT = '.';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char LEFT_CURLY_BRACKET = '{';
    public static final char LEFT_PARENTHESIS = '(';
    public static final char NOT_DEFINED = '\u0000';
    private static final ExpressionRegistry registry = new ExpressionRegistry();
    public static final char RIGHT_CURLY_BRACKET = '}';
    public static final char RIGHT_PARENTHESIS = ')';
    public static final char SINGLE_QUOTE = '\'';
    public static final char SPACE = ' ';
    public static final char UNDERSCORE = '_';

    AbstractExpression(AbstractExpression parent) {
        this(parent, "");
    }

    AbstractExpression(AbstractExpression parent, String text) {
        this.text = text;
        this.parent = parent;
    }

    static ExpressionFactory expressionFactory(String expressionFactoryId) {
        return registry.expressionFactory(expressionFactoryId);
    }

    static ExpressionFactory expressionFactoryForIdentifier(String identifier) {
        return registry.expressionFactoryForIdentifier(identifier);
    }

    public static IdentifierRole identifierRole(String identifier) {
        return registry.identifierRole(identifier);
    }

    public static Collection<String> identifiers() {
        return registry.identifiers();
    }

    public static IJPAVersion identifierVersion(String identifier) {
        return registry.identifierVersion(identifier);
    }

    public static boolean isIdentifier(String identifier) {
        return registry.isIdentifier(identifier);
    }

    public static <T extends JPQLQueryBNF> T queryBNF(String queryBNFID) {
        return registry.queryBNF(queryBNFID);
    }

    void addChildrenTo(Collection<Expression> children) {
    }

    void addOrderedChildrenTo(List<StringExpression> children) {
    }

    final AbstractExpression buildExpressionFromFallingBack(WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        ExpressionFactory factory = this.findFallBackExpressionFactory(queryBNF);
        if (factory == null) {
            return null;
        }
        if (tolerant && factory.getId() == "pre-literal" && this.shouldSkipLiteral(expression)) {
            return null;
        }
        return factory.buildExpression(this, wordParser, word, queryBNF, expression, tolerant);
    }

    final AbstractExpression buildNullExpression() {
        return new NullExpression(this);
    }

    final StringExpression buildStringExpression(char value) {
        return this.buildStringExpression(String.valueOf(value));
    }

    final StringExpression buildStringExpression(String value) {
        return new DefaultStringExpression(this, value);
    }

    final AbstractExpression buildUnknownExpression(String text) {
        return new UnknownExpression(this, text);
    }

    @Override
    public final ListIterator<Expression> children() {
        if (this.children == null) {
            this.children = new ArrayList<Expression>();
            this.addChildrenTo(this.children);
        }
        return this.children.listIterator();
    }

    private ExpressionFactory findFallBackExpressionFactory(JPQLQueryBNF queryBNF) {
        String fallBackBNFId = queryBNF.getFallbackBNFId();
        if (fallBackBNFId == null) {
            return null;
        }
        Object fallBackQueryBNF = AbstractExpression.queryBNF(fallBackBNFId);
        if (fallBackQueryBNF != queryBNF && ((JPQLQueryBNF)fallBackQueryBNF).getFallbackBNFId() != null) {
            return this.findFallBackExpressionFactory((JPQLQueryBNF)fallBackQueryBNF);
        }
        return AbstractExpression.expressionFactory(((JPQLQueryBNF)fallBackQueryBNF).getFallbackExpressionFactoryId());
    }

    public JPQLQueryBNF findQueryBNF(AbstractExpression expression) {
        return this.getQueryBNF();
    }

    @Override
    public final Expression[] getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Expression>();
            this.addChildrenTo(this.children);
        }
        return this.children.toArray(new Expression[this.children.size()]);
    }

    IJPAVersion getJPAVersion() {
        return this.getParent().getJPAVersion();
    }

    @Override
    public final AbstractExpression getParent() {
        return this.parent;
    }

    public abstract JPQLQueryBNF getQueryBNF();

    @Override
    public final JPQLExpression getRoot() {
        return this.parent == null ? (JPQLExpression)this : this.parent.getRoot();
    }

    String getText() {
        return this.text;
    }

    boolean handleAggregate(JPQLQueryBNF queryBNF) {
        return queryBNF.handleAggregate();
    }

    final Iterable<String> identifiers(String queryBNFId) {
        return registry.identifiers(queryBNFId);
    }

    @Override
    public boolean isAncestor(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        return this.isAncestor(expression.getParent());
    }

    boolean isNull() {
        return false;
    }

    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("FROM") || word.equalsIgnoreCase("WHERE") || word.equalsIgnoreCase("HAVING") || wordParser.startsWithIdentifier("GROUP BY") || wordParser.startsWithIdentifier("ORDER BY");
    }

    boolean isTolerant() {
        return this.getRoot().isTolerant();
    }

    boolean isUnknown() {
        return false;
    }

    private boolean isValidExpressionFactory(ExpressionFactory factory) {
        return factory != null && factory.getVersion().isOlderThanOrEqual(this.getJPAVersion());
    }

    public boolean isVirtual() {
        return false;
    }

    @Override
    public final ListIterator<StringExpression> orderedChildren() {
        if (this.orderedChildren == null) {
            this.orderedChildren = new ArrayList<StringExpression>();
            this.addOrderedChildrenTo(this.orderedChildren);
        }
        return this.orderedChildren.listIterator();
    }

    abstract void parse(WordParser var1, boolean var2);

    AbstractExpression parse(WordParser wordParser, JPQLQueryBNF queryBNF, boolean tolerant) {
        if (wordParser.isTail()) {
            return null;
        }
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>();
        ArrayList<Boolean> separatedByCommas = new ArrayList<Boolean>();
        ArrayList<Boolean> separatedBySpaces = new ArrayList<Boolean>();
        AbstractExpression expression = null;
        AbstractExpression child = null;
        int length = wordParser.position();
        boolean beginning = !tolerant;
        char character = wordParser.character();
        int count = 0;
        while (!wordParser.isTail()) {
            ExpressionFactory factory;
            String word;
            child = null;
            if (wordParser.startsWith('(')) {
                expression = new SubExpression(this, queryBNF.getId());
                ((AbstractExpression)expression).parse(wordParser, tolerant);
                beginning = false;
                count = wordParser.skipLeadingWhitespace();
                character = wordParser.character();
                children.add(expression);
                separatedByCommas.add(Boolean.FALSE);
                separatedBySpaces.add(count > 0);
            }
            if ((word = wordParser.potentialWord()).length() > 0) {
                if (!tolerant && !beginning && this.isParsingComplete(wordParser, word, expression) || tolerant && this.isParsingComplete(wordParser, word, expression)) break;
                if (this.shouldParseWithFactoryFirst() && (factory = queryBNF.expressionFactory(word)) != null && (child = this.parse(wordParser, word, factory, queryBNF, expression, tolerant)) != null) {
                    expression = this.updateParsingInfo(expression, child, children, separatedByCommas, separatedBySpaces);
                    count = wordParser.skipLeadingWhitespace();
                    character = wordParser.character();
                    beginning = false;
                }
                if (child == null && (child = this.buildExpressionFromFallingBack(wordParser, word, queryBNF, expression, tolerant)) != null) {
                    expression = this.updateParsingInfo(expression, child, children, separatedByCommas, separatedBySpaces);
                    count = wordParser.skipLeadingWhitespace();
                    character = wordParser.character();
                    beginning = false;
                }
            }
            if (child != null && expression != null && expression != child) {
                count = 0;
            }
            if (tolerant && child == null && wordParser.position() == length && character != ',' && word.length() > 0 && AbstractExpression.identifierRole(word) != IdentifierRole.AGGREGATE && (factory = AbstractExpression.expressionFactoryForIdentifier(word)) != null && this.isValidExpressionFactory(factory) && (child = this.parse(wordParser, word, factory, queryBNF, expression, tolerant)) != null) {
                child = new BadExpression(this, child);
                expression = this.updateParsingInfo(expression, child, children, separatedByCommas, separatedBySpaces);
                character = wordParser.character();
                beginning = false;
            }
            if (child == null && character != ',') break;
            if (expression == null || child != null) {
                children.add(child);
                separatedByCommas.add(Boolean.FALSE);
                separatedBySpaces.add(count > 1);
            }
            if (wordParser.isTail()) break;
            if (character == ',') {
                boolean stopParsing;
                if (!queryBNF.handleCollection()) break;
                int collectionIndex = separatedByCommas.size() - 1;
                wordParser.moveForward(1);
                separatedByCommas.set(collectionIndex, Boolean.TRUE);
                count = wordParser.skipLeadingWhitespace();
                separatedBySpaces.set(collectionIndex, count > 0);
                character = wordParser.character();
                expression = null;
                if (character == '(') continue;
                word = wordParser.potentialWord();
                boolean bl = stopParsing = tolerant && (word.length() == 0 || this.isParsingComplete(wordParser, word, null));
                if (wordParser.isTail() || stopParsing) {
                    child = null;
                    count = 0;
                    children.add(child);
                    separatedByCommas.add(Boolean.FALSE);
                    separatedBySpaces.add(Boolean.FALSE);
                    if (stopParsing) break;
                }
                if (character != ')') continue;
                break;
            }
            if (character == ')' || !this.handleAggregate(queryBNF)) break;
            separatedBySpaces.set(separatedBySpaces.size() - 1, count > 0);
        }
        if (count > 0) {
            if (!separatedByCommas.isEmpty() && ((Boolean)separatedByCommas.get(separatedByCommas.size() - 1)).booleanValue()) {
                separatedBySpaces.set(separatedBySpaces.size() - 1, Boolean.TRUE);
            } else {
                wordParser.moveBackward(count);
                if (!separatedBySpaces.isEmpty()) {
                    separatedBySpaces.set(separatedBySpaces.size() - 1, Boolean.FALSE);
                }
            }
        }
        expression = children.size() == 1 && separatedByCommas.get(0) == Boolean.FALSE && separatedBySpaces.get(0) == Boolean.FALSE ? (AbstractExpression)children.get(0) : (!children.isEmpty() ? new CollectionExpression(this, children, separatedByCommas, separatedBySpaces) : null);
        return expression;
    }

    private AbstractExpression parse(WordParser wordParser, String word, ExpressionFactory factory, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        return factory.buildExpression(this, wordParser, word, queryBNF, expression, tolerant);
    }

    AbstractExpression parseSingleExpression(WordParser wordParser, JPQLQueryBNF queryBNF, boolean tolerant) {
        String word = wordParser.potentialWord();
        ExpressionFactory factory = queryBNF.expressionFactory(word);
        return factory == null ? null : this.parse(wordParser, word, factory, queryBNF, null, tolerant);
    }

    @Override
    final void populatePosition(QueryPosition queryPosition, int position) {
        queryPosition.addPosition(this, position);
        if (position != 0) {
            ListIterator<StringExpression> iter = this.orderedChildren();
            while (iter.hasNext()) {
                StringExpression stringExpression = iter.next();
                String expressionText = stringExpression.toParsedText();
                if (position <= expressionText.length()) {
                    stringExpression.populatePosition(queryPosition, position);
                    return;
                }
                position -= expressionText.length();
            }
            throw new IllegalStateException("The traversal to find the ExpressionFactories didn't work correctly, it shouldn't hit this.");
        }
        queryPosition.setExpression(this);
    }

    final void readdLeadingSpaces(StringBuilder text, int count) {
        int index = count;
        while (--index >= 0) {
            text.insert(0, ' ');
        }
    }

    final void rebuildActualText() {
        if (this.actualText != null) {
            this.toActualText();
        }
    }

    final void rebuildParsedText() {
        if (this.parsedText != null) {
            this.toParsedText();
        }
    }

    final void setParent(AbstractExpression parent) {
        this.parent = parent;
    }

    final void setText(String text) {
        this.text = text;
    }

    boolean shouldParseWithFactoryFirst() {
        return true;
    }

    boolean shouldSkipLiteral(AbstractExpression expression) {
        return expression != null;
    }

    @Override
    public String toActualText() {
        if (this.actualText == null) {
            StringBuilder writer = new StringBuilder();
            this.toParsedText(writer, true);
            this.actualText = writer.toString();
        }
        return this.actualText;
    }

    @Override
    public String toParsedText() {
        if (this.parsedText == null) {
            StringBuilder writer = new StringBuilder();
            this.toParsedText(writer, false);
            this.parsedText = writer.toString();
        }
        return this.parsedText;
    }

    abstract void toParsedText(StringBuilder var1, boolean var2);

    public final String toString() {
        return this.toParsedText();
    }

    private AbstractExpression updateParsingInfo(AbstractExpression expression, AbstractExpression child, List<AbstractExpression> children, List<Boolean> separatedByCommas, List<Boolean> separatedBySpaces) {
        if (expression != null && child.isAncestor(expression)) {
            int expressionLocation = children.indexOf(expression);
            if (expressionLocation > -1) {
                separatedByCommas.remove(expressionLocation);
                separatedBySpaces.remove(expressionLocation);
            }
            children.remove(expression);
        }
        return child;
    }
}

