/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import com.ibm.icu.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnNormalizeUnicode
extends Function {
    private static Collection _expected_args;
    private static W3CNormalizer normalizer;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.function.FnNormalizeUnicode");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        _expected_args = null;
        normalizer = null;
    }

    public FnNormalizeUnicode() {
        super(new QName("normalize-unicode"), 1, 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnNormalizeUnicode.normalize_unicode(args, ec.getDynamicContext());
    }

    public static ResultSequence normalize_unicode(Collection args, DynamicContext d_context) throws DynamicError {
        if (!($assertionsDisabled || args.size() >= 1 && args.size() <= 2)) {
            throw new AssertionError();
        }
        Collection cargs = Function.convert_arguments(args, FnNormalizeUnicode.expected_args());
        Iterator cargsIterator = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)cargsIterator.next();
        String normalizationType = "NFC";
        if (cargsIterator.hasNext()) {
            ResultSequence arg2 = (ResultSequence)cargsIterator.next();
            normalizationType = arg2.empty() ? "" : ((XSString)arg2.first()).value().trim().toUpperCase();
        }
        String argument = "";
        if (!arg1.empty()) {
            argument = ((XSString)arg1.first()).value();
        }
        String normalized = normalizationType.equals("") ? argument : FnNormalizeUnicode.getNormalizer().normalize(argument, normalizationType);
        return new XSString(normalized);
    }

    private static W3CNormalizer getNormalizer() {
        ClassLoader classLoader;
        if (normalizer == null && (normalizer = FnNormalizeUnicode.createICUNormalizer(classLoader = Thread.currentThread().getContextClassLoader())) == null) {
            normalizer = new FailingNormalizer();
        }
        return normalizer;
    }

    private static W3CNormalizer createICUNormalizer(ClassLoader classLoader) {
        try {
            if (classLoader.loadClass("com.ibm.icu.text.Normalizer") != null) {
                return new ICUNormalizer();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return null;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSString(), 3));
            _expected_args.add(new SeqType(new XSString(), 0));
        }
        return _expected_args;
    }

    static class FailingNormalizer
    implements W3CNormalizer {
        FailingNormalizer() {
        }

        public String normalize(String argument, String normalizationForm) throws DynamicError {
            throw DynamicError.unsupported_normalization_form("Can't normalize to form " + normalizationForm + ": No ICU Library or Java 6 found. 'normalize-unicode' requires either 'com.ibm.icu.text.Normalizer' or 'java.text.Normalizer' on the classpath");
        }
    }

    static class ICUNormalizer
    implements W3CNormalizer {
        private Map modeMap = new HashMap();

        ICUNormalizer() {
            this.modeMap.put("NFC", Normalizer.NFC);
            this.modeMap.put("NFD", Normalizer.NFD);
            this.modeMap.put("NFKC", Normalizer.NFKC);
            this.modeMap.put("NFKD", Normalizer.NFKD);
        }

        public String normalize(String argument, String normalizationForm) throws DynamicError {
            Normalizer.Mode mode = (Normalizer.Mode)this.modeMap.get(normalizationForm);
            if (mode != null) {
                return Normalizer.normalize((String)argument, (Normalizer.Mode)mode);
            }
            throw DynamicError.unsupported_normalization_form(normalizationForm);
        }
    }

    public static interface W3CNormalizer {
        public String normalize(String var1, String var2) throws DynamicError;
    }
}

