/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value.swing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.model.listener.awt.AWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentAdapter
implements Document,
Serializable {
    protected final Document delegate;
    protected final CombinedListener delegateListener;
    protected final WritablePropertyValueModel<String> stringHolder;
    protected transient PropertyChangeListener stringListener;
    protected final EventListenerList listenerList = new EventListenerList();
    private static final long serialVersionUID = 1L;

    public DocumentAdapter(WritablePropertyValueModel<String> stringHolder, Document delegate) {
        if (stringHolder == null || delegate == null) {
            throw new NullPointerException();
        }
        this.stringHolder = stringHolder;
        this.delegate = delegate;
        this.stringListener = this.buildStringListener();
        this.delegateListener = this.buildDelegateListener();
    }

    public DocumentAdapter(WritablePropertyValueModel<String> stringHolder) {
        this(stringHolder, new PlainDocument());
    }

    protected PropertyChangeListener buildStringListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildStringListener_());
    }

    protected PropertyChangeListener buildStringListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                DocumentAdapter.this.stringChanged(event);
            }

            public String toString() {
                return "string listener";
            }
        };
    }

    protected CombinedListener buildDelegateListener() {
        return new InternalListener();
    }

    @Override
    public int getLength() {
        return this.delegate.getLength();
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        if (this.listenerList.getListenerCount(DocumentListener.class) == 0) {
            this.delegate.addDocumentListener(this.delegateListener);
            this.engageStringHolder();
        }
        this.listenerList.add(DocumentListener.class, listener);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.listenerList.remove(DocumentListener.class, listener);
        if (this.listenerList.getListenerCount(DocumentListener.class) == 0) {
            this.disengageStringHolder();
            this.delegate.removeDocumentListener(this.delegateListener);
        }
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        if (this.listenerList.getListenerCount(UndoableEditListener.class) == 0) {
            this.delegate.addUndoableEditListener(this.delegateListener);
        }
        this.listenerList.add(UndoableEditListener.class, listener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.remove(UndoableEditListener.class, listener);
        if (this.listenerList.getListenerCount(UndoableEditListener.class) == 0) {
            this.delegate.removeUndoableEditListener(this.delegateListener);
        }
    }

    @Override
    public Object getProperty(Object key) {
        return this.delegate.getProperty(key);
    }

    @Override
    public void putProperty(Object key, Object value) {
        this.delegate.putProperty(key, value);
    }

    @Override
    public void remove(int offset, int len) throws BadLocationException {
        this.delegate.remove(offset, len);
        this.stringHolder.setValue(this.delegate.getText(0, this.delegate.getLength()));
    }

    @Override
    public void insertString(int offset, String insertedString, AttributeSet a) throws BadLocationException {
        this.delegate.insertString(offset, insertedString, a);
        this.stringHolder.setValue(this.delegate.getText(0, this.delegate.getLength()));
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        return this.delegate.getText(offset, length);
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        this.delegate.getText(offset, length, txt);
    }

    @Override
    public Position getStartPosition() {
        return this.delegate.getStartPosition();
    }

    @Override
    public Position getEndPosition() {
        return this.delegate.getEndPosition();
    }

    @Override
    public Position createPosition(int offs) throws BadLocationException {
        return this.delegate.createPosition(offs);
    }

    @Override
    public Element[] getRootElements() {
        return this.delegate.getRootElements();
    }

    @Override
    public Element getDefaultRootElement() {
        return this.delegate.getDefaultRootElement();
    }

    @Override
    public void render(Runnable r) {
        this.delegate.render(r);
    }

    public DocumentListener[] documentListeners() {
        return (DocumentListener[])this.listenerList.getListeners(DocumentListener.class);
    }

    public UndoableEditListener[] undoableEditListeners() {
        return (UndoableEditListener[])this.listenerList.getListeners(UndoableEditListener.class);
    }

    protected void stringChanged(PropertyChangeEvent event) {
        this.synchronizeDelegate((String)event.getNewValue());
    }

    protected void synchronizeDelegate(String s) {
        try {
            int len = this.delegate.getLength();
            if (!this.delegate.getText(0, len).equals(s)) {
                this.delegate.remove(0, len);
                this.delegate.insertString(0, s, null);
            }
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    protected void engageStringHolder() {
        this.stringHolder.addPropertyChangeListener("value", this.stringListener);
        this.synchronizeDelegate((String)this.stringHolder.getValue());
    }

    protected void disengageStringHolder() {
        this.stringHolder.removePropertyChangeListener("value", this.stringListener);
    }

    protected void delegateChangedUpdate(DocumentEvent event) {
        InternalDocumentEvent ee = new InternalDocumentEvent(this, event);
        DocumentListener[] listeners = this.documentListeners();
        int i = listeners.length;
        while (i-- > 0) {
            listeners[i].changedUpdate(ee);
        }
    }

    protected void delegateInsertUpdate(DocumentEvent event) {
        InternalDocumentEvent ee = new InternalDocumentEvent(this, event);
        DocumentListener[] listeners = this.documentListeners();
        int i = listeners.length;
        while (i-- > 0) {
            listeners[i].insertUpdate(ee);
        }
    }

    protected void delegateRemoveUpdate(DocumentEvent event) {
        InternalDocumentEvent ee = new InternalDocumentEvent(this, event);
        DocumentListener[] listeners = this.documentListeners();
        int i = listeners.length;
        while (i-- > 0) {
            listeners[i].removeUpdate(ee);
        }
    }

    protected void delegateUndoableEditHappened(UndoableEditEvent event) {
        UndoableEditEvent ee = new UndoableEditEvent(this, event.getEdit());
        UndoableEditListener[] listeners = this.undoableEditListeners();
        int i = listeners.length;
        while (i-- > 0) {
            listeners[i].undoableEditHappened(ee);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.stringHolder);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.stringListener = this.buildStringListener();
    }

    protected static interface CombinedListener
    extends DocumentListener,
    UndoableEditListener,
    Serializable {
    }

    protected static class InternalDocumentEvent
    extends EventObject
    implements DocumentEvent {
        protected DocumentEvent delegate;

        protected InternalDocumentEvent(Document document, DocumentEvent delegate) {
            super(document);
            this.delegate = delegate;
        }

        public DocumentEvent.ElementChange getChange(Element elem) {
            return this.delegate.getChange(elem);
        }

        public Document getDocument() {
            return (Document)this.source;
        }

        public int getLength() {
            return this.delegate.getLength();
        }

        public int getOffset() {
            return this.delegate.getOffset();
        }

        public DocumentEvent.EventType getType() {
            return this.delegate.getType();
        }
    }

    protected class InternalListener
    implements CombinedListener {
        private static final long serialVersionUID = 1L;

        protected InternalListener() {
        }

        public void changedUpdate(DocumentEvent event) {
            DocumentAdapter.this.delegateChangedUpdate(event);
        }

        public void insertUpdate(DocumentEvent event) {
            DocumentAdapter.this.delegateInsertUpdate(event);
        }

        public void removeUpdate(DocumentEvent event) {
            DocumentAdapter.this.delegateRemoveUpdate(event);
        }

        public void undoableEditHappened(UndoableEditEvent event) {
            DocumentAdapter.this.delegateUndoableEditHappened(event);
        }
    }
}

