/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ReadOnlyIterator;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringCollectionValueModel<E>
extends CollectionValueModelWrapper<E>
implements CollectionValueModel<E> {
    private Filter<E> filter;
    private final Collection<E> filteredItems = new ArrayList();

    public FilteringCollectionValueModel(CollectionValueModel<? extends E> collectionHolder) {
        this(collectionHolder, Filter.Null.instance());
    }

    public FilteringCollectionValueModel(CollectionValueModel<? extends E> collectionHolder, Filter<E> filter) {
        super(collectionHolder);
        this.filter = filter;
    }

    public FilteringCollectionValueModel(ListValueModel<E> listHolder) {
        this(new ListCollectionValueModelAdapter<E>(listHolder));
    }

    public FilteringCollectionValueModel(ListValueModel<E> listHolder, Filter<E> filter) {
        this(new ListCollectionValueModelAdapter<E>(listHolder), filter);
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyIterator<E>(this.filteredItems);
    }

    @Override
    public int size() {
        return this.filteredItems.size();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        CollectionTools.addAll(this.filteredItems, this.filter(this.collectionHolder));
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        this.filteredItems.clear();
    }

    @Override
    protected void itemsAdded(CollectionAddEvent event) {
        this.addItemsToCollection(this.filter(this.getItems(event)), this.filteredItems, "values");
    }

    @Override
    protected void itemsRemoved(CollectionRemoveEvent event) {
        this.removeItemsFromCollection(event.getItems(), this.filteredItems, "values");
    }

    @Override
    protected void collectionCleared(CollectionClearEvent event) {
        this.clearCollection(this.filteredItems, "values");
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent event) {
        this.rebuildFilteredItems();
    }

    public void setFilter(Filter<E> filter) {
        this.filter = filter;
        this.rebuildFilteredItems();
    }

    protected Iterable<E> filter(Iterable<? extends E> items) {
        return new FilteringIterable<E>(items, this.filter);
    }

    protected void rebuildFilteredItems() {
        this.filteredItems.clear();
        CollectionTools.addAll(this.filteredItems, this.filter(this.collectionHolder));
        this.fireCollectionChanged("values", this.filteredItems);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.filteredItems);
    }
}

