/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result.filter;

import org.eclipse.core.runtime.Assert;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.CompositeExpression;
import org.eclipse.datatools.connectivity.oda.spec.util.ValidatorUtil;

public class NotExpression
extends CompositeExpression {
    public NotExpression(FilterExpression expression) {
        Assert.isNotNull((Object)expression);
        super.add(expression);
    }

    public CompositeExpression add(FilterExpression expression) {
        throw new IllegalStateException(Messages.bind((String)Messages.querySpec_MAX_ONE_NEGATING_EXPR, (Object)this.getName()));
    }

    public FilterExpression getNegatingExpression() {
        return this.childCount() == 0 ? null : this.getExpressions().get(0);
    }

    protected void validateChildren(ValidationContext context) throws OdaException {
        try {
            this.validateMinElements(1);
            FilterExpression negatingExpr = this.getNegatingExpression();
            if (!negatingExpr.isNegatable()) {
                throw ValidatorUtil.newOdaException(Messages.bind((String)Messages.querySpec_NOT_EXPR_INCOMPATIBLE, (Object)negatingExpr.getName(), (Object)this.getName()), negatingExpr.getQualifiedId());
            }
            super.validateChildren(context, false);
        }
        catch (OdaException ex) {
            throw ValidatorUtil.newFilterExprException(this, ex);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof NotExpression)) {
            return false;
        }
        NotExpression that = (NotExpression)object;
        return this.getNegatingExpression().equals(that.getNegatingExpression());
    }
}

