/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.internal.core.util.ISender;
import org.eclipse.dstore.internal.core.util.XMLgenerator;

public class Sender
implements ISender {
    private Socket _socket;
    private PrintStream _outFile;
    private BufferedWriter _outData;
    private XMLgenerator _xmlGenerator;
    private DataStore _dataStore;

    public Sender(Socket socket, DataStore dataStore) {
        this._socket = socket;
        this._dataStore = dataStore;
        this._xmlGenerator = new XMLgenerator(this._dataStore);
        try {
            String noDelayStr = System.getProperty("DSTORE_TCP_NO_DELAY");
            if (noDelayStr != null && noDelayStr.length() > 0) {
                try {
                    boolean noDelay = Boolean.valueOf(noDelayStr);
                    this._socket.setTcpNoDelay(noDelay);
                    noDelay = this._socket.getTcpNoDelay();
                    this._dataStore.trace("tcp no delay set to " + noDelay);
                }
                catch (Exception exception) {}
            }
            int bufferSize = this._socket.getSendBufferSize();
            this._xmlGenerator.setBufferSize(bufferSize);
        }
        catch (SocketException socketException) {}
        try {
            this._outFile = new PrintStream(this._socket.getOutputStream());
            String encoding = "UTF-8";
            if (!this._dataStore.isVirtual()) {
                encoding = System.getProperty("file.encoding");
                String theOS = System.getProperty("os.name").toLowerCase();
                if (theOS.startsWith("z") || theOS.startsWith("win")) {
                    encoding = "UTF-8";
                }
            }
            OutputStreamWriter writer = new OutputStreamWriter(this._socket.getOutputStream(), encoding);
            this._outData = new BufferedWriter(writer);
            this._xmlGenerator.setFileWriter(this._outFile);
            this._xmlGenerator.setDataWriter(this._outData);
            this._xmlGenerator.setGenerateBuffer(false);
            InetSocketAddress address = (InetSocketAddress)socket.getRemoteSocketAddress();
            if (address != null) {
                if (address.getAddress() != null) {
                    String remoteIP = address.getAddress().getHostAddress();
                    this._dataStore.setRemoteIP(remoteIP);
                } else {
                    String remoteIP = address.getHostName();
                    this._dataStore.setRemoteIP(remoteIP);
                }
            } else {
                String remoteIP = socket.getInetAddress().getHostAddress();
                this._dataStore.setRemoteIP(remoteIP);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Socket socket() {
        return this._socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDocument(String document) {
        BufferedWriter bufferedWriter = this._outData;
        synchronized (bufferedWriter) {
            try {
                this._outData.write(document, 0, document.length());
                this._outData.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile(DataElement objectRoot, byte[] bytes, int size, boolean binary) {
        BufferedWriter bufferedWriter = this._outData;
        synchronized (bufferedWriter) {
            PrintStream printStream = this._outFile;
            synchronized (printStream) {
                this._xmlGenerator.empty();
                this._xmlGenerator.generate(objectRoot, bytes, size, false, binary);
                this._xmlGenerator.flushData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendClass(DataElement classElement) {
        String className = classElement.getName();
        ArrayList loaders = this._dataStore.getLocalClassLoaders();
        if (loaders == null) {
            this.generateEmptyClass(classElement);
            return;
        }
        InputStream classInStream = null;
        className = className.replace('.', '/');
        className = String.valueOf(className) + ".class";
        URL classLocation = null;
        int i = 0;
        while (i < loaders.size()) {
            ClassLoader loader = (ClassLoader)loaders.get(i);
            classInStream = loader.getResourceAsStream(className);
            classLocation = loader.getResource(className);
            if (classInStream != null && classLocation != null) break;
            ++i;
        }
        if (classLocation == null || classInStream == null) {
            this.generateEmptyClass(classElement);
            return;
        }
        BufferedInputStream bufInputStream = new BufferedInputStream(classInStream);
        try {
            int classSize = bufInputStream.available();
            byte[] bytes = new byte[classSize];
            int result = 0;
            result = bufInputStream.read(bytes);
            if (result != classSize) {
                this.generateEmptyClass(classElement);
                return;
            }
            BufferedWriter bufferedWriter = this._outData;
            synchronized (bufferedWriter) {
                PrintStream printStream = this._outFile;
                synchronized (printStream) {
                    this._xmlGenerator.empty();
                    this._xmlGenerator.generate(classElement, bytes, classSize);
                    this._xmlGenerator.flushData();
                }
            }
        }
        catch (IOException iOException) {
            this.generateEmptyClass(classElement);
            return;
        }
    }

    private void generateEmptyClass(DataElement classElement) {
        this._xmlGenerator.empty();
        this._xmlGenerator.generate(classElement, new byte[0], 0);
        this._xmlGenerator.flushData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAppendFile(DataElement objectRoot, byte[] bytes, int size, boolean binary) {
        BufferedWriter bufferedWriter = this._outData;
        synchronized (bufferedWriter) {
            PrintStream printStream = this._outFile;
            synchronized (printStream) {
                this._xmlGenerator.empty();
                this._xmlGenerator.generate(objectRoot, bytes, size, true, binary);
                this._xmlGenerator.flushData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDocument(DataElement objectRoot, int depth) {
        BufferedWriter bufferedWriter = this._outData;
        synchronized (bufferedWriter) {
            PrintStream printStream = this._outFile;
            synchronized (printStream) {
                this._xmlGenerator.empty();
                this._xmlGenerator.generate(objectRoot, depth);
                this._xmlGenerator.flushData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestClass(DataElement classRequest) {
        BufferedWriter bufferedWriter = this._outData;
        synchronized (bufferedWriter) {
            PrintStream printStream = this._outFile;
            synchronized (printStream) {
                this._xmlGenerator.empty();
                this._xmlGenerator.generateClassRequest(classRequest);
                this._xmlGenerator.flushData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRemoteClassRunnable(DataElement objectRoot, IRemoteClassInstance runnable) {
        BufferedWriter bufferedWriter = this._outData;
        synchronized (bufferedWriter) {
            PrintStream printStream = this._outFile;
            synchronized (printStream) {
                this._xmlGenerator.empty();
                this._xmlGenerator.generateSerializedObject(objectRoot, runnable);
                this._xmlGenerator.flushData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeepAliveRequest(DataElement document) {
        BufferedWriter bufferedWriter = this._outData;
        synchronized (bufferedWriter) {
            PrintStream printStream = this._outFile;
            synchronized (printStream) {
                this._xmlGenerator.empty();
                this._xmlGenerator.generate(document, 2);
                this._xmlGenerator.flushData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeepAliveConfirmation(DataElement document) {
        BufferedWriter bufferedWriter = this._outData;
        synchronized (bufferedWriter) {
            PrintStream printStream = this._outFile;
            synchronized (printStream) {
                this._xmlGenerator.empty();
                this._xmlGenerator.generate(document, 2);
                this._xmlGenerator.flushData();
            }
        }
    }

    public void setGenerateBuffer(boolean flag) {
        this._xmlGenerator.setGenerateBuffer(flag);
    }
}

