/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.StringHelper;

final class TermInfosWriter {
    public static final int FORMAT = -2;
    private FieldInfos fieldInfos;
    private IndexOutput output;
    private Term lastTerm = new Term("", "");
    private TermInfo lastTi = new TermInfo();
    private long size = 0L;
    int indexInterval = 128;
    int skipInterval = 16;
    private long lastIndexPointer = 0L;
    private boolean isIndex = false;
    private TermInfosWriter other = null;

    TermInfosWriter(Directory directory, String segment, FieldInfos fis, int interval) throws IOException {
        this.initialize(directory, segment, fis, interval, false);
        this.other = new TermInfosWriter(directory, segment, fis, interval, true);
        this.other.other = this;
    }

    private TermInfosWriter(Directory directory, String segment, FieldInfos fis, int interval, boolean isIndex) throws IOException {
        this.initialize(directory, segment, fis, interval, isIndex);
    }

    private void initialize(Directory directory, String segment, FieldInfos fis, int interval, boolean isi) throws IOException {
        this.indexInterval = interval;
        this.fieldInfos = fis;
        this.isIndex = isi;
        this.output = directory.createOutput(segment + (this.isIndex ? ".tii" : ".tis"));
        this.output.writeInt(-2);
        this.output.writeLong(0L);
        this.output.writeInt(this.indexInterval);
        this.output.writeInt(this.skipInterval);
    }

    final void add(Term term, TermInfo ti) throws IOException {
        if (!this.isIndex && term.compareTo(this.lastTerm) <= 0) {
            throw new IOException("term out of order");
        }
        if (ti.freqPointer < this.lastTi.freqPointer) {
            throw new IOException("freqPointer out of order");
        }
        if (ti.proxPointer < this.lastTi.proxPointer) {
            throw new IOException("proxPointer out of order");
        }
        if (!this.isIndex && this.size % (long)this.indexInterval == 0L) {
            this.other.add(this.lastTerm, this.lastTi);
        }
        this.writeTerm(term);
        this.output.writeVInt(ti.docFreq);
        this.output.writeVLong(ti.freqPointer - this.lastTi.freqPointer);
        this.output.writeVLong(ti.proxPointer - this.lastTi.proxPointer);
        if (ti.docFreq >= this.skipInterval) {
            this.output.writeVInt(ti.skipOffset);
        }
        if (this.isIndex) {
            this.output.writeVLong(this.other.output.getFilePointer() - this.lastIndexPointer);
            this.lastIndexPointer = this.other.output.getFilePointer();
        }
        this.lastTi.set(ti);
        ++this.size;
    }

    private final void writeTerm(Term term) throws IOException {
        int start = StringHelper.stringDifference(this.lastTerm.text, term.text);
        int length = term.text.length() - start;
        this.output.writeVInt(start);
        this.output.writeVInt(length);
        this.output.writeChars(term.text, start, length);
        this.output.writeVInt(this.fieldInfos.fieldNumber(term.field));
        this.lastTerm = term;
    }

    final void close() throws IOException {
        this.output.seek(4L);
        this.output.writeLong(this.size);
        this.output.close();
        if (!this.isIndex) {
            this.other.close();
        }
    }
}

