/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.ddlgen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    protected EntityManagerFactory emf;
    private Map<String, String> eclipseLinkProperties;
    private String createDDLFileName;
    private String dropDDLFileName;
    private String appLocation;
    private String eclipseLinkPropertiesPath;
    private boolean isDebugMode;

    public static void main(String[] args) {
        new Main().execute(args);
    }

    private Main() {
    }

    protected void execute(String[] args) {
        this.initializeWith(args);
        this.emf = Persistence.createEntityManagerFactory((String)this.getPUName(args), this.eclipseLinkProperties);
        this.perform();
        this.closeEntityManagerFactory();
        this.dispose();
    }

    protected void perform() {
        this.emf.createEntityManager().close();
    }

    protected void closeEntityManagerFactory() {
        this.emf.close();
    }

    private void initializeWith(String[] args) {
        this.eclipseLinkPropertiesPath = this.getEclipseLinkPropertiesPath(args);
        this.eclipseLinkProperties = this.getProperties(this.eclipseLinkPropertiesPath);
        this.createDDLFileName = this.getConfigPropertyAsString("eclipselink.create-ddl-jdbc-file-name", this.eclipseLinkProperties, "createDDL.sql");
        this.dropDDLFileName = this.getConfigPropertyAsString("eclipselink.drop-ddl-jdbc-file-name", this.eclipseLinkProperties, "dropDDL.sql");
        this.appLocation = this.eclipseLinkProperties.get("eclipselink.application-location");
        this.isDebugMode = this.getDebugMode(args);
    }

    private void dispose() {
        if (!this.isDebugMode) {
            new File(String.valueOf(this.appLocation) + "/" + this.createDDLFileName).delete();
            new File(String.valueOf(this.appLocation) + "/" + this.dropDDLFileName).delete();
            new File(this.eclipseLinkPropertiesPath).delete();
        }
    }

    private Map<String, String> getProperties(String eclipseLinkPropertiesPath) {
        Set<Map.Entry<Object, Object>> propertiesSet = null;
        try {
            propertiesSet = this.loadEclipseLinkProperties(eclipseLinkPropertiesPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Missing: " + eclipseLinkPropertiesPath, e);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> property : propertiesSet) {
            properties.put((String)property.getKey(), (String)property.getValue());
        }
        return properties;
    }

    private Set<Map.Entry<Object, Object>> loadEclipseLinkProperties(String eclipseLinkPropertiesPath) throws IOException {
        FileInputStream stream = new FileInputStream(eclipseLinkPropertiesPath);
        Properties properties = new Properties();
        properties.load(stream);
        return properties.entrySet();
    }

    private String getPUName(String[] args) {
        return this.getArgumentValue("-pu", args);
    }

    private String getEclipseLinkPropertiesPath(String[] args) {
        return this.getArgumentValue("-p", args);
    }

    private boolean getDebugMode(String[] args) {
        return this.argumentExists("-debug", args);
    }

    private String getArgumentValue(String argument, String[] args) {
        int i = 0;
        while (i < args.length) {
            int j;
            String arg = args[i];
            if (arg.toLowerCase().equals(argument) && (j = i + 1) < args.length) {
                return args[j];
            }
            ++i;
        }
        return null;
    }

    private boolean argumentExists(String argument, String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.toLowerCase().equals(argument)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getConfigPropertyAsString(String propertyKey, Map<String, String> overrides, String defaultValue) {
        String value = this.getConfigPropertyAsString(propertyKey, overrides);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected String getConfigPropertyAsString(String propertyKey, Map<String, String> overrides) {
        String value = null;
        if (overrides != null) {
            value = overrides.get(propertyKey);
        }
        if (value == null) {
            value = System.getProperty(propertyKey);
        }
        return value;
    }
}

