/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.dbws.eclipselink.core.gen.internal;

import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.eclipse.jpt.dbws.eclipselink.core.gen.internal.JptDbwsCoreMessages;

public final class Tools {
    public static final String EMPTY_STRING = "";
    private static final String USER_DIRECTORY = System.getProperty("user.dir");

    public static boolean stringIsEmpty(String string) {
        if (string == null) {
            return true;
        }
        int len = string.length();
        if (len == 0) {
            return true;
        }
        return Tools.stringIsEmpty_(string.toCharArray(), len);
    }

    private static boolean stringIsEmpty_(char[] s, int len) {
        int i = len;
        while (i-- > 0) {
            if (Character.isWhitespace(s[i])) continue;
            return false;
        }
        return true;
    }

    public static File buildDirectory(String dirName) {
        File currentDir = Tools.currentWorkingDirectory();
        File dir = new File(currentDir, dirName);
        dir.mkdir();
        return dir;
    }

    public static File currentWorkingDirectory() {
        return new File(USER_DIRECTORY);
    }

    public static String stripExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static String extractDirectory(String path) {
        if (!path.contains(File.separator)) {
            return EMPTY_STRING;
        }
        return path.substring(0, path.lastIndexOf(File.separator));
    }

    public static void logMessage(Level level, String message) {
        if (level == Level.SEVERE) {
            System.err.println(String.valueOf('\n') + message);
        } else {
            System.out.println(String.valueOf('\n') + message);
        }
    }

    public static String getString(String key) {
        return JptDbwsCoreMessages.getString(key);
    }

    public static String bind(String key, Object argument) {
        return MessageFormat.format(Tools.getString(key), argument);
    }
}

