/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal.wizard;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.importexport.P2ImportExport;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractPage
extends WizardPage
implements Listener {
    protected String currentMessage;
    protected Button destinationBrowseButton;
    protected Combo destinationNameField;
    protected P2ImportExport importexportService = null;
    protected CheckboxTableViewer viewer = null;
    protected Exception finishException;
    protected static IProfileRegistry profileRegistry = null;
    protected static IProvisioningAgent agent = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        BundleContext context = Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport").getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.core.IProvisioningAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceTracker tracker = new ServiceTracker(context, (Class)clazz, null);
        tracker.open();
        agent = (IProvisioningAgent)tracker.getService();
        tracker.close();
        if (agent != null) {
            profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        }
    }

    public AbstractPage(String pageName) {
        super(pageName);
    }

    public AbstractPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected IProfile getSelfProfile() {
        if (profileRegistry != null) {
            String selfID = System.getProperty("eclipse.p2.profile");
            if (selfID == null) {
                selfID = "_SELF_";
            }
            return profileRegistry.getProfile(selfID);
        }
        return null;
    }

    private void createColumns(TableViewer viewer) {
        String[] titles = new String[]{Messages.Column_Name, Messages.Column_Version, Messages.Column_Id};
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn column = new TableViewerColumn(viewer, 0);
            column.getColumn().setText(titles[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            if (Messages.Column_Name.equals(titles[i])) {
                this.updateTableSorting(i);
            }
            final int columnIndex = i++;
            column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractPage.this.updateTableSorting(columnIndex);
                }
            });
        }
    }

    protected void updateTableSorting(int columnIndex) {
        TableViewerComparator comparator = (TableViewerComparator)this.viewer.getComparator();
        if (columnIndex == comparator.getSortColumn()) {
            comparator.setAscending(!comparator.isAscending());
        }
        comparator.setSortColumn(columnIndex);
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(columnIndex));
        this.viewer.getTable().setSortDirection(comparator.isAscending() ? 128 : 1024);
        this.viewer.refresh(false);
    }

    protected abstract void createContents(Composite var1);

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.initializeService();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        this.createContents(composite);
        if (!this.validDestination() || !this.validateOptionsGroup()) {
            this.setPageComplete(false);
        }
        this.setControl((Control)composite);
        this.giveFocusToDestination();
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createDestinationGroup(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(composite, 0);
        label.setText(this.getDestinationLabel());
        this.destinationNameField = new Combo(composite, 2052);
        GridData data = new GridData(768);
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        this.destinationNameField.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                AbstractPage.this.destinationNameField.clearSelection();
            }
        });
        this.destinationBrowseButton = new Button(composite, 8);
        this.destinationBrowseButton.setText(Messages.Page_BUTTON_BROWSER);
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationBrowseButton.setLayoutData((Object)new GridData(256));
    }

    protected IUColumnConfig[] getColumnConfig() {
        return new IUColumnConfig[]{new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, 60), new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, 20), new IUColumnConfig(ProvUIMessages.ProvUI_IdColumnTitle, 0, 40)};
    }

    protected void createInstallationTable(final Composite parent) {
        Group group = new Group(parent, 0);
        GridData griddata = new GridData(4, 4, true, true);
        griddata.horizontalSpan = 0;
        griddata.verticalSpan = 0;
        group.setLayoutData((Object)griddata);
        group.setLayout((Layout)new GridLayout(1, false));
        this.viewer = CheckboxTableViewer.newCheckList((Composite)group, (int)2050);
        final Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        this.viewer.setComparator((ViewerComparator)new TableViewerComparator());
        this.createColumns((TableViewer)this.viewer);
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        parent.addControlListener((ControlListener)new ControlAdapter(){
            private final int[] columnRate = new int[]{6, 2, 2};

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point size = table.computeSize(-1, -1);
                ScrollBar vBar = table.getVerticalBar();
                int width = area.width - table.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                if (size.y > area.height + table.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                TableColumn[] columns = table.getColumns();
                int hasUsed = 0;
                int i = 0;
                if (oldSize.x > area.width) {
                    while (i < columns.length - 1) {
                        columns[i].setWidth(width * this.columnRate[i] / 10);
                        hasUsed += columns[i].getWidth();
                        ++i;
                    }
                    columns[columns.length - 1].setWidth(width - hasUsed);
                    table.setSize(area.width, area.height);
                } else {
                    table.setSize(area.width, area.height);
                    while (i < columns.length - 1) {
                        columns[i].setWidth(width * this.columnRate[i] / 10);
                        hasUsed += columns[i].getWidth();
                        ++i;
                    }
                    columns[columns.length - 1].setWidth(width - hasUsed);
                }
            }
        });
        ICheckStateProvider provider = this.getViewerDefaultState();
        if (provider != null) {
            this.viewer.setCheckStateProvider(provider);
        } else {
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AbstractPage.this.updatePageCompletion();
                }
            });
        }
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getControl().setSize(300, 200);
        this.viewer.setInput(this.getInput());
        Composite buttons = new Composite((Composite)group, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        buttons.setLayout((Layout)new RowLayout(256));
        Button selectAll = new Button(buttons, 8);
        selectAll.setText(Messages.AbstractPage_ButtonSelectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = AbstractPage.this.viewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (!item.getChecked()) {
                        item.setChecked(true);
                        Event event = new Event();
                        event.widget = item.getParent();
                        event.detail = 32;
                        event.item = item;
                        event.type = 13;
                        AbstractPage.this.viewer.getTable().notifyListeners(13, event);
                    }
                    ++n2;
                }
                AbstractPage.this.updatePageCompletion();
            }
        });
        Button deselectAll = new Button(buttons, 8);
        deselectAll.setText(Messages.AbstractPage_ButtonDeselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPage.this.viewer.setAllChecked(false);
                AbstractPage.this.updatePageCompletion();
            }
        });
    }

    protected ICheckStateProvider getViewerDefaultState() {
        return null;
    }

    protected ITableLabelProvider getLabelProvider() {
        return new IUDetailsLabelProvider(null, this.getColumnConfig(), null);
    }

    protected IContentProvider getContentProvider() {
        return new DeferredQueryContentProvider();
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        this.currentMessage = null;
        boolean bl = complete = this.validateDestinationGroup() && this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(this.currentMessage);
        }
        return complete;
    }

    protected abstract void doFinish() throws Exception;

    protected int getBrowseDialogStyle() {
        return 4096;
    }

    protected abstract String getDestinationLabel();

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected abstract String getDialogTitle();

    protected abstract Object getInput();

    protected abstract String getInvalidDestinationMessage();

    protected String getNoOptionsMessage() {
        return Messages.PAGE_NOINSTALLTION_ERROR;
    }

    protected abstract void giveFocusToDestination();

    protected void handleDestinationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), this.getBrowseDialogStyle() | 0x10000000);
        dialog.setText(this.getDialogTitle());
        dialog.setFilterPath(this.getDestinationValue());
        dialog.setFilterExtensions(new String[]{Messages.EXTENSION_p2F, Messages.EXTENSION_ALL});
        dialog.setFilterNames(new String[]{Messages.EXTENSION_p2F_NAME, Messages.EXTENSION_ALL_NAME});
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            if (!selectedFileName.endsWith(Messages.EXTENSION_p2F.substring(1))) {
                selectedFileName = String.valueOf(selectedFileName) + Messages.EXTENSION_p2F.substring(1);
            }
            this.setDestinationValue(selectedFileName);
        }
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        } else {
            this.handleDestinationChanged(this.getDestinationValue());
        }
        this.updatePageCompletion();
    }

    protected void handleDestinationChanged(String newDestination) {
    }

    protected void initializeService() {
        BundleContext bundleContext = Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport").getBundleContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.p2.importexport.P2ImportExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceTracker tracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        tracker.open();
        this.importexportService = (P2ImportExport)tracker.getService();
        tracker.close();
    }

    protected void setDestinationValue(String selectedFileName) {
        this.destinationNameField.setText(selectedFileName);
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
    }

    protected boolean validateDestinationGroup() {
        if (!this.validDestination()) {
            this.currentMessage = this.getInvalidDestinationMessage();
            return false;
        }
        return true;
    }

    protected boolean validateOptionsGroup() {
        if (this.viewer == null || this.viewer.getCheckedElements().length > 0) {
            return true;
        }
        this.currentMessage = this.getNoOptionsMessage();
        return false;
    }

    protected boolean validDestination() {
        if (this.destinationNameField == null) {
            return true;
        }
        File file = new File(this.getDestinationValue());
        return file.getPath().length() > 0 && !file.isDirectory();
    }

    class TableViewerComparator
    extends ViewerComparator {
        private int sortColumn = 0;
        private int lastSortColumn = 0;
        private boolean ascending = false;
        private boolean lastAscending = false;

        TableViewerComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IInstallableUnit iu1 = (IInstallableUnit)ProvUI.getAdapter((Object)e1, (Class)clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IInstallableUnit iu2 = (IInstallableUnit)ProvUI.getAdapter((Object)e2, (Class)clazz2);
            if (iu1 != null && iu2 != null) {
                TableViewer tableViewer;
                IBaseLabelProvider baseLabel;
                if (viewer instanceof TableViewer && (baseLabel = (tableViewer = (TableViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
                    ITableLabelProvider tableProvider = (ITableLabelProvider)baseLabel;
                    String e1p = tableProvider.getColumnText(e1, this.getSortColumn());
                    String e2p = tableProvider.getColumnText(e2, this.getSortColumn());
                    int result = this.getComparator().compare(e1p, e2p);
                    if (result == 0) {
                        e1p = tableProvider.getColumnText(e1, this.lastSortColumn);
                        e2p = tableProvider.getColumnText(e2, this.lastSortColumn);
                        int result2 = this.getComparator().compare(e1p, e2p);
                        return this.lastAscending ? result2 : -1 * result2;
                    }
                    return this.isAscending() ? result : -1 * result;
                }
                return 0;
            }
            return super.compare(viewer, e1, e2);
        }

        public int getSortColumn() {
            return this.sortColumn;
        }

        public void setSortColumn(int sortColumn) {
            if (this.sortColumn != sortColumn) {
                this.lastSortColumn = this.sortColumn;
                this.lastAscending = this.ascending;
                this.sortColumn = sortColumn;
            }
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }
}

