/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contexts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.contexts.DebugContextSourceProvider;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.debug.ui.contexts.IDebugContextProvider2;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IEvaluationService;

public class DebugWindowContextService
implements IDebugContextService,
IPartListener2,
IDebugContextListener {
    private Map fListenersByPartId = new HashMap();
    private Map fProvidersByPartId = new HashMap();
    private Map fPostListenersByPartId = new HashMap();
    private IWorkbenchWindow fWindow;
    private List fProviders = new ArrayList();
    private DebugContextSourceProvider fSourceProvider;
    static /* synthetic */ Class class$0;

    public DebugWindowContextService(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fWindow.getPartService().addPartListener((IPartListener2)this);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.services.IEvaluationService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IEvaluationService evaluationService = (IEvaluationService)window.getService((Class)clazz);
        this.fSourceProvider = new DebugContextSourceProvider(this, evaluationService);
    }

    public void dispose() {
        this.fSourceProvider.dispose();
        this.fWindow.getPartService().removePartListener((IPartListener2)this);
        this.fWindow = null;
    }

    public synchronized void addDebugContextProvider(IDebugContextProvider provider) {
        if (this.fWindow == null) {
            return;
        }
        IWorkbenchPart part = provider.getPart();
        String id = null;
        if (part != null) {
            id = this.getCombinedPartId(part);
        }
        this.fProvidersByPartId.put(id, provider);
        this.fProviders.add(provider);
        IWorkbenchPart active = null;
        IWorkbenchPage activePage = this.fWindow.getActivePage();
        if (activePage != null) {
            active = activePage.getActivePart();
        }
        if (this.fProviders.size() == 1 && (part == null || part.equals(active))) {
            this.notify(provider);
        }
        provider.addDebugContextListener(this);
    }

    public synchronized void removeDebugContextProvider(IDebugContextProvider provider) {
        int index = this.fProviders.indexOf(provider);
        if (index >= 0) {
            IWorkbenchPart part = provider.getPart();
            String id = null;
            if (part != null) {
                id = this.getCombinedPartId(part);
            }
            this.fProvidersByPartId.remove(id);
            this.fProviders.remove(index);
            if (index == 0) {
                IDebugContextProvider activeProvider = this.getActiveProvider();
                if (activeProvider != null) {
                    this.notify(activeProvider);
                } else {
                    this.notify(new DebugContextEvent(provider, (ISelection)new StructuredSelection(), 1));
                }
            }
        }
        provider.removeDebugContextListener(this);
    }

    public void addDebugContextListener(IDebugContextListener listener) {
        this.addDebugContextListener(listener, null);
    }

    public void addPostDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = (ListenerList)this.fPostListenersByPartId.get(partId);
        if (list == null) {
            list = new ListenerList();
            this.fPostListenersByPartId.put(partId, list);
        }
        list.add((Object)listener);
    }

    public void addPostDebugContextListener(IDebugContextListener listener) {
        this.addPostDebugContextListener(listener, null);
    }

    public void removePostDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = (ListenerList)this.fPostListenersByPartId.get(partId);
        if (list != null) {
            list.remove((Object)listener);
        }
    }

    public void removePostDebugContextListener(IDebugContextListener listener) {
        this.removePostDebugContextListener(listener, null);
    }

    public void removeDebugContextListener(IDebugContextListener listener) {
        this.removeDebugContextListener(listener, null);
    }

    protected void notify(IDebugContextProvider provdier) {
        ISelection activeContext = provdier.getActiveContext();
        if (activeContext == null) {
            activeContext = new StructuredSelection();
        }
        this.notify(new DebugContextEvent(provdier, activeContext, 1));
    }

    protected void notify(DebugContextEvent event) {
        IDebugContextProvider provider = this.getActiveProvider();
        if (provider != null) {
            IWorkbenchPart part = event.getDebugContextProvider().getPart();
            if (provider == event.getDebugContextProvider()) {
                this.notify(event, this.getListeners(null));
            }
            if (part != null) {
                this.notify(event, this.getListeners(part));
            }
            if (provider == event.getDebugContextProvider()) {
                this.notify(event, this.getPostListeners(null));
            }
            if (part != null) {
                this.notify(event, this.getPostListeners(part));
            }
        }
    }

    protected void notify(final DebugContextEvent event, Object[] listeners) {
        int i = 0;
        while (i < listeners.length) {
            final IDebugContextListener listener = (IDebugContextListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.debugContextChanged(event);
                }

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }
            });
            ++i;
        }
    }

    protected Object[] getListeners(IWorkbenchPart part) {
        String id = null;
        if (part != null) {
            id = this.getCombinedPartId(part);
            ListenerList listenerList = (ListenerList)this.fListenersByPartId.get(id);
            return listenerList != null ? listenerList.getListeners() : new Object[]{};
        }
        ArrayList<Object> retVal = new ArrayList<Object>();
        retVal.addAll(Arrays.asList(((ListenerList)this.fListenersByPartId.get(null)).getListeners()));
        Iterator itr = this.fListenersByPartId.keySet().iterator();
        block0: while (itr.hasNext()) {
            String listenerPartId = (String)itr.next();
            int i = 0;
            while (i < this.fProviders.size()) {
                String providerPartId = this.getCombinedPartId(((IDebugContextProvider)this.fProviders.get(i)).getPart());
                if (listenerPartId == null && providerPartId == null || listenerPartId != null && listenerPartId.equals(providerPartId)) continue block0;
                ++i;
            }
            List<Object> toAdd = Arrays.asList(((ListenerList)this.fListenersByPartId.get(listenerPartId)).getListeners());
            Iterator<Object> addItr = toAdd.iterator();
            while (addItr.hasNext()) {
                Object element = addItr.next();
                if (retVal.contains(element)) continue;
                retVal.add(element);
            }
        }
        return retVal.toArray();
    }

    protected Object[] getPostListeners(IWorkbenchPart part) {
        String id = null;
        if (part != null) {
            id = this.getCombinedPartId(part);
            ListenerList listenerList = (ListenerList)this.fPostListenersByPartId.get(id);
            return listenerList != null ? listenerList.getListeners() : new Object[]{};
        }
        ArrayList<Object> retVal = new ArrayList<Object>();
        ListenerList postListenersList = (ListenerList)this.fPostListenersByPartId.get(null);
        if (postListenersList != null) {
            retVal.addAll(Arrays.asList(postListenersList.getListeners()));
        }
        Iterator itr = this.fPostListenersByPartId.keySet().iterator();
        block0: while (itr.hasNext()) {
            String listenerPartId = (String)itr.next();
            int i = 0;
            while (i < this.fProviders.size()) {
                String providerPartId = this.getCombinedPartId(((IDebugContextProvider)this.fProviders.get(i)).getPart());
                if (listenerPartId == null && providerPartId == null || listenerPartId != null && listenerPartId.equals(providerPartId)) continue block0;
                ++i;
            }
            retVal.addAll(Arrays.asList(((ListenerList)this.fPostListenersByPartId.get(listenerPartId)).getListeners()));
        }
        return retVal.toArray();
    }

    public synchronized void addDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = (ListenerList)this.fListenersByPartId.get(partId);
        if (list == null) {
            list = new ListenerList();
            this.fListenersByPartId.put(partId, list);
        }
        list.add((Object)listener);
    }

    public void removeDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = (ListenerList)this.fListenersByPartId.get(partId);
        if (list != null) {
            list.remove((Object)listener);
            if (list.size() == 0) {
                this.fListenersByPartId.remove(partId);
            }
        }
    }

    public ISelection getActiveContext(String partId) {
        IDebugContextProvider provider = (IDebugContextProvider)this.fProvidersByPartId.get(partId);
        if (provider != null) {
            return provider.getActiveContext();
        }
        return this.getActiveContext();
    }

    public ISelection getActiveContext() {
        IDebugContextProvider activeProvider = this.getActiveProvider();
        if (activeProvider != null) {
            return activeProvider.getActiveContext();
        }
        return null;
    }

    private IDebugContextProvider getActiveProvider() {
        if (!this.fProviders.isEmpty()) {
            return (IDebugContextProvider)this.fProviders.get(0);
        }
        return null;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IDebugContextProvider provider = (IDebugContextProvider)this.fProvidersByPartId.get(partRef.getId());
        if (provider != null) {
            int index;
            boolean canSetActive = true;
            if (provider instanceof IDebugContextProvider2) {
                canSetActive = ((IDebugContextProvider2)provider).isWindowContextProvider();
            }
            if (canSetActive && (index = this.fProviders.indexOf(provider)) > 0) {
                this.fProviders.remove(index);
                this.fProviders.add(0, provider);
                this.notify(provider);
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public synchronized void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.notify(event);
    }

    private String getCombinedPartId(IWorkbenchPart part) {
        if (part.getSite() instanceof IViewSite) {
            IViewSite site = (IViewSite)part.getSite();
            return this.getCombinedPartId(site.getId(), site.getSecondaryId());
        }
        return part.getSite().getId();
    }

    private String getCombinedPartId(String id, String secondaryId) {
        return String.valueOf(id) + (secondaryId != null ? ":" + secondaryId : "");
    }

    public void addDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
        this.addDebugContextListener(listener, this.getCombinedPartId(partId, partSecondaryId));
    }

    public void removeDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
        this.removeDebugContextListener(listener, this.getCombinedPartId(partId, partSecondaryId));
    }

    public void addPostDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
        this.addPostDebugContextListener(listener, this.getCombinedPartId(partId, partSecondaryId));
    }

    public void removePostDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
        this.removePostDebugContextListener(listener, this.getCombinedPartId(partId, partSecondaryId));
    }

    public ISelection getActiveContext(String partId, String partSecondaryId) {
        return this.getActiveContext(this.getCombinedPartId(partId, partSecondaryId));
    }
}

