/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.template.java.JavaVariable;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public abstract class AbstractVariableResolver
extends TemplateVariableResolver {
    protected final String fDefaultType;
    private CompilationUnitCompletion.Variable[] fVariables;

    protected AbstractVariableResolver(String defaultType) {
        this.fDefaultType = defaultType;
    }

    protected abstract CompilationUnitCompletion.Variable[] getVisibleVariables(String var1, JavaContext var2);

    public void resolve(TemplateVariable variable, TemplateContext context) {
        if (variable instanceof JavaVariable) {
            JavaContext jc = (JavaContext)context;
            JavaVariable jv = (JavaVariable)variable;
            List params = variable.getVariableType().getParams();
            if (params.size() == 0) {
                this.fVariables = this.getVisibleVariables(this.fDefaultType, jc);
                jv.setParamType(this.fDefaultType);
            } else if (params.size() == 1) {
                String type = (String)params.get(0);
                this.fVariables = this.getVisibleVariables(type, jc);
                jv.setParamType(type);
            } else {
                ArrayList<CompilationUnitCompletion.Variable> variables = new ArrayList<CompilationUnitCompletion.Variable>();
                Iterator iterator = params.iterator();
                while (iterator.hasNext()) {
                    variables.addAll(Arrays.asList(this.getVisibleVariables((String)iterator.next(), jc)));
                }
                this.fVariables = variables.toArray(new CompilationUnitCompletion.Variable[variables.size()]);
                jv.setParamType(this.fDefaultType);
            }
            if (this.fVariables.length <= 0) {
                super.resolve(variable, context);
                return;
            }
            jv.setChoices(this.fVariables);
            jc.markAsUsed(jv.getDefaultValue());
            if (this.fVariables.length > 1) {
                variable.setUnambiguous(false);
            } else {
                variable.setUnambiguous(this.isUnambiguous(context));
            }
        } else {
            super.resolve(variable, context);
        }
    }

    protected String[] resolveAll(TemplateContext context) {
        String[] names = new String[this.fVariables.length];
        int i = 0;
        while (i < this.fVariables.length) {
            names[i] = this.fVariables[i].getName();
            ++i;
        }
        if (names.length > 0) {
            ((JavaContext)context).markAsUsed(names[0]);
        }
        return names;
    }
}

