/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.View;

public abstract class SingleFrameApplication
extends Application {
    private static final Logger logger = Logger.getLogger(SingleFrameApplication.class.getName());
    private FrameView mainView = null;

    public final JFrame getMainFrame() {
        return this.getMainView().getFrame();
    }

    protected final void setMainFrame(JFrame jFrame) {
        this.getMainView().setFrame(jFrame);
    }

    private String sessionFilename(Window window) {
        if (window == null) {
            return null;
        }
        String string = window.getName();
        return string == null ? null : string + ".session.xml";
    }

    protected void configureWindow(Window window) {
        this.getContext().getResourceMap().injectComponents(window);
    }

    protected void initRootPaneContainer(RootPaneContainer rootPaneContainer) {
        Window window;
        JFrame jFrame;
        String string;
        JRootPane jRootPane = rootPaneContainer.getRootPane();
        if (jRootPane.getClientProperty(string = "SingleFrameApplication.initRootPaneContainer") != null) {
            return;
        }
        jRootPane.putClientProperty(string, Boolean.TRUE);
        Container container = jRootPane.getParent();
        if (container instanceof Window) {
            this.configureWindow((Window)container);
        }
        if (rootPaneContainer == (jFrame = this.getMainFrame())) {
            jFrame.addWindowListener(new MainFrameListener());
            jFrame.setDefaultCloseOperation(0);
        } else if (container instanceof Window) {
            window = (Window)container;
            window.addHierarchyListener(new SecondaryWindowListener());
        }
        if (container instanceof JFrame) {
            container.addComponentListener(new FrameBoundsListener());
        }
        if (container instanceof Window) {
            Object object;
            window = (Window)container;
            window.pack();
            if (!window.isLocationByPlatform()) {
                object = rootPaneContainer != jFrame ? jFrame : null;
                window.setLocationRelativeTo((Component)object);
            }
            if ((object = this.sessionFilename((Window)container)) != null) {
                try {
                    this.getContext().getSessionStorage().restore(container, (String)object);
                }
                catch (Exception exception) {
                    String string2 = String.format("couldn't restore sesssion [%s]", object);
                    logger.log(Level.WARNING, string2, exception);
                }
            }
        }
    }

    protected void show(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("null JComponent");
        }
        JFrame jFrame = this.getMainFrame();
        jFrame.getContentPane().add((Component)jComponent, "Center");
        this.initRootPaneContainer(jFrame);
        jFrame.setVisible(true);
    }

    public void show(JDialog jDialog) {
        if (jDialog == null) {
            throw new IllegalArgumentException("null JDialog");
        }
        this.initRootPaneContainer(jDialog);
        jDialog.setVisible(true);
    }

    public void show(JFrame jFrame) {
        if (jFrame == null) {
            throw new IllegalArgumentException("null JFrame");
        }
        this.initRootPaneContainer(jFrame);
        jFrame.setVisible(true);
    }

    private void saveSession(Window window) {
        String string = this.sessionFilename(window);
        if (string != null) {
            try {
                this.getContext().getSessionStorage().save(window, string);
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "couldn't save sesssion", iOException);
            }
        }
    }

    private boolean isVisibleWindow(Window window) {
        return window.isVisible() && (window instanceof JFrame || window instanceof JDialog || window instanceof JWindow);
    }

    private List<Window> getVisibleSecondaryWindows() {
        Window[] windowArray = Window.getWindows();
        ArrayList<Window> arrayList = new ArrayList<Window>(windowArray.length);
        for (Window window : windowArray) {
            if (!this.isVisibleWindow(window)) continue;
            arrayList.add(window);
        }
        return arrayList;
    }

    @Override
    protected void shutdown() {
        this.saveSession(this.getMainFrame());
        for (Window window : this.getVisibleSecondaryWindows()) {
            this.saveSession(window);
        }
    }

    public FrameView getMainView() {
        if (this.mainView == null) {
            this.mainView = new FrameView(this);
        }
        return this.mainView;
    }

    @Override
    public void show(View view) {
        if (this.mainView == null && view instanceof FrameView) {
            this.mainView = (FrameView)view;
        }
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)view.getRootPane().getParent());
        this.initRootPaneContainer(rootPaneContainer);
        ((Window)((Object)rootPaneContainer)).setVisible(true);
    }

    private static class FrameBoundsListener
    implements ComponentListener {
        private FrameBoundsListener() {
        }

        private void maybeSaveFrameSize(ComponentEvent componentEvent) {
            JFrame jFrame;
            if (componentEvent.getComponent() instanceof JFrame && ((jFrame = (JFrame)componentEvent.getComponent()).getExtendedState() & 6) == 0) {
                String string = "WindowState.normalBounds";
                jFrame.getRootPane().putClientProperty(string, jFrame.getBounds());
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.maybeSaveFrameSize(componentEvent);
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    private class SecondaryWindowListener
    implements HierarchyListener {
        private SecondaryWindowListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Window window;
            if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && hierarchyEvent.getSource() instanceof Window && !(window = (Window)hierarchyEvent.getSource()).isShowing()) {
                SingleFrameApplication.this.saveSession(window);
            }
        }
    }

    private class MainFrameListener
    extends WindowAdapter {
        private MainFrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            SingleFrameApplication.this.exit(windowEvent);
        }
    }
}

