/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeTableModel
extends AbstractTreeTableModel {
    protected List<?> columnIdentifiers;
    private boolean useAutoCalculatedIdentifiers;

    public DefaultTreeTableModel() {
        this(null);
    }

    public DefaultTreeTableModel(TreeTableNode treeTableNode) {
        this(treeTableNode, null);
    }

    public DefaultTreeTableModel(TreeTableNode treeTableNode, List<?> list) {
        super(treeTableNode);
        this.setColumnIdentifiers(list);
    }

    private boolean isValidTreeTableNode(Object object) {
        boolean bl = false;
        if (object instanceof TreeTableNode) {
            for (TreeTableNode treeTableNode = (TreeTableNode)object; !bl && treeTableNode != null; treeTableNode = treeTableNode.getParent()) {
                bl = treeTableNode == this.root;
            }
        }
        return bl;
    }

    public void setColumnIdentifiers(List<?> list) {
        this.useAutoCalculatedIdentifiers = list == null;
        this.columnIdentifiers = this.useAutoCalculatedIdentifiers ? DefaultTreeTableModel.getAutoCalculatedIdentifiers(this.getRoot()) : list;
        this.modelSupport.fireNewRoot();
    }

    private static List<String> getAutoCalculatedIdentifiers(TreeTableNode treeTableNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (treeTableNode != null) {
            int n = treeTableNode.getColumnCount();
            for (int i = 0; i < n; ++i) {
                arrayList.add(null);
            }
        }
        return arrayList;
    }

    @Override
    public TreeTableNode getRoot() {
        return (TreeTableNode)this.root;
    }

    @Override
    public Object getValueAt(Object object, int n) {
        if (!this.isValidTreeTableNode(object)) {
            throw new IllegalArgumentException("node must be a valid node managed by this model");
        }
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be a valid index");
        }
        TreeTableNode treeTableNode = (TreeTableNode)object;
        if (n >= treeTableNode.getColumnCount()) {
            return null;
        }
        return treeTableNode.getValueAt(n);
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
        if (!this.isValidTreeTableNode(object2)) {
            throw new IllegalArgumentException("node must be a valid node managed by this model");
        }
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be a valid index");
        }
        TreeTableNode treeTableNode = (TreeTableNode)object2;
        if (n < treeTableNode.getColumnCount()) {
            treeTableNode.setValueAt(object, n);
            this.modelSupport.firePathChanged(new TreePath(this.getPathToRoot(treeTableNode)));
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    @Override
    public String getColumnName(int n) {
        Object object = null;
        if (n < this.columnIdentifiers.size() && n >= 0) {
            object = this.columnIdentifiers.get(n);
        }
        return object == null ? super.getColumnName(n) : object.toString();
    }

    @Override
    public Object getChild(Object object, int n) {
        if (!this.isValidTreeTableNode(object)) {
            throw new IllegalArgumentException("parent must be a TreeTableNode managed by this model");
        }
        return ((TreeTableNode)object).getChildAt(n);
    }

    @Override
    public int getChildCount(Object object) {
        if (!this.isValidTreeTableNode(object)) {
            throw new IllegalArgumentException("parent must be a TreeTableNode managed by this model");
        }
        return ((TreeTableNode)object).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (!this.isValidTreeTableNode(object) || !this.isValidTreeTableNode(object2)) {
            return -1;
        }
        return ((TreeTableNode)object).getIndex((TreeTableNode)object2);
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        if (!this.isValidTreeTableNode(object)) {
            throw new IllegalArgumentException("node must be a valid node managed by this model");
        }
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be a valid index");
        }
        TreeTableNode treeTableNode = (TreeTableNode)object;
        if (n >= treeTableNode.getColumnCount()) {
            return false;
        }
        return treeTableNode.isEditable(n);
    }

    @Override
    public boolean isLeaf(Object object) {
        if (!this.isValidTreeTableNode(object)) {
            throw new IllegalArgumentException("node must be a TreeTableNode managed by this model");
        }
        return ((TreeTableNode)object).isLeaf();
    }

    public TreeTableNode[] getPathToRoot(TreeTableNode treeTableNode) {
        TreeTableNode treeTableNode2;
        ArrayList<TreeTableNode> arrayList = new ArrayList<TreeTableNode>();
        for (treeTableNode2 = treeTableNode; treeTableNode2 != this.root; treeTableNode2 = treeTableNode2.getParent()) {
            arrayList.add(0, treeTableNode2);
        }
        if (treeTableNode2 == this.root) {
            arrayList.add(0, treeTableNode2);
        }
        return arrayList.toArray(new TreeTableNode[0]);
    }

    public void setRoot(TreeTableNode treeTableNode) {
        this.root = treeTableNode;
        if (this.useAutoCalculatedIdentifiers) {
            this.setColumnIdentifiers(null);
        } else {
            this.modelSupport.fireNewRoot();
        }
    }

    public void insertNodeInto(MutableTreeTableNode mutableTreeTableNode, MutableTreeTableNode mutableTreeTableNode2, int n) {
        mutableTreeTableNode2.insert(mutableTreeTableNode, n);
        this.modelSupport.fireChildAdded(new TreePath(this.getPathToRoot(mutableTreeTableNode2)), n, mutableTreeTableNode);
    }

    public void removeNodeFromParent(MutableTreeTableNode mutableTreeTableNode) {
        MutableTreeTableNode mutableTreeTableNode2 = (MutableTreeTableNode)mutableTreeTableNode.getParent();
        if (mutableTreeTableNode2 == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int n = mutableTreeTableNode2.getIndex(mutableTreeTableNode);
        mutableTreeTableNode.removeFromParent();
        this.modelSupport.fireChildRemoved(new TreePath(this.getPathToRoot(mutableTreeTableNode2)), n, mutableTreeTableNode);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        if (treePath.getPathComponent(0) != this.root) {
            throw new IllegalArgumentException("invalid path");
        }
        TreeTableNode treeTableNode = (TreeTableNode)treePath.getLastPathComponent();
        treeTableNode.setUserObject(object);
        this.modelSupport.firePathChanged(treePath);
    }

    public void setUserObject(TreeTableNode treeTableNode, Object object) {
        this.valueForPathChanged(new TreePath(this.getPathToRoot(treeTableNode)), object);
    }
}

