/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.tree;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.util.Contract;

public final class TreeModelSupport {
    protected EventListenerList listeners;
    private TreeModel treeModel;

    public TreeModelSupport(TreeModel treeModel) {
        if (treeModel == null) {
            throw new NullPointerException("model must not be null");
        }
        this.listeners = new EventListenerList();
        this.treeModel = treeModel;
    }

    public void fireNewRoot() {
        Object object = this.treeModel.getRoot();
        TreePath treePath = object != null ? new TreePath(object) : null;
        this.fireTreeStructureChanged(treePath);
    }

    public void firePathLeafStateChanged(TreePath treePath) {
        this.fireTreeStructureChanged(treePath);
    }

    public void fireTreeStructureChanged(TreePath treePath) {
        if (treePath != null) {
            Contract.asNotNull(treePath.getPath(), "path must not contain null elements");
        }
        Object[] objectArray = this.listeners.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = this.createStructureChangedEvent(treePath);
            }
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public void firePathChanged(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            this.fireChildrenChanged(treePath, null, null);
        } else {
            Object object2 = treePath2.getLastPathComponent();
            this.fireChildChanged(treePath2, this.treeModel.getIndexOfChild(object2, object), object);
        }
    }

    public void fireChildChanged(TreePath treePath, int n, Object object) {
        this.fireChildrenChanged(treePath, new int[]{n}, new Object[]{object});
    }

    public void fireChildrenChanged(TreePath treePath, int[] nArray, Object[] objectArray) {
        Contract.asNotNull(treePath.getPath(), "path must not be null and must not contain null elements");
        Object[] objectArray2 = this.listeners.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
            if (objectArray2[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = this.createTreeModelEvent(treePath, nArray, objectArray);
            }
            ((TreeModelListener)objectArray2[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    public void fireChildAdded(TreePath treePath, int n, Object object) {
        this.fireChildrenAdded(treePath, new int[]{n}, new Object[]{object});
    }

    public void fireChildRemoved(TreePath treePath, int n, Object object) {
        this.fireChildrenRemoved(treePath, new int[]{n}, new Object[]{object});
    }

    public void fireChildrenAdded(TreePath treePath, int[] nArray, Object[] objectArray) {
        Object[] objectArray2 = this.listeners.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
            if (objectArray2[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = this.createTreeModelEvent(treePath, nArray, objectArray);
            }
            ((TreeModelListener)objectArray2[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    public void fireChildrenRemoved(TreePath treePath, int[] nArray, Object[] objectArray) {
        Object[] objectArray2 = this.listeners.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
            if (objectArray2[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = this.createTreeModelEvent(treePath, nArray, objectArray);
            }
            ((TreeModelListener)objectArray2[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    private TreeModelEvent createStructureChangedEvent(TreePath treePath) {
        return this.createTreeModelEvent(treePath, null, null);
    }

    private TreeModelEvent createTreeModelEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        return new TreeModelEvent((Object)this.treeModel, treePath, nArray, objectArray);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(TreeModelListener.class, treeModelListener);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(TreeModelListener.class, treeModelListener);
    }
}

