/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.UIDependent;
import org.jdesktop.swingx.renderer.AbstractRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumnExt
extends TableColumn
implements UIDependent {
    protected boolean visible = true;
    protected Object prototypeValue;
    protected Comparator comparator;
    protected boolean sortable = true;
    protected boolean editable = true;
    private String toolTipText;
    protected Hashtable<Object, Object> clientProperties;
    protected CompoundHighlighter compoundHighlighter;
    private ChangeListener highlighterChangeListener;
    private boolean ignoreHighlighterStateChange;

    public TableColumnExt() {
        this(0);
    }

    public TableColumnExt(int n) {
        this(n, 75);
    }

    public TableColumnExt(int n, int n2) {
        this(n, n2, null, null);
    }

    public TableColumnExt(int n, int n2, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        super(n, n2, tableCellRenderer, tableCellEditor);
    }

    public TableColumnExt(TableColumnExt tableColumnExt) {
        this(tableColumnExt.getModelIndex(), tableColumnExt.getWidth(), tableColumnExt.getCellRenderer(), tableColumnExt.getCellEditor());
        this.copyFrom(tableColumnExt);
    }

    public void setHighlighters(Highlighter ... highlighterArray) {
        this.ignoreHighlighterStateChange = true;
        Highlighter[] highlighterArray2 = this.getHighlighters();
        this.getCompoundHighlighter().setHighlighters(highlighterArray);
        this.firePropertyChange("highlighters", highlighterArray2, this.getHighlighters());
        this.ignoreHighlighterStateChange = false;
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter().getHighlighters();
    }

    public void addHighlighter(Highlighter highlighter) {
        this.ignoreHighlighterStateChange = true;
        Highlighter[] highlighterArray = this.getHighlighters();
        this.getCompoundHighlighter().addHighlighter(highlighter);
        this.firePropertyChange("highlighters", highlighterArray, this.getHighlighters());
        this.ignoreHighlighterStateChange = false;
    }

    public void removeHighlighter(Highlighter highlighter) {
        this.ignoreHighlighterStateChange = true;
        Highlighter[] highlighterArray = this.getHighlighters();
        this.getCompoundHighlighter().removeHighlighter(highlighter);
        this.firePropertyChange("highlighters", highlighterArray, this.getHighlighters());
        this.ignoreHighlighterStateChange = false;
    }

    protected CompoundHighlighter getCompoundHighlighter() {
        if (this.compoundHighlighter == null) {
            this.compoundHighlighter = new CompoundHighlighter(new Highlighter[0]);
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        return this.compoundHighlighter;
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (TableColumnExt.this.ignoreHighlighterStateChange) {
                    return;
                }
                TableColumnExt.this.firePropertyChange("highlighterStateChanged", false, true);
            }
        };
    }

    @Override
    public boolean getResizable() {
        return super.getResizable() && this.getMinWidth() < this.getMaxWidth();
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange("editable", bl2, bl);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setPrototypeValue(Object object) {
        Object object2 = this.prototypeValue;
        this.prototypeValue = object;
        this.firePropertyChange("prototypeValue", object2, object);
    }

    public Object getPrototypeValue() {
        return this.prototypeValue;
    }

    public void setComparator(Comparator comparator) {
        Comparator comparator2 = this.getComparator();
        this.comparator = comparator;
        this.firePropertyChange("comparator", comparator2, this.getComparator());
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setSortable(boolean bl) {
        boolean bl2 = this.isSortable();
        this.sortable = bl;
        this.firePropertyChange("sortable", bl2, this.isSortable());
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setToolTipText(String string) {
        String string2 = this.getToolTipText();
        this.toolTipText = string;
        this.firePropertyChange("toolTipText", string2, this.getToolTipText());
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setTitle(String string) {
        this.setHeaderValue(string);
    }

    public String getTitle() {
        Object object = this.getHeaderValue();
        return object != null ? object.toString() : null;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.visible;
        this.visible = bl;
        this.firePropertyChange("visible", bl2, bl);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void putClientProperty(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("null key");
        }
        if (object2 == null && this.getClientProperty(object) == null) {
            return;
        }
        Object object3 = this.getClientProperty(object);
        if (object2 == null) {
            this.getClientProperties().remove(object);
        } else {
            this.getClientProperties().put(object, object2);
        }
        this.firePropertyChange(object.toString(), object3, object2);
    }

    public Object getClientProperty(Object object) {
        return object == null || this.clientProperties == null ? null : this.clientProperties.get(object);
    }

    private Hashtable<Object, Object> getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    protected void copyFrom(TableColumnExt tableColumnExt) {
        this.setEditable(tableColumnExt.isEditable());
        this.setHeaderValue(tableColumnExt.getHeaderValue());
        this.setToolTipText(tableColumnExt.getToolTipText());
        this.setIdentifier(tableColumnExt.getIdentifier());
        this.setMaxWidth(tableColumnExt.getMaxWidth());
        this.setMinWidth(tableColumnExt.getMinWidth());
        this.setPreferredWidth(tableColumnExt.getPreferredWidth());
        this.setPrototypeValue(tableColumnExt.getPrototypeValue());
        this.setResizable(tableColumnExt.isResizable);
        this.setVisible(tableColumnExt.isVisible());
        this.setSortable(tableColumnExt.isSortable());
        this.setComparator(tableColumnExt.getComparator());
        this.copyClientPropertiesFrom(tableColumnExt);
        if (tableColumnExt.compoundHighlighter != null) {
            this.setHighlighters(tableColumnExt.getHighlighters());
        }
    }

    protected void copyClientPropertiesFrom(TableColumnExt tableColumnExt) {
        if (tableColumnExt.clientProperties == null) {
            return;
        }
        for (Object object : tableColumnExt.clientProperties.keySet()) {
            this.putClientProperty(object, tableColumnExt.getClientProperty(object));
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeListener[] propertyChangeListenerArray;
        if ((object != null && !object.equals(object2) || object == null && object2 != null) && (propertyChangeListenerArray = this.getPropertyChangeListeners()) != null && propertyChangeListenerArray.length != 0) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                propertyChangeListenerArray[i].propertyChange(propertyChangeEvent);
            }
        }
    }

    @Override
    public void updateUI() {
        this.updateHighlighterUI();
        this.updateRendererUI(this.getCellRenderer());
        this.updateRendererUI(this.getHeaderRenderer());
        this.updateEditorUI(this.getCellEditor());
    }

    private void updateEditorUI(TableCellEditor tableCellEditor) {
        if (tableCellEditor == null) {
            return;
        }
        if (tableCellEditor instanceof JComponent || tableCellEditor instanceof DefaultCellEditor) {
            return;
        }
        try {
            Component component = tableCellEditor.getTableCellEditorComponent(null, null, false, -1, -1);
            if (component != null) {
                SwingUtilities.updateComponentTreeUI(component);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateRendererUI(TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer == null) {
            return;
        }
        if (tableCellRenderer instanceof JComponent) {
            return;
        }
        Component component = null;
        if (tableCellRenderer instanceof AbstractRenderer) {
            component = (Component)((AbstractRenderer)((Object)tableCellRenderer)).getComponentProvider().getRendererComponent(null);
        } else {
            try {
                component = tableCellRenderer.getTableCellRendererComponent(null, null, false, false, -1, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (component != null) {
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    private void updateHighlighterUI() {
        if (this.compoundHighlighter == null) {
            return;
        }
        this.compoundHighlighter.updateUI();
    }
}

