/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.table.TableCellRenderer;

public class LabelProperties
extends JLabel {
    private int setFlags = 0;

    public LabelProperties() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if (string.equals("background")) {
                    if (object != null) {
                        LabelProperties.this.setFlags |= 1;
                    } else {
                        LabelProperties.this.setFlags &= -2;
                    }
                } else if (string.equals("font")) {
                    if (object != null) {
                        LabelProperties.this.setFlags |= 4;
                    } else {
                        LabelProperties.this.setFlags &= -5;
                    }
                } else if (string.equals("foreground")) {
                    if (object != null) {
                        LabelProperties.this.setFlags |= 2;
                    } else {
                        LabelProperties.this.setFlags &= -3;
                    }
                } else if (string.equals("horizontalAlignment")) {
                    if (object != null && (Integer)object != -1) {
                        LabelProperties.this.setFlags |= 8;
                    } else {
                        LabelProperties.this.setFlags &= -9;
                    }
                } else if (string.equals("horizontalTextPosition")) {
                    if (object != null && (Integer)object != -1) {
                        LabelProperties.this.setFlags |= 16;
                    } else {
                        LabelProperties.this.setFlags &= -17;
                    }
                } else if (string.equals("icon")) {
                    if (object != null) {
                        LabelProperties.this.setFlags |= 32;
                    } else {
                        LabelProperties.this.setFlags &= -33;
                    }
                } else if (string.equals("iconTextGap")) {
                    if (object != null && (Integer)object != -1) {
                        LabelProperties.this.setFlags |= 64;
                    } else {
                        LabelProperties.this.setFlags &= -65;
                    }
                } else if (string.equals("text")) {
                    if (object != null) {
                        LabelProperties.this.setFlags |= 128;
                    } else {
                        LabelProperties.this.setFlags &= -129;
                    }
                } else if (string.equals("verticalAlignment")) {
                    if (object != null && (Integer)object != -1) {
                        LabelProperties.this.setFlags |= 256;
                    } else {
                        LabelProperties.this.setFlags &= -257;
                    }
                } else if (string.equals("verticalTextPosition")) {
                    if (object != null && (Integer)object != -1) {
                        LabelProperties.this.setFlags |= 512;
                    } else {
                        LabelProperties.this.setFlags &= -513;
                    }
                }
            }
        });
    }

    public LabelProperties(Color color, Color color2, Font font, int n, int n2, int n3, int n4, Icon icon, int n5, String string) {
        this();
        this.setBackground(color);
        this.setForeground(color2);
        this.setFont(font);
        this.setHorizontalAlignment(n);
        this.setHorizontalTextPosition(n2);
        this.setVerticalAlignment(n3);
        this.setVerticalTextPosition(n4);
        this.setIcon(icon);
        this.setIconTextGap(n5);
        this.setText(string);
    }

    public boolean isBackgroundSet() {
        return (this.setFlags & 1) > 0;
    }

    public boolean isForegroundSet() {
        return (this.setFlags & 2) > 0;
    }

    public boolean isFontSet() {
        return (this.setFlags & 4) > 0;
    }

    public boolean isHorizontalAlignmentSet() {
        return (this.setFlags & 8) > 0;
    }

    public boolean isHorizontalTextPositionSet() {
        return (this.setFlags & 0x10) > 0;
    }

    public boolean isIconSet() {
        return (this.setFlags & 0x20) > 0;
    }

    public boolean isIconTextGapSet() {
        return (this.setFlags & 0x40) > 0;
    }

    public boolean isTextSet() {
        return (this.setFlags & 0x80) > 0;
    }

    public boolean isVerticalAlignmentSet() {
        return (this.setFlags & 0x100) > 0;
    }

    public boolean isVerticalTextPositionSet() {
        return (this.setFlags & 0x200) > 0;
    }

    public boolean noPropertiesSet() {
        return this.setFlags == 0;
    }

    public void applyPropertiesTo(JLabel jLabel) {
        if (this.noPropertiesSet()) {
            return;
        }
        if (this.isBackgroundSet()) {
            jLabel.setBackground(this.getBackground());
        }
        if (this.isForegroundSet()) {
            jLabel.setForeground(this.getForeground());
        }
        if (this.isFontSet()) {
            jLabel.setFont(this.getFont());
        }
        if (this.isHorizontalAlignmentSet()) {
            jLabel.setHorizontalAlignment(this.getHorizontalAlignment());
        }
        if (this.isHorizontalTextPositionSet()) {
            jLabel.setHorizontalTextPosition(this.getHorizontalTextPosition());
        }
        if (this.isIconSet()) {
            jLabel.setIcon(this.getIcon());
        }
        if (this.isIconTextGapSet()) {
            jLabel.setIconTextGap(this.getIconTextGap());
        }
        if (this.isTextSet()) {
            jLabel.setText(this.getText());
        }
        if (this.isVerticalAlignmentSet()) {
            jLabel.setVerticalAlignment(this.getVerticalAlignment());
        }
        if (this.isVerticalTextPositionSet()) {
            jLabel.setVerticalTextPosition(this.getVerticalTextPosition());
        }
    }

    public void applyPropertiesTo(AbstractButton abstractButton) {
        if (this.noPropertiesSet()) {
            return;
        }
        if (this.isBackgroundSet()) {
            abstractButton.setBackground(this.getBackground());
        }
        if (this.isForegroundSet()) {
            abstractButton.setForeground(this.getForeground());
        }
        if (this.isFontSet()) {
            abstractButton.setFont(this.getFont());
        }
        if (this.isHorizontalAlignmentSet()) {
            abstractButton.setHorizontalAlignment(this.getHorizontalAlignment());
        }
        if (this.isHorizontalTextPositionSet()) {
            abstractButton.setHorizontalTextPosition(this.getHorizontalTextPosition());
        }
        if (this.isIconSet()) {
            abstractButton.setIcon(this.getIcon());
        }
        if (this.isIconTextGapSet()) {
            abstractButton.setIconTextGap(this.getIconTextGap());
        }
        if (this.isTextSet()) {
            abstractButton.setText(this.getText());
        }
        if (this.isVerticalAlignmentSet()) {
            abstractButton.setVerticalAlignment(this.getVerticalAlignment());
        }
        if (this.isVerticalTextPositionSet()) {
            abstractButton.setVerticalTextPosition(this.getVerticalTextPosition());
        }
    }

    public void applyPropertiesTo(LabelProperties labelProperties) {
        if (this.noPropertiesSet()) {
            return;
        }
        if (this.isBackgroundSet()) {
            labelProperties.setBackground(this.getBackground());
        }
        if (this.isForegroundSet()) {
            labelProperties.setForeground(this.getForeground());
        }
        if (this.isFontSet()) {
            labelProperties.setFont(this.getFont());
        }
        if (this.isHorizontalAlignmentSet()) {
            labelProperties.setHorizontalAlignment(this.getHorizontalAlignment());
        }
        if (this.isHorizontalTextPositionSet()) {
            labelProperties.setHorizontalTextPosition(this.getHorizontalTextPosition());
        }
        if (this.isIconSet()) {
            labelProperties.setIcon(this.getIcon());
        }
        if (this.isIconTextGapSet()) {
            labelProperties.setIconTextGap(this.getIconTextGap());
        }
        if (this.isTextSet()) {
            labelProperties.setText(this.getText());
        }
        if (this.isVerticalAlignmentSet()) {
            labelProperties.setVerticalAlignment(this.getVerticalAlignment());
        }
        if (this.isVerticalTextPositionSet()) {
            labelProperties.setVerticalTextPosition(this.getVerticalTextPosition());
        }
    }

    public void applyPropertiesTo(TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer instanceof JLabel) {
            this.applyPropertiesTo((JLabel)((Object)tableCellRenderer));
        } else if (tableCellRenderer instanceof AbstractButton) {
            this.applyPropertiesTo((AbstractButton)((Object)tableCellRenderer));
        }
    }
}

