/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class ColumnFactory {
    private static ColumnFactory columnFactory;
    private int packMargin = 4;

    public static synchronized ColumnFactory getInstance() {
        if (columnFactory == null) {
            columnFactory = new ColumnFactory();
        }
        return columnFactory;
    }

    public static synchronized void setInstance(ColumnFactory columnFactory) {
        ColumnFactory.columnFactory = columnFactory;
    }

    public TableColumnExt createAndConfigureTableColumn(TableModel tableModel, int n) {
        TableColumnExt tableColumnExt = this.createTableColumn(n);
        if (tableColumnExt != null) {
            this.configureTableColumn(tableModel, tableColumnExt);
        }
        return tableColumnExt;
    }

    public TableColumnExt createTableColumn(int n) {
        return new TableColumnExt(n);
    }

    public void configureTableColumn(TableModel tableModel, TableColumnExt tableColumnExt) {
        if (tableColumnExt.getModelIndex() < 0 || tableColumnExt.getModelIndex() >= tableModel.getColumnCount()) {
            throw new IllegalStateException("column must have valid modelIndex");
        }
        tableColumnExt.setHeaderValue(tableModel.getColumnName(tableColumnExt.getModelIndex()));
    }

    public void configureColumnWidths(JXTable jXTable, TableColumnExt tableColumnExt) {
        int n = 75 - jXTable.getColumnMargin();
        int n2 = this.calcPrototypeWidth(jXTable, tableColumnExt);
        if (n2 > 0) {
            n = n2;
        }
        int n3 = this.calcHeaderWidth(jXTable, tableColumnExt);
        n = Math.max(n, n3);
        tableColumnExt.setPreferredWidth(n += jXTable.getColumnModel().getColumnMargin());
    }

    public int getPreferredScrollableViewportWidth(JXTable jXTable) {
        int n = 0;
        int n2 = jXTable.getVisibleColumnCount() < 0 ? jXTable.getColumnCount() : Math.min(jXTable.getColumnCount(), jXTable.getVisibleColumnCount());
        for (int i = 0; i < n2; ++i) {
            n += jXTable.getColumn(i).getPreferredWidth();
        }
        if (n2 < jXTable.getVisibleColumnCount()) {
            n += (jXTable.getVisibleColumnCount() - n2) * 75;
        }
        return n;
    }

    protected int calcHeaderWidth(JXTable jXTable, TableColumnExt tableColumnExt) {
        int n = -1;
        TableCellRenderer tableCellRenderer = this.getHeaderRenderer(jXTable, tableColumnExt);
        if (tableCellRenderer != null) {
            Component component = tableCellRenderer.getTableCellRendererComponent(jXTable, tableColumnExt.getHeaderValue(), false, false, -1, -1);
            n = component.getPreferredSize().width;
        }
        return n;
    }

    protected int calcPrototypeWidth(JXTable jXTable, TableColumnExt tableColumnExt) {
        int n = -1;
        Object object = tableColumnExt.getPrototypeValue();
        if (object != null) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(jXTable, tableColumnExt);
            Component component = tableCellRenderer.getTableCellRendererComponent(jXTable, object, false, false, 0, -1);
            n = component.getPreferredSize().width;
        }
        return n;
    }

    protected TableCellRenderer getCellRenderer(JXTable jXTable, TableColumnExt tableColumnExt) {
        int n = jXTable.convertColumnIndexToView(tableColumnExt.getModelIndex());
        if (n >= 0) {
            return jXTable.getCellRenderer(0, n);
        }
        TableCellRenderer tableCellRenderer = tableColumnExt.getCellRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jXTable.getDefaultRenderer(jXTable.getModel().getColumnClass(tableColumnExt.getModelIndex()));
        }
        return tableCellRenderer;
    }

    protected TableCellRenderer getHeaderRenderer(JXTable jXTable, TableColumnExt tableColumnExt) {
        JTableHeader jTableHeader;
        TableCellRenderer tableCellRenderer = tableColumnExt.getHeaderRenderer();
        if (tableCellRenderer == null && (jTableHeader = jXTable.getTableHeader()) != null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        return tableCellRenderer;
    }

    public void packColumn(JXTable jXTable, TableColumnExt tableColumnExt, int n, int n2) {
        Object object;
        if (!tableColumnExt.isVisible()) {
            throw new IllegalStateException("column must be visible to pack");
        }
        int n3 = jXTable.convertColumnIndexToView(tableColumnExt.getModelIndex());
        int n4 = 0;
        TableCellRenderer tableCellRenderer = this.getHeaderRenderer(jXTable, tableColumnExt);
        if (tableCellRenderer != null) {
            object = tableCellRenderer.getTableCellRendererComponent(jXTable, tableColumnExt.getHeaderValue(), false, false, 0, n3);
            n4 = ((Component)object).getPreferredSize().width;
        }
        object = this.getCellRenderer(jXTable, tableColumnExt);
        for (int i = 0; i < this.getRowCount(jXTable); ++i) {
            Component component = object.getTableCellRendererComponent(jXTable, jXTable.getValueAt(i, n3), false, false, i, n3);
            n4 = Math.max(n4, component.getPreferredSize().width);
        }
        if (n < 0) {
            n = this.getDefaultPackMargin();
        }
        if (n2 != -1 && (n4 += 2 * n) > n2) {
            n4 = n2;
        }
        tableColumnExt.setPreferredWidth(n4);
    }

    protected int getRowCount(JXTable jXTable) {
        return jXTable.getRowCount();
    }

    public int getDefaultPackMargin() {
        return this.packMargin;
    }

    public void setDefaultPackMargin(int n) {
        this.packMargin = n;
    }
}

