/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.search.AbstractSearchable;

public class TreeSearchable
extends AbstractSearchable {
    protected JXTree tree;

    public TreeSearchable(JXTree jXTree) {
        this.tree = jXTree;
    }

    protected void findMatchAndUpdateState(Pattern pattern, int n, boolean bl) {
        AbstractSearchable.SearchResult searchResult = null;
        if (bl) {
            for (int i = n; i >= 0 && searchResult == null; --i) {
                searchResult = this.findMatchAt(pattern, i);
            }
        } else {
            for (int i = n; i < this.getSize() && searchResult == null; ++i) {
                searchResult = this.findMatchAt(pattern, i);
            }
        }
        this.updateState(searchResult);
    }

    protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int n) {
        return this.findMatchAt(pattern, n);
    }

    protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int n) {
        Matcher matcher;
        String string = this.tree.getStringAt(n);
        if (string != null && string.length() > 0 && (matcher = pattern.matcher(string)).find()) {
            return this.createSearchResult(matcher, n, 0);
        }
        return null;
    }

    protected int getSize() {
        return this.tree.getRowCount();
    }

    public JXTree getTarget() {
        return this.tree;
    }

    protected void moveMatchMarker() {
        if (this.markByHighlighter()) {
            this.moveMatchByHighlighter();
        } else {
            this.moveMatchBySelection();
        }
    }

    protected void moveMatchBySelection() {
        if (!this.hasMatch()) {
            return;
        }
        this.tree.setSelectionRow(this.lastSearchResult.foundRow);
        this.tree.scrollRowToVisible(this.lastSearchResult.foundRow);
    }

    protected void moveMatchByHighlighter() {
        AbstractHighlighter abstractHighlighter = this.getConfiguredMatchHighlighter();
        if (!this.hasMatch()) {
            return;
        }
        this.ensureInsertedSearchHighlighters(abstractHighlighter);
        this.tree.scrollRowToVisible(this.lastSearchResult.foundRow);
    }

    protected void removeHighlighter(Highlighter highlighter) {
        this.tree.removeHighlighter(highlighter);
    }

    protected Highlighter[] getHighlighters() {
        return this.tree.getHighlighters();
    }

    protected void addHighlighter(Highlighter highlighter) {
        this.tree.addHighlighter(highlighter);
    }
}

