/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.search.AbstractSearchable;

public class ListSearchable
extends AbstractSearchable {
    protected JXList list;

    public ListSearchable(JXList jXList) {
        this.list = jXList;
    }

    protected void findMatchAndUpdateState(Pattern pattern, int n, boolean bl) {
        AbstractSearchable.SearchResult searchResult = null;
        if (bl) {
            for (int i = n; i >= 0 && searchResult == null; --i) {
                searchResult = this.findMatchAt(pattern, i);
            }
        } else {
            for (int i = n; i < this.getSize() && searchResult == null; ++i) {
                searchResult = this.findMatchAt(pattern, i);
            }
        }
        this.updateState(searchResult);
    }

    protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int n) {
        return this.findMatchAt(pattern, n);
    }

    protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int n) {
        Matcher matcher;
        String string = this.list.getStringAt(n);
        if (string != null && string.length() > 0 && (matcher = pattern.matcher(string)).find()) {
            return this.createSearchResult(matcher, n, 0);
        }
        return null;
    }

    protected int getSize() {
        return this.list.getElementCount();
    }

    public JXList getTarget() {
        return this.list;
    }

    protected void moveMatchMarker() {
        if (this.markByHighlighter()) {
            this.moveMatchByHighlighter();
        } else {
            this.moveMatchBySelection();
        }
    }

    protected void moveMatchBySelection() {
        if (!this.hasMatch()) {
            return;
        }
        this.list.setSelectedIndex(this.lastSearchResult.foundRow);
        this.list.ensureIndexIsVisible(this.lastSearchResult.foundRow);
    }

    protected void moveMatchByHighlighter() {
        AbstractHighlighter abstractHighlighter = this.getConfiguredMatchHighlighter();
        if (!this.hasMatch()) {
            return;
        }
        this.ensureInsertedSearchHighlighters(abstractHighlighter);
        this.list.ensureIndexIsVisible(this.lastSearchResult.foundRow);
    }

    protected void removeHighlighter(Highlighter highlighter) {
        this.list.removeHighlighter(highlighter);
    }

    protected Highlighter[] getHighlighters() {
        return this.list.getHighlighters();
    }

    protected void addHighlighter(Highlighter highlighter) {
        this.list.addHighlighter(highlighter);
    }
}

