/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.awt.Color;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.SearchPredicate;
import org.jdesktop.swingx.search.Searchable;

public abstract class AbstractSearchable
implements Searchable {
    protected final SearchResult lastSearchResult = new SearchResult();
    private AbstractHighlighter matchHighlighter;
    public static final String MATCH_HIGHLIGHTER = "match.highlighter";

    public int search(String string) {
        return this.search(string, -1);
    }

    public int search(String string, int n) {
        return this.search(string, n, false);
    }

    public int search(String string, int n, boolean bl) {
        Pattern pattern = null;
        if (!this.isEmpty(string)) {
            pattern = Pattern.compile(string, 0);
        }
        return this.search(pattern, n, bl);
    }

    public int search(Pattern pattern) {
        return this.search(pattern, -1);
    }

    public int search(Pattern pattern, int n) {
        return this.search(pattern, n, false);
    }

    public int search(Pattern pattern, int n, boolean bl) {
        int n2 = this.doSearch(pattern, n, bl);
        this.moveMatchMarker();
        return n2;
    }

    protected int doSearch(Pattern pattern, int n, boolean bl) {
        int n2;
        if (this.isTrivialNoMatch(pattern, n)) {
            this.updateState(null);
            return this.lastSearchResult.foundRow;
        }
        if (this.isEqualStartIndex(n)) {
            SearchResult searchResult;
            if (!this.isEqualPattern(pattern) && (searchResult = this.findExtendedMatch(pattern, n)) != null) {
                this.updateState(searchResult);
                return this.lastSearchResult.foundRow;
            }
            n2 = this.moveStartPosition(n, bl);
        } else {
            n2 = this.adjustStartPosition(n, bl);
        }
        this.findMatchAndUpdateState(pattern, n2, bl);
        return this.lastSearchResult.foundRow;
    }

    protected abstract void findMatchAndUpdateState(Pattern var1, int var2, boolean var3);

    protected boolean isTrivialNoMatch(Pattern pattern, int n) {
        return pattern == null || n >= this.getSize();
    }

    protected int adjustStartPosition(int n, boolean bl) {
        if (n < 0) {
            if (bl) {
                return this.getSize() - 1;
            }
            return 0;
        }
        return n;
    }

    protected int moveStartPosition(int n, boolean bl) {
        n = bl ? --n : ++n;
        return n;
    }

    protected boolean isEqualPattern(Pattern pattern) {
        return pattern.pattern().equals(this.lastSearchResult.getRegEx());
    }

    protected boolean isEqualStartIndex(int n) {
        return this.isValidIndex(n) && n == this.lastSearchResult.foundRow;
    }

    protected boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    protected abstract SearchResult findExtendedMatch(Pattern var1, int var2);

    protected SearchResult createSearchResult(Matcher matcher, int n, int n2) {
        return new SearchResult(matcher.pattern(), matcher.toMatchResult(), n, n2);
    }

    protected boolean isValidIndex(int n) {
        return n >= 0 && n < this.getSize();
    }

    protected abstract int getSize();

    protected void updateState(SearchResult searchResult) {
        this.lastSearchResult.updateFrom(searchResult);
    }

    protected abstract void moveMatchMarker();

    public abstract JComponent getTarget();

    protected abstract void removeHighlighter(Highlighter var1);

    protected abstract Highlighter[] getHighlighters();

    protected abstract void addHighlighter(Highlighter var1);

    protected void ensureInsertedSearchHighlighters(Highlighter highlighter) {
        if (!this.isInPipeline(highlighter)) {
            this.addHighlighter(highlighter);
        }
    }

    private boolean isInPipeline(Highlighter highlighter) {
        Highlighter[] highlighterArray = this.getHighlighters();
        if (highlighterArray.length > 0 && highlighter.equals(highlighterArray[highlighterArray.length - 1])) {
            return true;
        }
        this.removeHighlighter(highlighter);
        return false;
    }

    protected int convertColumnIndexToModel(int n) {
        return n;
    }

    private boolean hasMatch(SearchResult searchResult) {
        boolean bl = searchResult.getFoundRow() < 0 || searchResult.getFoundColumn() < 0;
        return !bl;
    }

    protected boolean hasMatch() {
        return this.hasMatch(this.lastSearchResult);
    }

    protected boolean markByHighlighter() {
        return Boolean.TRUE.equals(this.getTarget().getClientProperty(MATCH_HIGHLIGHTER));
    }

    public void setMatchHighlighter(AbstractHighlighter abstractHighlighter) {
        this.removeHighlighter(this.matchHighlighter);
        this.matchHighlighter = abstractHighlighter;
        if (this.markByHighlighter()) {
            this.getConfiguredMatchHighlighter();
        }
    }

    protected AbstractHighlighter getMatchHighlighter() {
        if (this.matchHighlighter == null) {
            this.matchHighlighter = this.createMatchHighlighter();
        }
        return this.matchHighlighter;
    }

    protected AbstractHighlighter createMatchHighlighter() {
        return new ColorHighlighter(HighlightPredicate.NEVER, Color.YELLOW.brighter(), null, Color.YELLOW.brighter(), null);
    }

    protected AbstractHighlighter getConfiguredMatchHighlighter() {
        AbstractHighlighter abstractHighlighter = this.getMatchHighlighter();
        abstractHighlighter.setHighlightPredicate(this.createMatchPredicate());
        return abstractHighlighter;
    }

    protected HighlightPredicate createMatchPredicate() {
        return this.hasMatch() ? new SearchPredicate(this.lastSearchResult.pattern, this.lastSearchResult.foundRow, this.convertColumnIndexToModel(this.lastSearchResult.foundColumn)) : HighlightPredicate.NEVER;
    }

    public static class SearchResult {
        int foundRow;
        int foundColumn;
        MatchResult matchResult;
        Pattern pattern;

        public SearchResult() {
            this.reset();
        }

        public SearchResult(Pattern pattern, MatchResult matchResult, int n, int n2) {
            this.pattern = pattern;
            this.matchResult = matchResult;
            this.foundRow = n;
            this.foundColumn = n2;
        }

        public void updateFrom(SearchResult searchResult) {
            if (searchResult == null) {
                this.reset();
                return;
            }
            this.foundRow = searchResult.foundRow;
            this.foundColumn = searchResult.foundColumn;
            this.matchResult = searchResult.matchResult;
            this.pattern = searchResult.pattern;
        }

        public String getRegEx() {
            return this.pattern != null ? this.pattern.pattern() : null;
        }

        public void reset() {
            this.foundRow = -1;
            this.foundColumn = -1;
            this.matchResult = null;
            this.pattern = null;
        }

        public void resetFoundColumn() {
            this.foundColumn = -1;
        }

        public int getFoundColumn() {
            return this.foundColumn;
        }

        public int getFoundRow() {
            return this.foundRow;
        }

        public MatchResult getMatchResult() {
            return this.matchResult;
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

