/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.rollover.RolloverProducer;

public class TreeRolloverProducer
extends RolloverProducer {
    public void mousePressed(MouseEvent mouseEvent) {
        JXTree jXTree = (JXTree)mouseEvent.getComponent();
        Point point = mouseEvent.getPoint();
        int n = jXTree.getRowForLocation(point.x, point.y);
        if (n >= 0) {
            return;
        }
        int n2 = jXTree.getClosestRowForLocation(point.x, point.y);
        Rectangle rectangle = jXTree.getRowBounds(n2);
        if (rectangle == null) {
            n2 = -1;
        } else if (rectangle.y + rectangle.height < point.y || rectangle.x > point.x) {
            n2 = -1;
        }
        if (n2 < 0) {
            return;
        }
        jXTree.dispatchEvent(new MouseEvent(jXTree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), rectangle.x + rectangle.width - 2, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
    }

    protected void updateRolloverPoint(JComponent jComponent, Point point) {
        int n;
        JXTree jXTree = (JXTree)jComponent;
        int n2 = jXTree.getClosestRowForLocation(point.x, point.y);
        Rectangle rectangle = jXTree.getRowBounds(n2);
        if (rectangle == null) {
            n2 = -1;
        } else if (rectangle.y + rectangle.height < point.y || rectangle.x > point.x) {
            n2 = -1;
        }
        this.rollover.x = n = n2 < 0 ? -1 : 0;
        this.rollover.y = n2;
    }
}

