/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public abstract class RolloverProducer
implements MouseListener,
MouseMotionListener {
    public static final String CLICKED_KEY = "swingx.clicked";
    public static final String ROLLOVER_KEY = "swingx.rollover";
    protected Point rollover = new Point(-1, -1);

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateRollover(mouseEvent, CLICKED_KEY, true);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateRollover(mouseEvent, ROLLOVER_KEY, false);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ((JComponent)mouseEvent.getSource()).putClientProperty(ROLLOVER_KEY, null);
        ((JComponent)mouseEvent.getSource()).putClientProperty(CLICKED_KEY, null);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateRollover(mouseEvent, ROLLOVER_KEY, false);
    }

    protected void updateRollover(MouseEvent mouseEvent, String string, boolean bl) {
        this.updateRolloverPoint((JComponent)mouseEvent.getComponent(), mouseEvent.getPoint());
        this.updateClientProperty((JComponent)mouseEvent.getSource(), string, bl);
    }

    protected void updateClientProperty(JComponent jComponent, String string, boolean bl) {
        if (bl) {
            jComponent.putClientProperty(string, null);
            jComponent.putClientProperty(string, new Point(this.rollover));
        } else {
            Point point = (Point)jComponent.getClientProperty(string);
            if (point == null || this.rollover.x != point.x || this.rollover.y != point.y) {
                jComponent.putClientProperty(string, new Point(this.rollover));
            }
        }
    }

    protected abstract void updateRolloverPoint(JComponent var1, Point var2);
}

