/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.renderer.CellContext;

public class TreeCellContext
extends CellContext {
    protected Icon leafIcon;
    protected Icon closedIcon;
    protected Icon openIcon;
    private Border treeFocusBorder;

    public void installContext(JTree jTree, Object object, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.component = jTree;
        this.installState(object, n, n2, bl, bl2, bl3, bl4);
        this.dropOn = this.checkDropOnState();
    }

    private boolean checkDropOnState() {
        if (this.getComponent() == null) {
            return false;
        }
        JTree.DropLocation dropLocation = this.getComponent().getDropLocation();
        return dropLocation != null && dropLocation.getChildIndex() == -1 && this.getComponent().getRowForPath(dropLocation.getPath()) == this.row;
    }

    public JTree getComponent() {
        return (JTree)super.getComponent();
    }

    public TreePath getTreePath() {
        if (this.getComponent() == null) {
            return null;
        }
        if (this.row < 0 || this.row >= this.getComponent().getRowCount()) {
            return null;
        }
        return this.getComponent().getPathForRow(this.row);
    }

    public boolean isEditable() {
        return false;
    }

    protected Color getSelectionBackground() {
        Color color = null;
        if (this.isDropOn() && (color = this.getDropCellBackground()) != null) {
            return color;
        }
        if (this.getComponent() instanceof JXTree) {
            return ((JXTree)this.getComponent()).getSelectionBackground();
        }
        return UIManager.getColor("Tree.selectionBackground");
    }

    protected Color getSelectionForeground() {
        Color color = null;
        if (this.isDropOn() && (color = this.getDropCellForeground()) != null) {
            return color;
        }
        if (this.getComponent() instanceof JXTree) {
            return ((JXTree)this.getComponent()).getSelectionForeground();
        }
        return UIManager.getColor("Tree.selectionForeground");
    }

    protected String getUIPrefix() {
        return "Tree.";
    }

    protected Icon getLeafIcon() {
        return this.leafIcon != null ? this.leafIcon : UIManager.getIcon(this.getUIKey("leafIcon"));
    }

    protected Icon getOpenIcon() {
        return this.openIcon != null ? this.openIcon : UIManager.getIcon(this.getUIKey("openIcon"));
    }

    protected Icon getClosedIcon() {
        return this.closedIcon != null ? this.closedIcon : UIManager.getIcon(this.getUIKey("closedIcon"));
    }

    public Icon getIcon() {
        if (this.isLeaf()) {
            return this.getLeafIcon();
        }
        if (this.isExpanded()) {
            return this.getOpenIcon();
        }
        return this.getClosedIcon();
    }

    protected Border getFocusBorder() {
        if (this.treeFocusBorder == null) {
            this.treeFocusBorder = new TreeFocusBorder();
        }
        return this.treeFocusBorder;
    }

    public class TreeFocusBorder
    extends LineBorder {
        private Color treeBackground;
        private Color focusColor;

        public TreeFocusBorder() {
            super(Color.BLACK);
            this.treeBackground = TreeCellContext.this.getBackground();
            if (this.treeBackground != null) {
                this.focusColor = new Color(~this.treeBackground.getRGB());
            }
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = UIManager.getColor("Tree.selectionBorderColor");
            if (color != null) {
                this.lineColor = color;
            }
            if (this.isDashed()) {
                if (this.treeBackground != component.getBackground()) {
                    this.treeBackground = component.getBackground();
                    this.focusColor = new Color(~this.treeBackground.getRGB());
                }
                Color color2 = graphics.getColor();
                graphics.setColor(this.focusColor);
                BasicGraphicsUtils.drawDashedRect(graphics, n, n2, n3, n4);
                graphics.setColor(color2);
            } else {
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        }

        private boolean isDashed() {
            return Boolean.TRUE.equals(UIManager.get("Tree.drawDashedFocusIndicator"));
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

