/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.renderer.PainterAware;

public class JRendererCheckBox
extends JCheckBox
implements PainterAware {
    protected Painter painter;

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        Painter painter2 = this.getPainter();
        this.painter = painter;
        if (painter != null) {
            this.setContentAreaFilled(false);
        }
        this.firePropertyChange("painter", painter2, this.getPainter());
    }

    public boolean isOpaque() {
        return this.painter == null;
    }

    public void setToolTipText(String string) {
        this.putClientProperty("ToolTipText", string);
    }

    protected void paintComponent(Graphics graphics) {
        if (this.painter != null) {
            this.paintComponentWithPainter((Graphics2D)graphics);
        } else {
            super.paintComponent(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintPainter(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            this.painter.paint(graphics2D, this, this.getWidth(), this.getHeight());
        }
        finally {
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponentWithPainter(Graphics2D graphics2D) {
        if (this.ui != null) {
            Graphics graphics = graphics2D.create();
            try {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintPainter(graphics2D);
                this.ui.paint(graphics, this);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    public void repaint() {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if ("text".equals(string)) {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

